/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.launching;

import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.launching.XDebugLaunchListener;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.xdebug.GeneralUtils;
import org.eclipse.php.internal.debug.core.xdebug.IDELayer;
import org.eclipse.php.internal.debug.core.xdebug.IDELayerFactory;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpBreakpointFacade;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpElement;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpMultiSessionTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpUtils;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSessionHandler;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.IDBGpSessionListener;
import org.eclipse.php.internal.debug.daemon.DaemonPlugin;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.internal.browser.WebBrowserPreference;

public class XDebugWebLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        String[] stringArray;
        String string2;
        String string3;
        IProject iProject;
        Server server;
        block16: {
            if (!DaemonPlugin.getDefault().validateCommunicationDaemons("org.eclipse.php.debug.core.zendDebugger")) {
                iProgressMonitor.setCanceled(true);
                iProgressMonitor.done();
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(iLaunch);
                return;
            }
            if (string.equals("debug")) {
                if (XDebugLaunchListener.getInstance().isWebLaunchActive()) {
                    this.displayErrorMessage("Web Launch Already Running");
                    DebugPlugin.getDefault().getLaunchManager().removeLaunch(iLaunch);
                    return;
                }
                PHPLaunchUtilities.showDebugView();
            }
            if ((server = ServersManager.getServer((String)iLaunchConfiguration.getAttribute("name", ""))) == null) {
                Logger.log(4, "Launch configuration could not find server");
                this.displayErrorMessage("Could not launch.\nInvalid server configuration.");
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(iLaunch);
                return;
            }
            String string4 = iLaunchConfiguration.getAttribute("file_name", null);
            Path path = new Path(string4);
            iProject = null;
            try {
                iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
            }
            catch (Throwable throwable) {
                if (iProject != null) break block16;
                Logger.logException("Could not execute the debug (Project is null).", throwable);
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(iLaunch);
                return;
            }
        }
        ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfiguration.getWorkingCopy();
        String string5 = iProject.getFullPath().toString();
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.php.debug.core.PHP_Project", string5);
        iLaunchConfigurationWorkingCopy.doSave();
        IDELayer iDELayer = IDELayerFactory.getIDELayer();
        boolean bl = PHPProjectPreferences.getStopAtFirstLine(iProject);
        bl = iLaunchConfigurationWorkingCopy.getAttribute("firstLineBreakpoint", bl);
        final boolean bl2 = this.openExternal();
        final Exception[] exceptionArray = new Exception[1];
        final IWebBrowser[] iWebBrowserArray = new IWebBrowser[1];
        if (bl2) {
            iWebBrowserArray[0] = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
        }
        String string6 = new String(iLaunchConfiguration.getAttribute("base_url", "").getBytes());
        DBGpElement dBGpElement = null;
        if (string.equals("debug")) {
            string3 = DBGpSessionHandler.getInstance().getIDEKey();
            string2 = DBGpSessionHandler.getInstance().generateSessionId();
            stringArray = this.generateStartStopDebugURLs(string6, string2, string3);
            String string7 = iLaunchConfiguration.getAttribute("file_name", null);
            if (iDELayer.getPrefs().getBoolean("org.eclipse.php.debug.core.xdebug_multisession")) {
                dBGpElement = new DBGpMultiSessionTarget(iLaunch, string7, stringArray[1], string3, bl, iWebBrowserArray[0]);
                dBGpElement.setPathMapper(PathMapperRegistry.getByServer(server));
                iLaunch.addDebugTarget((IDebugTarget)dBGpElement);
            } else {
                dBGpElement = new DBGpTarget(iLaunch, string7, stringArray[1], string3, bl, iWebBrowserArray[0]);
                dBGpElement.setPathMapper(PathMapperRegistry.getByServer(server));
            }
            DBGpSessionHandler.getInstance().addSessionListener((IDBGpSessionListener)((Object)dBGpElement));
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = string6;
            stringArray = stringArray2;
        }
        string3 = stringArray[0];
        string2 = new SubProgressMonitor(iProgressMonitor, 30);
        string2.beginTask("Launching browser", 10);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    if (bl2) {
                        iWebBrowserArray[0].openURL(new URL(string3));
                    } else {
                        DBGpUtils.openInternalBrowserView(string3);
                    }
                }
                catch (Exception exception) {
                    Logger.logException("Error initializing the web browser.", exception);
                    exceptionArray[0] = exception;
                }
            }
        });
        string2.worked(10);
        if (exceptionArray[0] == null) {
            if (string.equals("debug")) {
                iLaunch.addDebugTarget((IDebugTarget)dBGpElement);
                string2.subTask("waiting for XDebug session");
                dBGpElement.waitForInitialSession((DBGpBreakpointFacade)((Object)IDELayerFactory.getIDELayer()), GeneralUtils.createSessionPreferences(), iProgressMonitor);
            } else {
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(iLaunch);
            }
        } else {
            Logger.logException("we have an exception on the browser", exceptionArray[0]);
            if (string.equals("debug")) {
                DBGpSessionHandler.getInstance().removeSessionListener((IDBGpSessionListener)((Object)dBGpElement));
            }
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(iLaunch);
        }
        string2.done();
    }

    protected void displayErrorMessage(final String string) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Debug Error", (String)string);
            }
        });
    }

    private boolean openExternal() {
        return 1 == WebBrowserPreference.getBrowserChoice();
    }

    public String[] generateStartStopDebugURLs(String string, String string2, String string3) {
        String[] stringArray = new String[2];
        string = string.indexOf("?") > -1 ? String.valueOf(string) + "&" : String.valueOf(string) + "?";
        stringArray[0] = String.valueOf(string) + "XDEBUG_SESSION_START=" + string3 + "&KEY=" + string2;
        stringArray[1] = String.valueOf(string) + "XDEBUG_SESSION_STOP_NO_EXEC=" + string3 + "&KEY=" + string2;
        return stringArray;
    }
}

