/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.documentModel.parser;

public class StateStack
implements Cloneable {
    private byte[] stack;
    private int lastIn = -1;

    public StateStack() {
        this(5);
    }

    public StateStack(int n) {
        this.stack = new byte[n];
        this.lastIn = -1;
    }

    public boolean isEmpty() {
        return this.lastIn == -1;
    }

    public int popStack() {
        byte by = this.stack[this.lastIn];
        --this.lastIn;
        return by;
    }

    public void pushStack(int n) {
        ++this.lastIn;
        if (this.lastIn == this.stack.length) {
            this.multiplySize();
        }
        this.stack[this.lastIn] = (byte)n;
    }

    private void multiplySize() {
        int n = this.stack.length;
        byte[] byArray = new byte[n * 2];
        System.arraycopy(this.stack, 0, byArray, 0, n);
        this.stack = byArray;
    }

    public int clear() {
        this.lastIn = -1;
        return -1;
    }

    public int size() {
        return this.lastIn + 1;
    }

    public StateStack createClone() {
        StateStack stateStack = new StateStack(this.size());
        stateStack.copyFrom(this);
        return stateStack;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof StateStack)) {
            return false;
        }
        StateStack stateStack = (StateStack)object;
        if (this.lastIn != stateStack.lastIn) {
            return false;
        }
        int n = this.lastIn;
        while (n >= 0) {
            if (this.stack[n] != stateStack.stack[n]) {
                return false;
            }
            --n;
        }
        return true;
    }

    public void copyFrom(StateStack stateStack) {
        while (stateStack.lastIn >= this.stack.length) {
            this.multiplySize();
        }
        this.lastIn = stateStack.lastIn;
        int n = 0;
        while (n <= stateStack.lastIn) {
            this.stack[n] = stateStack.stack[n];
            ++n;
        }
    }

    public boolean contains(int n) {
        int n2 = 0;
        while (n2 <= this.lastIn) {
            if (this.stack[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int get(int n) {
        return this.stack[n];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(50);
        int n = 0;
        while (n <= this.lastIn) {
            stringBuffer.append(" stack[" + n + "]= " + this.stack[n]);
            ++n;
        }
        return stringBuffer.toString();
    }
}

