/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.format;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.format.FormatPreferencesSupport;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.core.format.IIndentationStrategy;
import org.eclipse.wst.sse.core.internal.parser.ContextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class DefaultIndentationStrategy
implements IIndentationStrategy {
    protected static boolean isBlanks(IStructuredDocument iStructuredDocument, int n, int n2, int n3) throws BadLocationException {
        return iStructuredDocument.get(n, n2 - n).trim().length() == 0 || iStructuredDocument.get(n, n3 - n).trim().length() == 0;
    }

    private int getIndentationBaseLine(IStructuredDocument iStructuredDocument, int n, int n2) throws BadLocationException {
        int n3 = n;
        while (n3 >= 0) {
            IRegion iRegion = iStructuredDocument.getLineInformation(n3);
            if (iRegion.getLength() == 0) {
                --n3;
                continue;
            }
            int n4 = iRegion.getOffset() + iRegion.getLength();
            boolean bl = this.isIndentationBase(iStructuredDocument, Math.min(n2, n4), n2);
            if (bl) {
                return n3;
            }
            --n3;
        }
        return 0;
    }

    private ITextRegion getLastTokenRegion(IStructuredDocument iStructuredDocument, IRegion iRegion, int n) throws BadLocationException {
        Object object;
        int n2 = n;
        int n3 = iRegion.getOffset();
        IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(n2);
        if (iStructuredDocumentRegion == null) {
            return null;
        }
        ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n2);
        if (iTextRegion == null && n2 == iStructuredDocument.getLength()) {
            iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(--n2);
        }
        int n4 = iStructuredDocumentRegion.getStartOffset(iTextRegion);
        if (iTextRegion instanceof ITextRegionContainer) {
            object = (ITextRegionContainer)iTextRegion;
            iTextRegion = object.getRegionAtCharacterOffset(n2);
            n4 += iTextRegion.getStart();
        }
        if (iTextRegion instanceof IPhpScriptRegion) {
            object = (IPhpScriptRegion)iTextRegion;
            if ((iTextRegion = object.getPhpToken(n2 - n4)) == null) {
                return null;
            }
            do {
                String string;
                if (PHPPartitionTypes.isPHPCommentState(string = iTextRegion.getType()) || string == "WHITESPACE") continue;
                return iTextRegion;
            } while ((iTextRegion = object.getPhpToken(iTextRegion.getStart() - 1)) != null && iTextRegion.getStart() + n4 > n3);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isIndentationBase(IStructuredDocument var1_1, int var2_2, int var3_3) throws BadLocationException {
        var4_4 = var1_1.getLineInformationOfOffset(var2_2);
        var5_5 = var4_4.getOffset();
        if (!DefaultIndentationStrategy.isBlanks(var1_1, var5_5, var2_2, var3_3)) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            ++var5_5;
lbl6:
            // 2 sources

            ** while (Character.isWhitespace((char)var1_1.getChar((int)var5_5)))
        }
lbl7:
        // 1 sources

        var6_6 = FormatterUtils.getPartitionType(var1_1, var5_5, true);
        var7_7 = FormatterUtils.getPartitionType(var1_1, var2_2, true);
        var8_8 = FormatterUtils.getPartitionType(var1_1, var3_3);
        if (this.shouldNotConsiderAsIndentationBase(var6_6, var8_8)) {
            return false;
        }
        if ((var6_6 == "org.eclipse.php.PHP_MULTI_LINE_COMMENT" || var6_6 == "org.eclipse.php.PHP_DOC") && var6_6 == var8_8) {
            var9_9 = var1_1.getRegionAtCharacterOffset(var5_5);
            var10_10 = var9_9.getRegionAtCharacterOffset(var5_5);
            var11_11 = var9_9.getStartOffset(var10_10);
            if (var10_10 instanceof ITextRegionContainer) {
                var12_12 = (ITextRegionContainer)var10_10;
                var10_10 = var12_12.getRegionAtCharacterOffset(var5_5);
                var11_11 += var10_10.getStart();
            }
            if (var10_10 instanceof IPhpScriptRegion) {
                var12_12 = (IPhpScriptRegion)var10_10;
                var13_13 = (ContextRegion)var12_12.getPhpToken(var5_5 - var11_11);
                var14_14 = (ContextRegion)var12_12.getPhpToken(var3_3 - var11_11);
                var15_15 = var13_13.getType();
                var16_16 = var14_14.getType();
                if (var16_16.equals("PHPDOC_COMMENT_START") || var16_16.equals("PHP_COMMENT_START")) {
                    return var15_15.equals("PHPDOC_COMMENT_START") != false || var15_15.equals("PHP_COMMENT_START") != false;
                }
            }
        }
        return this.lineShouldInedent(var6_6, var7_7) != false || var8_8 == var6_6;
    }

    boolean lineShouldInedent(String string, String string2) {
        return string == "org.eclipse.php.PHP_DEFAULT" || string2 == "org.eclipse.php.PHP_DEFAULT";
    }

    public void placeMatchingBlanks(IStructuredDocument iStructuredDocument, StringBuffer stringBuffer, int n, int n2) throws BadLocationException {
        int n3;
        int n4;
        int n5 = this.getIndentationBaseLine(iStructuredDocument, n, n2);
        IRegion iRegion = iStructuredDocument.getLineInformation(n5);
        String string = FormatterUtils.getLineBlanks(iStructuredDocument, iRegion);
        stringBuffer.append(string);
        int n6 = iRegion.getOffset() + iRegion.getLength();
        if (n2 < n6) {
            n4 = n2;
            n3 = n;
        } else {
            n4 = n6;
            n3 = n5;
        }
        if (this.shouldIndent(iStructuredDocument, n4, n3)) {
            int n7 = FormatPreferencesSupport.getInstance().getIndentationSize((IDocument)iStructuredDocument);
            char c = FormatPreferencesSupport.getInstance().getIndentationChar((IDocument)iStructuredDocument);
            int n8 = 0;
            while (n8 < n7) {
                stringBuffer.append(c);
                ++n8;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean shouldIndent(IStructuredDocument iStructuredDocument, int n, int n2) {
        try {
            IRegion iRegion = iStructuredDocument.getLineInformation(n2);
            IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(n);
            ITextRegion iTextRegion = this.getLastTokenRegion(iStructuredDocument, iRegion, n);
            if (iTextRegion == null) {
                return false;
            }
            String string = iTextRegion.getType();
            if (string == "PHP_CURLY_OPEN") {
                return true;
            }
            ITextRegion iTextRegion2 = iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
            if (iTextRegion2 == null && n == iStructuredDocument.getLength()) {
                iTextRegion2 = iStructuredDocumentRegion.getRegionAtCharacterOffset(--n);
            }
            int n3 = iStructuredDocumentRegion.getStartOffset(iTextRegion2);
            if (iTextRegion2 instanceof ITextRegionContainer) {
                ITextRegionContainer iTextRegionContainer = (ITextRegionContainer)iTextRegion2;
                iTextRegion2 = iTextRegionContainer.getRegionAtCharacterOffset(n);
                n3 += iTextRegion2.getStart();
            }
            if (!(iTextRegion2 instanceof IPhpScriptRegion)) return false;
            if (string != "PHP_TOKEN") return false;
            if (iStructuredDocument.getChar(n3 + iTextRegion.getStart()) != ':') return false;
            int n4 = n3 + iTextRegion.getStart() - 1;
            while (true) {
                if (n4 < iRegion.getOffset()) {
                    return false;
                }
                string = (iTextRegion = ((IPhpScriptRegion)iTextRegion2).getPhpToken(iTextRegion.getStart() - 1)).getType();
                if (string == "PHP_CASE") return true;
                if (string == "PHP_DEFAULT") {
                    return true;
                }
                n4 = n3 + iTextRegion.getStart() - 1;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    boolean shouldNotConsiderAsIndentationBase(String string, String string2) {
        return string != string2 && (string == "org.eclipse.php.PHP_MULTI_LINE_COMMENT" || string == "org.eclipse.php.PHP_DOC" || string == "org.eclipse.php.PHP_QUOTED_STRING");
    }
}

