/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.phpElementData;

import org.eclipse.core.runtime.Platform;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;

public abstract class AbstractCodeData
implements CodeData {
    protected String name;
    private String description;
    private boolean isUserCode;
    protected UserData userData;

    public AbstractCodeData(String string, String string2) {
        this(string, string2, null);
    }

    public AbstractCodeData(String string, String string2, UserData userData) {
        this.name = string;
        this.description = string2;
        this.userData = userData;
        this.isUserCode = userData != null;
    }

    public final String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public final boolean isUserCode() {
        return this.isUserCode;
    }

    public final UserData getUserData() {
        return this.userData;
    }

    public int compareTo(CodeData codeData) {
        char c;
        String string = codeData.getName();
        int n = Math.min(this.name.length(), string.length());
        int n2 = 0;
        while (n2 < n) {
            c = this.name.charAt(0);
            char c2 = string.charAt(0);
            if (c == '_') {
                if (c2 != '_') {
                    return 1;
                }
            } else {
                if (c2 != '_') break;
                return -1;
            }
            ++n2;
        }
        if ((n2 = this.name.compareToIgnoreCase(string)) != 0) {
            return n2;
        }
        c = (char)(codeData.isUserCode() ? 1 : 0);
        if (!this.isUserCode) {
            if (c == '\u0000') {
                return 0;
            }
            return -1;
        }
        if (c == '\u0000') {
            return 1;
        }
        return this.userData.getFileName().compareTo(codeData.getUserData().getFileName());
    }

    public String toString() {
        if (this.getUserData() == null) {
            return this.name;
        }
        return String.valueOf(this.name) + " in " + this.getUserData().getFileName();
    }

    public Object getAdapter(Class clazz) {
        return Platform.getAdapterManager().getAdapter((Object)this, clazz);
    }
}

