/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.ModelSupport;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeDataFactory;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.VariableContextBuilder;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileDataUtilities;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableTypeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.util.ProjectResolver;
import org.eclipse.wst.sse.core.internal.util.URIResolver;

public class CodeDataResolver {
    private static final String PHPDOC_CLASS_NAME_SEPARATOR = "\\|";
    private static final CodeData[] EMPTY = new CodeData[0];
    private static CodeDataResolver instance;

    private CodeDataResolver() {
    }

    public static CodeDataResolver getInstance() {
        if (instance == null) {
            instance = new CodeDataResolver();
        }
        return instance;
    }

    public CodeData[] resolve(IFile iFile, int n) throws IOException, CoreException {
        IStructuredModel iStructuredModel = null;
        try {
            iStructuredModel = StructuredModelManager.getModelManager().getModelForRead(iFile);
            if (iStructuredModel instanceof DOMModelForPHP) {
                DOMModelForPHP dOMModelForPHP = (DOMModelForPHP)iStructuredModel;
                CodeData[] codeDataArray = this.resolve(iStructuredModel.getStructuredDocument(), n, dOMModelForPHP);
                return codeDataArray;
            }
            CodeData[] codeDataArray = EMPTY;
            return codeDataArray;
        }
        finally {
            if (iStructuredModel != null) {
                iStructuredModel.releaseFromRead();
            }
        }
    }

    public CodeData[] resolve(IProject iProject, File file, int n) throws IOException {
        IStructuredDocument iStructuredDocument = StructuredModelManager.getModelManager().createStructuredDocumentFor(file.getAbsolutePath(), (InputStream)new FileInputStream(file), (URIResolver)new ProjectResolver(iProject));
        return this.resolve(iStructuredDocument, n);
    }

    public CodeData[] resolve(IStructuredDocument iStructuredDocument, int n) {
        IStructuredModel iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead((IDocument)iStructuredDocument);
        try {
            if (iStructuredModel instanceof DOMModelForPHP) {
                DOMModelForPHP dOMModelForPHP = (DOMModelForPHP)iStructuredModel;
                CodeData[] codeDataArray = this.resolve(iStructuredDocument, n, dOMModelForPHP);
                return codeDataArray;
            }
        }
        finally {
            if (iStructuredModel != null) {
                iStructuredModel.releaseFromRead();
            }
        }
        return EMPTY;
    }

    public CodeData[] resolve(IStructuredDocument iStructuredDocument, int n, DOMModelForPHP dOMModelForPHP) {
        PHPProjectModel pHPProjectModel = dOMModelForPHP.getProjectModel();
        PHPFileData pHPFileData = dOMModelForPHP.getFileData(true);
        if (pHPProjectModel == null || pHPFileData == null) {
            return EMPTY;
        }
        return this.resolve(iStructuredDocument, n, pHPProjectModel, pHPFileData);
    }

    public CodeData[] resolve(IStructuredDocument iStructuredDocument, int n, PHPProjectModel pHPProjectModel, PHPFileData pHPFileData) {
        block42: {
            try {
                Object object;
                int n2;
                int n3;
                Object[] objectArray;
                Object object2;
                int n4;
                PHPClassData pHPClassData;
                IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(n);
                if (iStructuredDocumentRegion == null) break block42;
                ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
                IStructuredDocumentRegion iStructuredDocumentRegion2 = iStructuredDocumentRegion;
                if (iTextRegion instanceof ITextRegionContainer) {
                    iStructuredDocumentRegion2 = (ITextRegionContainer)iTextRegion;
                    iTextRegion = iStructuredDocumentRegion2.getRegionAtCharacterOffset(n);
                }
                if (iTextRegion.getType() != "PHP_CONTENT") break block42;
                IPhpScriptRegion iPhpScriptRegion = (IPhpScriptRegion)iTextRegion;
                iTextRegion = iPhpScriptRegion.getPhpToken(n - iStructuredDocumentRegion2.getStartOffset() - iPhpScriptRegion.getStart());
                int n5 = iStructuredDocumentRegion2.getStartOffset() + iPhpScriptRegion.getStart() + iTextRegion.getStart();
                TextSequence textSequence = PHPTextSequenceUtilities.getStatement(n5 + iTextRegion.getLength(), iStructuredDocumentRegion, true);
                int n6 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, textSequence.length());
                int n7 = PHPTextSequenceUtilities.readIdentifierStartIndex(textSequence, n6, true);
                String string = textSequence.subSequence(n7, n6).toString();
                int n8 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n7);
                int n9 = PHPTextSequenceUtilities.readIdentifierStartIndex(textSequence, n8, false);
                String string2 = textSequence.subSequence(n9, n8).toString();
                ITextRegion iTextRegion2 = iTextRegion;
                while ((PHPPartitionTypes.isPHPCommentState((iTextRegion2 = iPhpScriptRegion.getPhpToken(iTextRegion2.getEnd())).getType()) || iTextRegion2.getType() == "WHITESPACE") && iTextRegion2.getEnd() < iPhpScriptRegion.getLength()) {
                }
                String string3 = iStructuredDocument.get(iStructuredDocumentRegion2.getStartOffset() + iPhpScriptRegion.getStart() + iTextRegion2.getStart(), iTextRegion2.getTextLength());
                if (string.length() <= 0) break block42;
                String string4 = pHPFileData != null ? pHPFileData.getName() : null;
                PHPClassData pHPClassData2 = pHPClassData = pHPFileData != null ? PHPFileDataUtilities.getContainerClassData(pHPFileData, n) : null;
                if ("function".equalsIgnoreCase(string2)) {
                    if (pHPClassData != null) {
                        return this.toArray(pHPProjectModel.getClassFunctionData(string4, pHPClassData.getName(), string));
                    }
                    return this.toArray(pHPProjectModel.getFunction(string4, string));
                }
                if ("class".equalsIgnoreCase(string2) || "interface".equalsIgnoreCase(string2)) {
                    return this.toArray(pHPProjectModel.getClass(string4, string));
                }
                CodeData[] codeDataArray = this.getMatchingClasses(string, pHPProjectModel, string4);
                if ("new".equalsIgnoreCase(string2)) {
                    return codeDataArray;
                }
                if (textSequence.length() > 6 && ("class".equals(textSequence.subSequence(0, 5).toString()) || textSequence.length() > 10 && "interface".equals(textSequence.subSequence(0, 9).toString()))) {
                    if ("extends".equalsIgnoreCase(string2) || "implements".equalsIgnoreCase(string2)) {
                        return codeDataArray;
                    }
                    int n10 = PHPTextSequenceUtilities.readIdentifierListStartIndex(textSequence, n6);
                    n4 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n10);
                    int n11 = PHPTextSequenceUtilities.readIdentifierStartIndex(textSequence, n4, false);
                    object2 = textSequence.subSequence(n11, n4).toString();
                    if ("extends".equalsIgnoreCase((String)object2) || "implements".equalsIgnoreCase((String)object2)) {
                        return codeDataArray;
                    }
                }
                String string5 = null;
                if (n7 > 2) {
                    string5 = textSequence.subSequence(n7 - 2, n7).toString();
                }
                if (string.charAt(0) == '$' && !"::".equals(string5)) {
                    PHPCodeContext pHPCodeContext;
                    CodeData[] codeDataArray2;
                    if (PHPPartitionTypes.isPHPQuotesState(iTextRegion.getType())) {
                        try {
                            n4 = iStructuredDocument.get(n5 - 2, 1).charAt(0);
                            if (n4 == 92) {
                                return EMPTY;
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            PHPCorePlugin.log(badLocationException);
                        }
                    }
                    string = string.substring(1);
                    if (pHPClassData != null) {
                        if ("var".equalsIgnoreCase(string2) || "private".equalsIgnoreCase(string2) || "static".equalsIgnoreCase(string2) || "public".equalsIgnoreCase(string2) || "protected".equalsIgnoreCase(string2)) {
                            return this.filterExact(pHPClassData.getVars(), string);
                        }
                        if ("this".equalsIgnoreCase(string)) {
                            return this.toArray(pHPClassData);
                        }
                    }
                    if ((codeDataArray2 = this.filterExact(pHPProjectModel.getVariables(string4, pHPCodeContext = ModelSupport.createContext(pHPFileData, n5), string, true), string)).length == 1 && codeDataArray2[0].getUserData() == null && codeDataArray2[0] instanceof PHPVariableData) {
                        PHPVariableTypeData pHPVariableTypeData;
                        int n12;
                        object2 = (PHPVariableData)codeDataArray2[0];
                        String string6 = VariableContextBuilder.createVariableContext(string, pHPCodeContext);
                        List list = (List)pHPFileData.getVariableTypeManager().getVariablesInstansiation().get(string6);
                        if (list != null && list.size() > 0 && (iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(n12 = (pHPVariableTypeData = (PHPVariableTypeData)list.get(list.size() - 1)).getPosition())) != null) {
                            iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n12);
                            iStructuredDocumentRegion2 = iStructuredDocumentRegion;
                            if (iTextRegion instanceof ITextRegionContainer) {
                                iStructuredDocumentRegion2 = (ITextRegionContainer)iTextRegion;
                                iTextRegion = iStructuredDocumentRegion2.getRegionAtCharacterOffset(n12);
                            }
                            if (iTextRegion != null && iTextRegion.getType() == "PHP_CONTENT") {
                                iPhpScriptRegion = (IPhpScriptRegion)iTextRegion;
                                ITextRegion iTextRegion3 = iTextRegion = iPhpScriptRegion.getPhpToken(n12 - iStructuredDocumentRegion2.getStartOffset() - iPhpScriptRegion.getStart());
                                while ((iTextRegion3 = iPhpScriptRegion.getPhpToken(iTextRegion3.getStart() - 1)).getType() != "PHP_VARIABLE" && iTextRegion3.getStart() > 0) {
                                }
                                if (iTextRegion3.getType() == "PHP_VARIABLE") {
                                    n12 = iStructuredDocumentRegion2.getStartOffset() + iPhpScriptRegion.getStart() + iTextRegion3.getStart();
                                    int n13 = n12 + string.length();
                                    UserData userData = PHPCodeDataFactory.createUserData(string4, n12, n13, n13, pHPVariableTypeData.getLine());
                                    codeDataArray2[0] = PHPCodeDataFactory.createPHPVariableData(object2.getName(), object2.getDocBlock(), userData);
                                }
                            }
                        }
                    }
                    return codeDataArray2;
                }
                if (pHPClassData != null && "const".equalsIgnoreCase(string2)) {
                    return this.filterExact(pHPClassData.getConsts(), string);
                }
                if ("::".equals(string3)) {
                    return codeDataArray;
                }
                String string7 = this.getClassName(pHPProjectModel, pHPFileData, textSequence, n7, n, iStructuredDocument.getLineOfOffset(n));
                CodeData[] codeDataArray3 = EMPTY;
                if (string7 != null) {
                    object2 = string7.split(PHPDOC_CLASS_NAME_SEPARATOR);
                    objectArray = object2;
                    n3 = ((String[])object2).length;
                    n2 = 0;
                    while (n2 < n3) {
                        object = objectArray[n2];
                        object = ((String)object).trim();
                        CodeData[] codeDataArray4 = this.getMatchingClasses((String)object, pHPProjectModel, string4);
                        codeDataArray3 = ModelSupport.merge(codeDataArray3, codeDataArray4);
                        ++n2;
                    }
                }
                if ("(".equals(string3) || PHPPartitionTypes.isPHPDocState(iTextRegion.getType())) {
                    object2 = null;
                    if (codeDataArray3.length > 0) {
                        objectArray = codeDataArray3;
                        n3 = codeDataArray3.length;
                        n2 = 0;
                        while (n2 < n3) {
                            object = objectArray[n2];
                            object2 = ModelSupport.merge((CodeData[])object2, this.toArray(pHPProjectModel.getClassFunctionData(string4, object.getName(), string)));
                            ++n2;
                        }
                    } else {
                        object2 = pHPProjectModel.getFilteredFunctions(string4, string);
                        if (object2 == null || ((Object[])object2).length == 0) {
                            object2 = pHPProjectModel.getFunction(string);
                        }
                    }
                    return object2 == null ? EMPTY : object2;
                }
                if (codeDataArray3.length > 0) {
                    if (n7 > 0 && "::".equals(string5) && string.charAt(0) != '$') {
                        object2 = null;
                        int n14 = 0;
                        while (n14 < codeDataArray3.length) {
                            object2 = ModelSupport.merge((CodeData[])object2, this.toArray(pHPProjectModel.getClassConstsData(string4, string7, string)));
                            ++n14;
                        }
                        return object2 == null ? EMPTY : object2;
                    }
                    object2 = null;
                    if (string.charAt(0) == '$') {
                        string = string.substring(1);
                    }
                    objectArray = codeDataArray3;
                    n3 = codeDataArray3.length;
                    n2 = 0;
                    while (n2 < n3) {
                        object = objectArray[n2];
                        object2 = ModelSupport.merge((CodeData[])object2, this.toArray(pHPProjectModel.getClassVariablesData(string4, object.getName(), string)));
                        ++n2;
                    }
                    return object2 == null ? EMPTY : object2;
                }
                object2 = pHPProjectModel.getFilteredConstants(string4, string);
                if (object2 == null || ((Object[])object2).length == 0) {
                    object2 = pHPProjectModel.getConstant(string);
                }
                if (object2 == null || ((Object[])object2).length == 0) {
                    object2 = codeDataArray;
                }
                return object2 == null ? EMPTY : object2;
            }
            catch (Exception exception) {
                PHPCorePlugin.log(exception);
            }
        }
        return EMPTY;
    }

    private CodeData[] getMatchingClasses(String string, PHPProjectModel pHPProjectModel, String string2) {
        CodeData[] codeDataArray = pHPProjectModel.getFilteredClasses(string2, string);
        if (codeDataArray == null || codeDataArray.length == 0) {
            codeDataArray = pHPProjectModel.getClass(string);
        }
        return codeDataArray;
    }

    private CodeData[] filterExact(CodeData[] codeDataArray, String string) {
        ArrayList<CodeData> arrayList = new ArrayList<CodeData>();
        if (codeDataArray != null) {
            int n = 0;
            while (n < codeDataArray.length) {
                if (string.equalsIgnoreCase(codeDataArray[n].getName())) {
                    arrayList.add(codeDataArray[n]);
                }
                ++n;
            }
        }
        return arrayList.toArray(new CodeData[arrayList.size()]);
    }

    private String getClassName(PHPProjectModel pHPProjectModel, PHPFileData pHPFileData, TextSequence textSequence, int n, int n2, int n3) {
        int n4;
        int n5;
        if (n < 2) {
            return null;
        }
        if ((n = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n)) < 2) {
            return null;
        }
        boolean bl = false;
        String string = textSequence.subSequence(n - 2, n).toString();
        if (!"->".equals(string)) {
            if ("::".equals(string)) {
                bl = true;
            } else {
                return null;
            }
        }
        if ((n5 = PHPTextSequenceUtilities.getPrivousTriggerIndex(textSequence, n4 = PHPTextSequenceUtilities.readBackwardSpaces(textSequence, n - 2))) == -1) {
            return this.innerGetClassName(pHPProjectModel, pHPFileData, textSequence, n4, bl, n2, n3);
        }
        int n6 = PHPTextSequenceUtilities.readForwardSpaces(textSequence, n5 + 2);
        String string2 = textSequence.subSequence(n6, n4).toString();
        String string3 = this.getClassName(pHPProjectModel, pHPFileData, textSequence, n6, n2, n3);
        int n7 = string2.indexOf(40);
        if (n7 == -1) {
            return PHPModelUtil.getVarType(pHPProjectModel, pHPFileData.getName(), string3, string2, n2, n3, true);
        }
        String string4 = string2.substring(0, n7).trim();
        return PHPModelUtil.getFunctionReturnType(pHPProjectModel, pHPFileData.getName(), string3, string4);
    }

    private String innerGetClassName(PHPProjectModel pHPProjectModel, PHPFileData pHPFileData, TextSequence textSequence, int n, boolean bl, int n2, int n3) {
        if (pHPFileData == null) {
            return null;
        }
        int n4 = PHPTextSequenceUtilities.readIdentifierStartIndex(textSequence, n, true);
        String string = textSequence.subSequence(n4, n).toString();
        if (bl) {
            PHPClassData pHPClassData;
            if (string.equals("self")) {
                PHPClassData pHPClassData2 = PHPFileDataUtilities.getContainerClassData(pHPFileData, n2 - 6);
                if (pHPClassData2 != null) {
                    return pHPClassData2.getName();
                }
            } else if (string.equals("parent") && (pHPClassData = PHPFileDataUtilities.getContainerClassData(pHPFileData, n2 - 8)) != null) {
                return pHPProjectModel.getSuperClassName(pHPFileData.getName(), pHPClassData.getName());
            }
            return string;
        }
        if (string.length() > 0 && string.charAt(0) == '$') {
            int n5 = textSequence.getOriginalOffset(0);
            return PHPFileDataUtilities.getVariableType(pHPFileData, string, n5, n3, (IPhpModel)pHPProjectModel, true);
        }
        if (textSequence.charAt(n - 1) == ')') {
            PHPFunctionData[] pHPFunctionDataArray;
            int n6 = this.getFunctionNameEndOffset(textSequence, n - 1);
            int n7 = PHPTextSequenceUtilities.readIdentifierStartIndex(textSequence, n6, false);
            String string2 = textSequence.subSequence(n7, n6).toString();
            PHPClassData pHPClassData = PHPFileDataUtilities.getContainerClassData(pHPFileData, n2);
            if (pHPClassData != null) {
                return PHPModelUtil.getFunctionReturnType(pHPProjectModel, pHPFileData.getName(), pHPClassData.getName(), string2);
            }
            PHPFunctionData[] pHPFunctionDataArray2 = pHPFunctionDataArray = pHPFileData.getFunctions();
            int n8 = pHPFunctionDataArray.length;
            int n9 = 0;
            while (n9 < n8) {
                PHPFunctionData pHPFunctionData = pHPFunctionDataArray2[n9];
                if (pHPFunctionData.getName().equals(string2)) {
                    return pHPFunctionData.getReturnType();
                }
                ++n9;
            }
        }
        return null;
    }

    private int getFunctionNameEndOffset(TextSequence textSequence, int n) {
        if (textSequence.charAt(n) != ')') {
            return 0;
        }
        int n2 = n;
        int n3 = 1;
        while (n3 != 0 && n2 >= 0) {
            if (textSequence.charAt(--n2) == ')') {
                ++n3;
                continue;
            }
            if (textSequence.charAt(n2) != '(') continue;
            --n3;
        }
        return n2;
    }

    private CodeData[] toArray(CodeData codeData) {
        if (codeData != null) {
            return new CodeData[]{codeData};
        }
        return EMPTY;
    }
}

