/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org.eclipse.php.internal.debug.ui.pathmapper.PathMappingComposite;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.ui.ServerEditDialog;
import org.eclipse.php.internal.server.ui.ServersPluginImages;
import org.eclipse.php.internal.ui.wizards.CompositeFragment;
import org.eclipse.php.internal.ui.wizards.IControlHandler;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class PathMapperCompositeFragment
extends CompositeFragment {
    private PathMappingComposite pathMapperComposite;

    public PathMapperCompositeFragment(Composite composite, IControlHandler iControlHandler, boolean bl) {
        super(composite, iControlHandler, bl);
        this.controlHandler.setTitle("Server Path Mapping");
        this.controlHandler.setDescription("Specify mapping between server and local paths");
        this.controlHandler.setImageDescriptor(ServersPluginImages.DESC_WIZ_SERVER);
        this.setDisplayName("Path Mapping");
        this.setTitle("Edit Server Path Mapping");
        this.setDescription("Configure Server Path Mapping");
        if (bl) {
            this.setData(((ServerEditDialog)this.controlHandler).getServer());
        }
        this.createControl(bl);
    }

    protected void createControl(boolean bl) {
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        Composite composite = new Composite((Composite)this, 0);
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        this.pathMapperComposite = new PathMappingComposite(composite, 0);
        gridData = new GridData(1808);
        this.pathMapperComposite.setLayoutData((Object)gridData);
        Dialog.applyDialogFont((Control)this);
        this.init();
        this.validate();
    }

    protected void init() {
        PathMapper pathMapper;
        if (this.pathMapperComposite == null || this.pathMapperComposite.isDisposed()) {
            return;
        }
        Server server = this.getServer();
        if (server != null && (pathMapper = PathMapperRegistry.getByServer((Server)server)) != null) {
            this.pathMapperComposite.setData((Object)pathMapper.getMapping());
        }
    }

    protected void validate() {
        this.setMessage(this.getDescription(), 0);
        this.setComplete(true);
        this.controlHandler.update();
    }

    protected void setMessage(String string, int n) {
        this.controlHandler.setMessage(string, n);
        this.setComplete(n != 3);
        this.controlHandler.update();
    }

    public boolean performOk() {
        Server server = this.getServer();
        if (server != null) {
            PathMapper pathMapper = PathMapperRegistry.getByServer((Server)server);
            pathMapper.setMapping(this.pathMapperComposite.getMappings());
            PathMapperRegistry.storeToPreferences();
        }
        return true;
    }

    public void setData(Object object) {
        if (!(object instanceof Server)) {
            throw new IllegalArgumentException("The given object is not a Server");
        }
        super.setData(object);
        this.init();
        this.validate();
    }

    public PathMapper.Mapping[] getMappings() {
        return this.pathMapperComposite.getMappings();
    }

    public Server getServer() {
        return (Server)this.getData();
    }
}

