/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.StaticDispatch;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class StaticMethodInvocation
extends StaticDispatch {
    private final FunctionInvocation method;

    public StaticMethodInvocation(int n, int n2, Identifier identifier, FunctionInvocation functionInvocation) {
        super(n, n2, identifier);
        assert (functionInvocation != null);
        this.method = functionInvocation;
        functionInvocation.setParent(this);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.getClassName().accept(visitor);
        this.method.accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.getClassName().traverseTopDown(visitor);
        this.method.traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        this.getClassName().traverseBottomUp(visitor);
        this.method.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public void toString(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string).append("<StaticMethodInvocation");
        this.appendInterval(stringBuffer);
        stringBuffer.append(">\n");
        stringBuffer.append("\t").append(string).append("<ClassName>\n");
        this.getClassName().toString(stringBuffer, "\t\t" + string);
        stringBuffer.append("\n").append("\t").append(string).append("</ClassName>\n");
        this.method.toString(stringBuffer, "\t" + string);
        stringBuffer.append("\n");
        stringBuffer.append(string).append("</StaticMethodInvocation>");
    }

    public int getType() {
        return 53;
    }

    public FunctionInvocation getMethod() {
        return this.method;
    }

    public ASTNode getMember() {
        return this.getMethod();
    }
}

