/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.launching.XDebugLaunchListener;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.xdebug.XDebugPreferenceInit;
import org.eclipse.php.internal.debug.daemon.DaemonPlugin;
import org.eclipse.php.internal.server.core.Activator;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.osgi.framework.BundleContext;

public class PHPDebugPlugin
extends Plugin {
    public static final String ID = "org.eclipse.php.debug.core";
    public static final int INTERNAL_ERROR = 10001;
    public static final int INTERNAL_WARNING = 10002;
    private static PHPDebugPlugin plugin;
    private static final String BASE_URL = "http://localhost";
    private static String fPHPDebugPerspective;
    private static String fDebugPerspective;
    private static boolean fIsSupportingMultipleDebugAllPages;
    private boolean fInitialAutoRemoveLaunches;
    private static boolean fLaunchChangedAutoRemoveLaunches;
    public static final boolean DebugPHP;

    static {
        fPHPDebugPerspective = "org.eclipse.php.debug.ui.PHPDebugPerspective";
        fDebugPerspective = "org.eclipse.debug.ui.DebugPerspective";
        fIsSupportingMultipleDebugAllPages = true;
        String string = Platform.getDebugOption((String)"org.eclipse.php.debug.core/debug");
        DebugPHP = string != null && string.equalsIgnoreCase("true");
    }

    public PHPDebugPlugin() {
        plugin = this;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        IPreferenceStore iPreferenceStore = DebugUIPlugin.getDefault().getPreferenceStore();
        this.fInitialAutoRemoveLaunches = iPreferenceStore.getBoolean("org.eclipse.debug.ui.auto_remove_old_launches");
        iPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)new AutoRemoveOldLaunchesListener());
        Activator.getDefault();
        PHPDebugPlugin.createDefaultPHPServer();
        XDebugPreferenceInit.setDefaults();
        DaemonPlugin.getDefault().startDaemons(null);
        XDebugLaunchListener.getInstance();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        XDebugLaunchListener.shutdown();
        this.savePluginPreferences();
        super.stop(bundleContext);
        plugin = null;
        DebugUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.debug.ui.auto_remove_old_launches", this.fInitialAutoRemoveLaunches);
    }

    public static PHPDebugPlugin getDefault() {
        return plugin;
    }

    public static String getID() {
        return ID;
    }

    public static boolean getStopAtFirstLine() {
        Preferences preferences = PHPDebugPlugin.getDefault().getPluginPreferences();
        return preferences.getBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE);
    }

    public static boolean getDebugInfoOption() {
        Preferences preferences = PHPDebugPlugin.getDefault().getPluginPreferences();
        return preferences.getBoolean(PHPDebugCorePreferenceNames.RUN_WITH_DEBUG_INFO);
    }

    public static boolean getOpenInBrowserOption() {
        Preferences preferences = PHPDebugPlugin.getDefault().getPluginPreferences();
        return preferences.getBoolean(PHPDebugCorePreferenceNames.OPEN_IN_BROWSER);
    }

    public static String getCurrentDebuggerId() {
        Preferences preferences = PHPDebugPlugin.getDefault().getPluginPreferences();
        return preferences.getString(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID);
    }

    public static boolean getAutoSaveDirtyOption() {
        String string = DebugUIPlugin.getDefault().getPreferenceStore().getString("org.eclipse.debug.ui.save_dirty_editors_before_launch");
        if (string == null) {
            return true;
        }
        return Boolean.valueOf(string);
    }

    public static boolean getOpenDebugViewsOption() {
        Preferences preferences = PHPDebugPlugin.getDefault().getPluginPreferences();
        return preferences.getBoolean(PHPDebugCorePreferenceNames.OPEN_DEBUG_VIEWS);
    }

    public static int getDebugPort(String string) {
        AbstractDebuggerConfiguration abstractDebuggerConfiguration = PHPDebuggersRegistry.getDebuggerConfiguration(string);
        if (abstractDebuggerConfiguration == null) {
            return -1;
        }
        return abstractDebuggerConfiguration.getPort();
    }

    public static String getDebugHosts() {
        Preferences preferences = PHPProjectPreferences.getModelPreferences();
        String string = preferences.getString(PHPDebugCorePreferenceNames.CLIENT_IP);
        return string.replaceAll(",", "%2C");
    }

    public static String getWorkspaceDefaultServer() {
        Preferences preferences = Activator.getDefault().getPluginPreferences();
        return preferences.getString("defaultPHPServer");
    }

    public static void createDefaultPHPServer() {
        if (ServersManager.getServers().length == 0) {
            Server server = ServersManager.createServer((String)"Default PHP Web Server", (String)BASE_URL);
            ServersManager.save();
            ServersManager.setDefaultServer(null, (Server)server);
        }
    }

    public static void log(IStatus iStatus) {
        try {
            PHPDebugPlugin.getDefault().getLog().log(iStatus);
        }
        catch (Exception exception) {}
    }

    public static void log(Throwable throwable) {
        PHPDebugPlugin.log((IStatus)new Status(4, ID, 10001, "PHPDebug plugin internal error", throwable));
    }

    public static void logErrorMessage(String string) {
        PHPDebugPlugin.log((IStatus)new Status(4, ID, 10001, string, null));
    }

    public static void logWarningMessage(String string) {
        PHPDebugPlugin.log((IStatus)new Status(2, ID, 10002, string, null));
    }

    public static boolean supportsMultipleDebugAllPages() {
        return fIsSupportingMultipleDebugAllPages;
    }

    public static void setMultipleDebugAllPages(boolean bl) {
        fIsSupportingMultipleDebugAllPages = bl;
    }

    public static void setDisableAutoRemoveLaunches(boolean bl) {
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.auto_remove_old_launches") == bl) {
            fLaunchChangedAutoRemoveLaunches = true;
            DebugUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.debug.ui.auto_remove_old_launches", !bl);
        }
    }

    public boolean getInitialAutoRemoveLaunches() {
        return this.fInitialAutoRemoveLaunches;
    }

    private class AutoRemoveOldLaunchesListener
    implements IPropertyChangeListener {
        private AutoRemoveOldLaunchesListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("org.eclipse.debug.ui.auto_remove_old_launches".equals(propertyChangeEvent.getProperty())) {
                if (fLaunchChangedAutoRemoveLaunches) {
                    fLaunchChangedAutoRemoveLaunches = false;
                } else {
                    PHPDebugPlugin.this.fInitialAutoRemoveLaunches = (Boolean)propertyChangeEvent.getNewValue();
                }
            }
        }
    }
}

