/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.launching;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org.eclipse.php.internal.debug.core.phpIni.PHPINIUtil;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.core.xdebug.GeneralUtils;
import org.eclipse.php.internal.debug.core.xdebug.IDELayerFactory;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpBreakpointFacade;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSessionHandler;
import org.eclipse.php.internal.debug.core.zend.debugger.ProcessCrashDetector;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class XDebugExeLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        Object object;
        String[] stringArray;
        String string2;
        Object object2;
        String string3;
        Path path;
        if (iProgressMonitor.isCanceled()) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(iLaunch);
            return;
        }
        String string4 = iLaunchConfiguration.getAttribute("ATTR_LOCATION", null);
        String string5 = iLaunchConfiguration.getAttribute("ATTR_INI_LOCATION", null);
        String string6 = iLaunchConfiguration.getAttribute("ATTR_FILE", null);
        if (string6 == null || string6.trim().length() == 0) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(iLaunch);
            this.displayErrorMessage("No script specified");
            return;
        }
        if (iProgressMonitor.isCanceled()) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(iLaunch);
            return;
        }
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource iResource = iWorkspaceRoot.findMember((IPath)(path = new Path(string6)));
        if (iResource == null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(iLaunch);
            this.displayErrorMessage("Specified script cannot be found");
            return;
        }
        IProject iProject = iResource.getProject();
        boolean bl = PHPProjectPreferences.getStopAtFirstLine(iProject);
        bl = iLaunchConfiguration.getAttribute("firstLineBreakpoint", bl);
        String string7 = iProject.getFullPath().toString();
        ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = null;
        iLaunchConfigurationWorkingCopy = iLaunchConfiguration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)iLaunchConfiguration : iLaunchConfiguration.getWorkingCopy();
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.php.debug.core.PHP_Project", string7);
        if (iProgressMonitor.isCanceled()) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(iLaunch);
            return;
        }
        Path path2 = new Path(string4);
        IPath iPath = iProject.getRawLocation();
        if (iPath == null) {
            iPath = iProject.getLocation();
        }
        String string8 = iPath.toOSString();
        Path path3 = new Path(string8);
        File file = path3.toFile();
        Path path4 = new Path(string6);
        if (string6.startsWith("/")) {
            path4 = path4.removeFirstSegments(1);
        }
        if (iProgressMonitor.isCanceled()) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(iLaunch);
            return;
        }
        File file2 = string5 != null && new File(string5).exists() ? new File(string5) : PHPINIUtil.findPHPIni(string4);
        File file3 = PHPINIUtil.prepareBeforeDebug(file2, string4, iProject);
        iLaunch.setAttribute("PHPIniLocation", file3.getAbsolutePath());
        iLaunchConfigurationWorkingCopy.doSave();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string9 = path2.lastSegment();
        String string10 = path2.getFileExtension();
        if (string10 != null) {
            string9 = string9.substring(0, string9.length() - (string10.length() + 1));
        }
        string9 = string9.toLowerCase();
        hashMap.put(IProcess.ATTR_PROCESS_TYPE, string9);
        hashMap.put(IProcess.ATTR_CMDLINE, string6);
        if (iProgressMonitor.isCanceled()) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(iLaunch);
            return;
        }
        String[] stringArray2 = null;
        DBGpTarget dBGpTarget = null;
        if (string.equals("debug")) {
            string3 = DBGpSessionHandler.getInstance().generateSessionId();
            object2 = DBGpSessionHandler.getInstance().getIDEKey();
            dBGpTarget = new DBGpTarget(iLaunch, path4.toOSString(), (String)object2, string3, bl);
            dBGpTarget.setPathMapper(PathMapperRegistry.getByLaunchConfiguration(iLaunchConfiguration));
            DBGpSessionHandler.getInstance().addSessionListener(dBGpTarget);
            stringArray2 = this.createDebugLaunchEnvironment(iLaunchConfiguration, string3, (String)object2, (IPath)path2);
        } else {
            stringArray2 = PHPLaunchUtilities.getEnvironment(iLaunchConfiguration, new String[]{this.getLibraryPath((IPath)path2)});
        }
        string3 = new SubProgressMonitor(iProgressMonitor, 30);
        string3.beginTask("Launching script", 10);
        object2 = file;
        int n = 0;
        while (n < stringArray2.length && object2 == file) {
            string2 = stringArray2[n];
            stringArray = string2.split("=");
            if (stringArray.length > 0 && ((String)stringArray[0]).equals("XDEBUG_WORKING_DIR")) {
                object = path3.append(path4.removeLastSegments(1));
                object2 = object.makeAbsolute().toFile();
            }
            ++n;
        }
        File file4 = new File(string4);
        string2 = null;
        String[] stringArray3 = stringArray = PHPexes.getInstance().getAllItems();
        int n2 = stringArray3.length;
        int n3 = 0;
        while (n3 < n2) {
            object = stringArray3[n3];
            if (object.getExecutable().equals(file4)) {
                string2 = object.getSapiType();
                break;
            }
            ++n3;
        }
        object = null;
        if (string2 == "CLI") {
            object = PHPLaunchUtilities.getProgramArguments(iLaunch.getLaunchConfiguration());
        }
        String[] stringArray4 = null;
        stringArray4 = object2 == file ? PHPLaunchUtilities.getCommandLine(iLaunchConfiguration, path2.toOSString(), file3.toString(), path4.toOSString(), object) : PHPLaunchUtilities.getCommandLine(iLaunchConfiguration, path2.toOSString(), file3.toString(), path4.lastSegment(), object);
        Process process = DebugPlugin.exec((String[])stringArray4, (File)object2, (String[])stringArray2);
        new Thread(new ProcessCrashDetector(process)).start();
        stringArray3 = null;
        if (process != null) {
            string3.worked(10);
            stringArray3 = DebugPlugin.newProcess((ILaunch)iLaunch, (Process)process, (String)path2.toOSString(), hashMap);
            if (stringArray3 == null) {
                process.destroy();
                string3.done();
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(iLaunch);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.php.debug.core", 0, null, null));
            }
            if (string.equals("debug") && dBGpTarget != null) {
                dBGpTarget.setProcess((IProcess)stringArray3);
                iLaunch.addDebugTarget((IDebugTarget)dBGpTarget);
                string3.subTask("waiting for XDebug session");
                dBGpTarget.waitForInitialSession((DBGpBreakpointFacade)((Object)IDELayerFactory.getIDELayer()), GeneralUtils.createSessionPreferences(), iProgressMonitor);
            }
        } else {
            if (string.equals("debug")) {
                DBGpSessionHandler.getInstance().removeSessionListener(dBGpTarget);
            }
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(iLaunch);
        }
        string3.done();
    }

    public String[] createDebugLaunchEnvironment(ILaunchConfiguration iLaunchConfiguration, String string, String string2, IPath iPath) throws CoreException {
        String string3 = "XDEBUG_CONFIG=remote_enable=1 idekey=" + string2;
        String string4 = "DBGP_IDEKEY=" + string2;
        String string5 = "DBGP_COOKIE=" + string;
        Logger.debugMSG("env=" + string3 + ", Cookie=" + string5);
        String[] stringArray = PHPLaunchUtilities.getEnvironment(iLaunchConfiguration, new String[]{string3, string4, string5, this.getLibraryPath(iPath)});
        return stringArray;
    }

    private String getLibraryPath(IPath iPath) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LD_LIBRARY_PATH");
        stringBuffer.append('=');
        iPath = iPath.removeLastSegments(1);
        stringBuffer.append(iPath.toOSString());
        return stringBuffer.toString();
    }

    protected void displayErrorMessage(final String string) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Debug Error", (String)string);
            }
        });
    }
}

