/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.pathmapper;

import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;

public class PathEntry {
    private Object container;
    private VirtualPath abstractPath;
    private Type type;

    public PathEntry(String string, Type type, Object object) {
        this(new VirtualPath(string), type, object);
    }

    public PathEntry(VirtualPath virtualPath, Type type, Object object) {
        this.abstractPath = virtualPath;
        this.type = type;
        this.container = object;
    }

    public VirtualPath getAbstractPath() {
        return this.abstractPath;
    }

    public Type getType() {
        return this.type;
    }

    public Object getContainer() {
        return this.container;
    }

    public String getPath() {
        return this.abstractPath.toString();
    }

    public String getResolvedPath() {
        return this.getPath();
    }

    public boolean equals(Object object) {
        if (!(object instanceof PathEntry)) {
            return false;
        }
        PathEntry pathEntry = (PathEntry)object;
        return pathEntry.abstractPath.equals(this.abstractPath) && pathEntry.type == this.type;
    }

    public int hashCode() {
        return this.abstractPath.hashCode() + 13 * this.type.ordinal();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Path Entry: ");
        stringBuilder.append(this.abstractPath).append(" (").append((Object)this.type).append(")");
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        WORKSPACE("Workspace File"),
        INCLUDE_VAR("Include Path Variable"),
        INCLUDE_FOLDER("Include Path Folder"),
        EXTERNAL("External File");

        private String name;

        private Type(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }
}

