/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.phpIni;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathVariableManager;
import org.eclipse.php.internal.core.util.PHPSearchEngine;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.phpIni.INIFileModifier;

public class PHPINIUtil {
    private static final String PHP_INI_FILE = "php.ini";
    private static final String INCLUDE_PATH = "include_path";
    private static final String ZEND_EXTENSION = "zend_extension";
    private static final String ZEND_EXTENSION_TS = "zend_extension_ts";

    private static void modifyIncludePath(File file, String[] stringArray) {
        try {
            INIFileModifier iNIFileModifier = new INIFileModifier(file);
            iNIFileModifier.removeAllEntries(INCLUDE_PATH);
            StringBuilder stringBuilder = new StringBuilder(".");
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                stringBuilder.append(File.pathSeparatorChar).append(string);
                ++n2;
            }
            iNIFileModifier.addEntry(INCLUDE_PATH, stringBuilder.toString());
            iNIFileModifier.close();
        }
        catch (IOException iOException) {
            PHPDebugPlugin.log(iOException);
        }
    }

    private static void modifyDebuggerExtensionPath(File file, String string) {
        try {
            INIFileModifier iNIFileModifier = new INIFileModifier(file);
            if ("win32".equals(Platform.getOS())) {
                if (iNIFileModifier.removeAllEntries(ZEND_EXTENSION_TS, ".*\\.\\\\ZendDebugger\\.dll.*")) {
                    iNIFileModifier.addEntry(ZEND_EXTENSION_TS, string);
                }
            } else if (iNIFileModifier.removeAllEntries(ZEND_EXTENSION, ".*\\./ZendDebugger\\.so.*")) {
                iNIFileModifier.addEntry(ZEND_EXTENSION, string);
            }
            iNIFileModifier.close();
        }
        catch (IOException iOException) {
            PHPDebugPlugin.log(iOException);
        }
    }

    public static File prepareBeforeDebug(File file, String string, IProject iProject) {
        Object object;
        File file2 = PHPINIUtil.createTemporaryPHPINIFile(file);
        if (iProject != null) {
            object = PHPSearchEngine.buildIncludePath((IProject)iProject);
            ArrayList<String> arrayList = new ArrayList<String>(((Object[])object).length);
            Object[] objectArray = object;
            int n = ((Object[])object).length;
            int n2 = 0;
            while (n2 < n) {
                IPath iPath;
                IIncludePathEntry iIncludePathEntry;
                Object object2 = objectArray[n2];
                if (object2 instanceof IIncludePathEntry) {
                    iIncludePathEntry = (IIncludePathEntry)object2;
                    iPath = iIncludePathEntry.getPath();
                    if (iIncludePathEntry.getEntryKind() == 4) {
                        iPath = IncludePathVariableManager.instance().resolveVariablePath(iPath.toString());
                    }
                    if (iPath != null) {
                        arrayList.add(iPath.toFile().getAbsolutePath());
                    }
                } else if (object2 instanceof IContainer) {
                    iIncludePathEntry = (IContainer)object2;
                    iPath = iIncludePathEntry.getLocation();
                    if (iPath != null) {
                        arrayList.add(iPath.toOSString());
                    }
                } else {
                    arrayList.add(object2.toString());
                }
                ++n2;
            }
            PHPINIUtil.modifyIncludePath(file2, arrayList.toArray(new String[arrayList.size()]));
        }
        if (file != null && ((File)(object = new File(file.getParentFile(), "win32".equals(Platform.getOS()) ? "ZendDebugger.dll" : "ZendDebugger.so"))).exists()) {
            PHPINIUtil.modifyDebuggerExtensionPath(file2, ((File)object).getAbsolutePath());
        }
        return file2;
    }

    public static File createTemporaryPHPINIFile() {
        return PHPINIUtil.createTemporaryPHPINIFile(null);
    }

    public static File createTemporaryPHPINIFile(File file) {
        File file2 = null;
        try {
            File file3 = new File(System.getProperty("java.io.tmpdir"), "zend_debug");
            if (!file3.exists()) {
                file3.mkdir();
                file3.deleteOnExit();
            }
            file3 = File.createTempFile("session", null, file3);
            file3.delete();
            file3.mkdir();
            file3.deleteOnExit();
            file2 = new File(file3, PHP_INI_FILE);
            file2.createNewFile();
            file2.deleteOnExit();
            if (file != null && file.exists()) {
                new LocalFile(file).copy((IFileStore)new LocalFile(file2), 2, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception exception) {
            PHPDebugPlugin.log(exception);
        }
        return file2;
    }

    public static File findPHPIni(String string) {
        File file = new File(string);
        File file2 = new File(file.getParentFile(), PHP_INI_FILE);
        if (file2.exists() && file2.canRead()) {
            return file2;
        }
        return null;
    }
}

