/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.hover;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.dialogs.openType.OpenPhpElementDialog;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class PHPCodeHyperLink
implements IHyperlink {
    private IRegion fRegion;
    private CodeData[] codeDatas;

    public PHPCodeHyperLink(IRegion iRegion, CodeData[] codeDataArray) {
        this.fRegion = iRegion;
        this.codeDatas = codeDataArray;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public String getHyperlinkText() {
        return null;
    }

    public String getTypeLabel() {
        return null;
    }

    public void open() {
        OpenPhpElementDialog openPhpElementDialog;
        if (this.codeDatas == null) {
            return;
        }
        CodeData codeData = null;
        this.codeDatas[0].getName();
        if (this.codeDatas.length > 1) {
            openPhpElementDialog = new OpenPhpElementDialog(Display.getDefault().getActiveShell());
            openPhpElementDialog.getFilter().setSelectClasses(false);
            openPhpElementDialog.getFilter().setSelectFunctions(false);
            openPhpElementDialog.getFilter().setSelectConstants(false);
            if (this.codeDatas[0] instanceof PHPClassData) {
                openPhpElementDialog.getFilter().setSelectClasses(true);
            } else if (this.codeDatas[0] instanceof PHPConstantData) {
                openPhpElementDialog.getFilter().setSelectConstants(true);
            } else if (this.codeDatas[0] instanceof PHPFunctionData) {
                openPhpElementDialog.getFilter().setSelectFunctions(true);
            } else if (this.codeDatas[0] instanceof PHPClassVarData) {
                codeData = this.codeDatas[0];
            }
            if (codeData == null) {
                openPhpElementDialog.setInitialElements(this.codeDatas);
                openPhpElementDialog.setInitFilterText(this.codeDatas[0].getName());
                if (openPhpElementDialog.open() == 1) {
                    return;
                }
                codeData = openPhpElementDialog.getSelectedElement();
            }
        } else {
            codeData = this.codeDatas[0];
        }
        if ((openPhpElementDialog = EditorUtility.isOpenInEditor(codeData)) != null) {
            IWorkbenchPage iWorkbenchPage = PHPUiPlugin.getActivePage();
            if (iWorkbenchPage != null) {
                iWorkbenchPage.bringToTop((IWorkbenchPart)openPhpElementDialog);
            }
            EditorUtility.revealInEditor((IEditorPart)openPhpElementDialog, (PHPCodeData)codeData);
        } else {
            try {
                openPhpElementDialog = EditorUtility.openInEditor(codeData);
                EditorUtility.revealInEditor((IEditorPart)openPhpElementDialog, (PHPCodeData)codeData);
            }
            catch (PartInitException partInitException) {
                Logger.logException(partInitException);
            }
        }
    }
}

