/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.folding.projection;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.documentModel.dom.ElementImplForPhp;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.folding.projection.CaptionedPosition;
import org.eclipse.php.internal.ui.folding.projection.CommentPosition;
import org.eclipse.php.internal.ui.folding.projection.Element;
import org.eclipse.php.internal.ui.folding.projection.ElementProjectionAnnotation;
import org.eclipse.php.internal.ui.folding.projection.ProjectionModelNodeAdapterFactoryPHP;
import org.eclipse.php.internal.ui.folding.projection.ProjectionModelNodeAdapterHTML;
import org.eclipse.php.internal.ui.folding.projection.ProjectionViewerInformation;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectionModelNodeAdapterPHP
extends ProjectionModelNodeAdapterHTML {
    private IStructuredDocument document;
    private boolean shouldAutoCollapseAnnotations = true;

    public ProjectionModelNodeAdapterPHP(ProjectionModelNodeAdapterFactoryPHP projectionModelNodeAdapterFactoryPHP) {
        super(projectionModelNodeAdapterFactoryPHP);
    }

    @Override
    public boolean isAdapterForType(Object object) {
        return object == ProjectionModelNodeAdapterPHP.class;
    }

    @Override
    public void updateAdapter(Node node, ProjectionViewer projectionViewer) {
        HashMap<ProjectionAnnotation, Position> hashMap = new HashMap<ProjectionAnnotation, Position>();
        HashMap<ProjectionAnnotation, Position> hashMap2 = new HashMap<ProjectionAnnotation, Position>();
        if (node != null && node instanceof NodeImpl) {
            NodeImpl nodeImpl = (NodeImpl)node;
            assert (nodeImpl.getModel() instanceof DOMModelForPHP) : PHPUIMessages.getString("ProjectionModelNodeAdapterPHP.0");
            DOMModelForPHP dOMModelForPHP = (DOMModelForPHP)nodeImpl.getModel();
            this.document = dOMModelForPHP.getStructuredDocument();
            ProjectionViewer projectionViewer2 = this.getAdapterFactory().findViewer(dOMModelForPHP);
            if (projectionViewer2 == null) {
                return;
            }
            ProjectionViewerInformation projectionViewerInformation = this.getAdapterFactory().getInformation(projectionViewer2);
            if (projectionViewerInformation.isDocumentChanging()) {
                return;
            }
            PHPFileData pHPFileData = dOMModelForPHP.getFileData();
            if (pHPFileData == null) {
                return;
            }
            this.createAnnotationsForChild(hashMap, hashMap2, pHPFileData, node.getFirstChild());
            ProjectionAnnotation[] projectionAnnotationArray = null;
            if (!this.previousAnnotations.isEmpty()) {
                projectionAnnotationArray = this.previousAnnotations.keySet().toArray(new ProjectionAnnotation[0]);
            }
            if (projectionViewer != null && !hashMap2.isEmpty()) {
                this.fAdapterFactory.queueAnnotationModelChanges(node, null, hashMap2, null, projectionViewer);
            }
            if (projectionAnnotationArray != null && projectionAnnotationArray.length > 0 || !hashMap.isEmpty() || hashMap2.size() > 0) {
                this.fAdapterFactory.queueAnnotationModelChanges(node, (Annotation[])projectionAnnotationArray, hashMap, hashMap2);
            }
            this.shouldAutoCollapseAnnotations = false;
        }
        this.previousAnnotations = hashMap2;
    }

    private final Node createAnnotationsForChild(Map<ProjectionAnnotation, Position> map, Map<ProjectionAnnotation, Position> map2, PHPFileData pHPFileData, Node node) {
        while (node != null) {
            if (node.getNodeType() == 1) {
                assert (node instanceof ElementImplForPhp) : PHPUIMessages.getString("ProjectionModelNodeAdapterPHP.1");
                ElementImplForPhp elementImplForPhp = (ElementImplForPhp)node;
                if (elementImplForPhp.isPhpTag()) {
                    int n = elementImplForPhp.getStartOffset();
                    int n2 = elementImplForPhp.getEndOffset();
                    this.createFileAnnotations(map2, map, pHPFileData, n, n2);
                }
                elementImplForPhp.getFirstChild();
                this.createAnnotationsForChild(map, map2, pHPFileData, elementImplForPhp.getFirstChild());
            }
            node = node.getNextSibling();
        }
        return node;
    }

    private void createFileAnnotations(Map<ProjectionAnnotation, Position> map, Map<ProjectionAnnotation, Position> map2, PHPFileData pHPFileData, int n, int n2) {
        Object object;
        Object object2;
        PHPClassData pHPClassData;
        ProjectionModelNodeAdapterFactoryPHP projectionModelNodeAdapterFactoryPHP = this.getAdapterFactory();
        assert (projectionModelNodeAdapterFactoryPHP != null) : PHPUIMessages.getString("ProjectionModelNodeAdapterPHP.2");
        boolean bl = projectionModelNodeAdapterFactoryPHP.isFoldingPhpDoc();
        boolean bl2 = projectionModelNodeAdapterFactoryPHP.isFoldingFunctions();
        boolean bl3 = projectionModelNodeAdapterFactoryPHP.isFoldingClasses();
        Element element = Element.ElementFactory.createFileElement(pHPFileData);
        this.createDocBlockAnnotations(element, (PHPCodeData)pHPFileData, map, map2, n, n2, bl);
        PHPClassData[] pHPClassDataArray = pHPFileData.getClasses();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        PHPClassData[] pHPClassDataArray2 = pHPClassDataArray;
        int n3 = pHPClassDataArray.length;
        int n4 = 0;
        while (n4 < n3) {
            PHPFunctionData pHPFunctionData;
            pHPClassData = pHPClassDataArray2[n4];
            Integer n5 = (Integer)hashMap.get(pHPClassData.getName());
            n5 = n5 == null ? new Integer(0) : Integer.valueOf(n5 + 1);
            hashMap.put(pHPClassData.getName(), n5);
            object2 = this.createCodeDataAnnotations(element, (PHPCodeData)pHPClassData, map, map2, n5, n, n2, bl3, bl);
            object = pHPClassData.getFunctions();
            HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
            Object object3 = object;
            int n6 = ((PHPFunctionData[])object).length;
            int n7 = 0;
            while (n7 < n6) {
                pHPFunctionData = object3[n7];
                Integer n8 = (Integer)hashMap2.get(pHPFunctionData.getName());
                n8 = n8 == null ? new Integer(0) : Integer.valueOf(n8 + 1);
                hashMap2.put(pHPFunctionData.getName(), n8);
                this.createCodeDataAnnotations((Element)object2, (PHPCodeData)pHPFunctionData, map, map2, n8, n, n2, bl2, bl);
                ++n7;
            }
            pHPFunctionData = pHPClassData.getVars();
            HashMap<String, Integer> hashMap3 = new HashMap<String, Integer>();
            PHPFunctionData pHPFunctionData2 = pHPFunctionData;
            int n9 = ((PHPFunctionData)pHPFunctionData2).length;
            int n10 = 0;
            while (n10 < n9) {
                PHPFunctionData pHPFunctionData3 = pHPFunctionData2[n10];
                Integer n11 = (Integer)hashMap3.get(pHPFunctionData3.getName());
                n11 = n11 == null ? new Integer(0) : Integer.valueOf(n11 + 1);
                hashMap3.put(pHPFunctionData3.getName(), n11);
                this.createCodeDataAnnotations((Element)object2, (PHPCodeData)pHPFunctionData3, map, map2, n11, n, n2, false, bl);
                ++n10;
            }
            PHPClassConstData[] pHPClassConstDataArray = pHPClassData.getConsts();
            object3 = new HashMap();
            PHPClassConstData[] pHPClassConstDataArray2 = pHPClassConstDataArray;
            int n12 = pHPClassConstDataArray.length;
            int n13 = 0;
            while (n13 < n12) {
                PHPClassConstData pHPClassConstData = pHPClassConstDataArray2[n13];
                Integer n14 = (Integer)object3.get(pHPClassConstData.getName());
                n14 = n14 == null ? new Integer(0) : Integer.valueOf(n14 + 1);
                object3.put(pHPClassConstData.getName(), n14);
                this.createCodeDataAnnotations((Element)object2, (PHPCodeData)pHPClassConstData, map, map2, n14, n, n2, false, bl);
                ++n13;
            }
            ++n4;
        }
        pHPClassData = pHPFileData.getFunctions();
        HashMap<String, PHPFunctionData[]> hashMap4 = new HashMap<String, PHPFunctionData[]>();
        object2 = pHPClassData;
        int n15 = ((PHPClassData)object2).length;
        int n16 = 0;
        while (n16 < n15) {
            PHPClassData pHPClassData2 = object2[n16];
            object = (PHPFunctionData[])hashMap4.get(pHPClassData2.getName());
            object = object == null ? new Integer(0) : Integer.valueOf(object.intValue() + 1);
            hashMap4.put(pHPClassData2.getName(), (PHPFunctionData[])object);
            this.createCodeDataAnnotations(element, (PHPCodeData)pHPClassData2, map, map2, object.intValue(), n, n2, bl2, bl);
            ++n16;
        }
    }

    private Element createCodeDataAnnotations(Element element, PHPCodeData pHPCodeData, Map<ProjectionAnnotation, Position> map, Map<ProjectionAnnotation, Position> map2, int n, int n2, int n3, boolean bl, boolean bl2) {
        UserData userData = pHPCodeData.getUserData();
        int n4 = userData.getStartPosition();
        int n5 = userData.getEndPosition();
        boolean bl3 = this.document.getLineOfOffset(n4) != this.document.getLineOfOffset(n5);
        bl3 &= n4 > n2 && n4 < n3;
        ElementProjectionAnnotation elementProjectionAnnotation = new ElementProjectionAnnotation(element, pHPCodeData, n, this.shouldAutoCollapseAnnotations ? bl : false);
        ElementProjectionAnnotation elementProjectionAnnotation2 = this.getExistingAnnotation(elementProjectionAnnotation);
        Position position = this.createPosition(n4, userData.getEndPosition(), (IDocument)this.document);
        Element element2 = elementProjectionAnnotation.element;
        if (bl3) {
            if (elementProjectionAnnotation2 == null) {
                map.put(elementProjectionAnnotation, position);
                map2.put(elementProjectionAnnotation, position);
            } else {
                map.put(elementProjectionAnnotation2, position);
                this.previousAnnotations.remove((Object)elementProjectionAnnotation2);
            }
        }
        this.createDocBlockAnnotations(element2, pHPCodeData, map, map2, n2, n3, bl2);
        return element2;
    }

    private void createDocBlockAnnotations(Element element, PHPCodeData pHPCodeData, Map<ProjectionAnnotation, Position> map, Map<ProjectionAnnotation, Position> map2, int n, int n2, boolean bl) {
        PHPDocBlock pHPDocBlock = pHPCodeData.getDocBlock();
        if (pHPDocBlock == null) {
            return;
        }
        int n3 = pHPDocBlock.getStartPosition();
        int n4 = pHPDocBlock.getEndPosition();
        if (this.document.getLineOfOffset(n3) >= this.document.getLineOfOffset(n4)) {
            return;
        }
        if (n3 > n && n3 < n2) {
            Position position = this.createCommentPosition(n3, pHPDocBlock.getEndPosition(), (IDocument)this.document);
            ElementProjectionAnnotation elementProjectionAnnotation = new ElementProjectionAnnotation(element, pHPDocBlock, this.shouldAutoCollapseAnnotations ? bl : false);
            ElementProjectionAnnotation elementProjectionAnnotation2 = this.getExistingAnnotation(elementProjectionAnnotation);
            if (elementProjectionAnnotation2 == null) {
                map.put(elementProjectionAnnotation, position);
                map2.put(elementProjectionAnnotation, position);
            } else {
                map.put(elementProjectionAnnotation2, position);
                this.previousAnnotations.remove((Object)elementProjectionAnnotation2);
            }
        }
    }

    private Position createPosition(int n, int n2, IDocument iDocument) {
        assert (iDocument != null);
        IRegion iRegion = this.alignRegion(n, n2, iDocument);
        return new CaptionedPosition(iRegion.getOffset(), iRegion.getLength());
    }

    private Position createCommentPosition(int n, int n2, IDocument iDocument) {
        assert (iDocument != null);
        IRegion iRegion = this.alignRegion(n, n2, iDocument);
        return new CommentPosition(iRegion.getOffset(), iRegion.getLength());
    }

    protected final IRegion alignRegion(int n, int n2, IDocument iDocument) {
        try {
            int n3 = iDocument.getLength();
            int n4 = iDocument.getLineOfOffset(n);
            int n5 = iDocument.getLineOfOffset(Math.min(n3, n2));
            if (n4 >= n5) {
                return new Region(n, 0);
            }
            int n6 = iDocument.getLineOffset(n4);
            int n7 = iDocument.getNumberOfLines() > n5 + 1 ? iDocument.getLineOffset(n5 + 1) : iDocument.getLineOffset(n5) + iDocument.getLineLength(n5);
            return new Region(n6, n7 - n6);
        }
        catch (BadLocationException badLocationException) {
            return new Region(n, n2 - n);
        }
    }

    private ElementProjectionAnnotation getExistingAnnotation(ElementProjectionAnnotation elementProjectionAnnotation) {
        assert (elementProjectionAnnotation != null) : PHPUIMessages.getString("ProjectionModelNodeAdapterPHP.3");
        if (!this.previousAnnotations.isEmpty()) {
            for (ProjectionAnnotation projectionAnnotation : this.previousAnnotations.keySet()) {
                if (!elementProjectionAnnotation.equals(projectionAnnotation)) continue;
                return (ElementProjectionAnnotation)projectionAnnotation;
            }
        }
        return null;
    }

    private ProjectionModelNodeAdapterFactoryPHP getAdapterFactory() {
        assert (this.fAdapterFactory instanceof ProjectionModelNodeAdapterFactoryPHP) : PHPUIMessages.getString("ProjectionModelNodeAdapterPHP.4");
        return (ProjectionModelNodeAdapterFactoryPHP)this.fAdapterFactory;
    }
}

