/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.AbstractPreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class PHPEditorPreferencePage
extends AbstractPreferencePage {
    private Button useSmartHomeEndCB;
    private Button useSmartSubWordNavigation;

    protected Control createContents(Composite composite) {
        this.createHeader(composite);
        this.createMainComposite(composite);
        this.initValues();
        return super.createContents(composite);
    }

    private void createMainComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 4);
        composite2.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        this.useSmartHomeEndCB = new Button(composite2, 16416);
        this.useSmartHomeEndCB.setLayoutData((Object)gridData);
        this.useSmartHomeEndCB.setText(PHPUIMessages.getString("PHPEditorPreferencePage_smartCaretPositioning"));
        gridData = new GridData(768);
        this.useSmartSubWordNavigation = new Button(composite2, 16416);
        this.useSmartSubWordNavigation.setLayoutData((Object)gridData);
        this.useSmartSubWordNavigation.setText(PHPUIMessages.getString("PHPEditorPreferencePage.0"));
    }

    protected void performDefaults() {
        this.useSmartHomeEndCB.setSelection(true);
        this.useSmartSubWordNavigation.setSelection(true);
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore iPreferenceStore = PHPUiPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.setValue("useSmartHomeEnd", this.useSmartHomeEndCB.getSelection());
        iPreferenceStore.setValue("editorSubWordNavigation", this.useSmartSubWordNavigation.getSelection());
        return super.performOk();
    }

    private void createHeader(Composite composite) {
        final Shell shell = composite.getShell();
        String string = PHPUIMessages.getString("PHPEditorPreferencePage_prefEditorMessage");
        Link link = new Link(composite, 0);
        link.setText(string);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"org.eclipse.ui.preferencePages.GeneralTextEditor", null, null);
            }
        });
        link.setToolTipText(PHPUIMessages.getString("PHPEditorPreferencePage_prefEditorTooltip"));
        GridData gridData = new GridData(4, 1, true, false);
        gridData.widthHint = 150;
        link.setLayoutData((Object)gridData);
    }

    protected void initValues() {
        IPreferenceStore iPreferenceStore = PHPUiPlugin.getDefault().getPreferenceStore();
        this.useSmartHomeEndCB.setSelection(iPreferenceStore.getBoolean("useSmartHomeEnd"));
        this.useSmartSubWordNavigation.setSelection(iPreferenceStore.getBoolean("editorSubWordNavigation"));
        super.initializeValues();
    }
}

