/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.search.Messages;
import org.eclipse.php.internal.ui.search.PHPSearchEngine;
import org.eclipse.php.internal.ui.search.PHPSearchResult;
import org.eclipse.php.internal.ui.search.PatternQuerySpecification;
import org.eclipse.php.internal.ui.search.QuerySpecification;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;

public class PHPSearchQuery
implements ISearchQuery {
    private ISearchResult fResult;
    private QuerySpecification fPatternData;

    public PHPSearchQuery(QuerySpecification querySpecification) {
        this.fPatternData = querySpecification;
    }

    public IStatus run(IProgressMonitor iProgressMonitor) throws OperationCanceledException {
        PHPSearchResult pHPSearchResult = (PHPSearchResult)this.getSearchResult();
        pHPSearchResult.removeAll();
        PHPSearchEngine pHPSearchEngine = new PHPSearchEngine();
        int n = -1;
        iProgressMonitor.beginTask(PHPUIMessages.getString("PHPSearchQuery_task_label"), n);
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, n);
        String string = null;
        PatternQuerySpecification patternQuerySpecification = (PatternQuerySpecification)this.fPatternData;
        string = patternQuerySpecification.getQuery();
        pHPSearchEngine.search(string, this.fPatternData.getScope(), pHPSearchResult, patternQuerySpecification.isCaseSensitive(), (IProgressMonitor)subProgressMonitor);
        String string2 = Messages.format(PHPUIMessages.getString("PHPSearchQuery_status_ok_message"), String.valueOf(pHPSearchResult.getMatchCount()));
        return new Status(0, PHPUiPlugin.getPluginId(), 0, string2, null);
    }

    public String getLabel() {
        return PHPUIMessages.getString("PHPSearchQuery_label");
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            this.fResult = new PHPSearchResult(this);
        }
        return this.fResult;
    }

    QuerySpecification getSpecification() {
        return this.fPatternData;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getResultLabel(int n) {
        if (n == 1) {
            Object[] objectArray = new String[]{this.fPatternData.getQuery(), this.fPatternData.getScopeDescription()};
            return Messages.format(PHPUIMessages.getString("PHPSearchOperation_singularOccurrencesPostfix"), objectArray);
        }
        Object[] objectArray = new Object[]{this.fPatternData.getQuery(), new Integer(n), this.fPatternData.getScopeDescription()};
        return Messages.format(PHPUIMessages.getString("PHPSearchOperation_pluralOccurrencesPostfix"), objectArray);
    }
}

