/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.workingset;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.workingset.WorkingSetFilterActionGroup;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public class SelectWorkingSetAction
extends Action {
    private IWorkbenchPartSite fSite;
    private Shell fShell;
    private WorkingSetFilterActionGroup fActionGroup;

    public SelectWorkingSetAction(WorkingSetFilterActionGroup workingSetFilterActionGroup, IWorkbenchPartSite iWorkbenchPartSite) {
        this(workingSetFilterActionGroup);
        this.fSite = iWorkbenchPartSite;
    }

    public SelectWorkingSetAction(WorkingSetFilterActionGroup workingSetFilterActionGroup, Shell shell) {
        this(workingSetFilterActionGroup);
        this.fShell = shell;
    }

    private SelectWorkingSetAction(WorkingSetFilterActionGroup workingSetFilterActionGroup) {
        super(PHPUIMessages.getString("SelectWorkingSetAction_text"));
        Assert.isNotNull((Object)workingSetFilterActionGroup);
        this.setToolTipText(PHPUIMessages.getString("SelectWorkingSetAction_toolTip"));
        this.fActionGroup = workingSetFilterActionGroup;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.php.ui.select_working_set_action");
    }

    public void run() {
        Shell shell = this.getShell();
        IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog iWorkingSetSelectionDialog = iWorkingSetManager.createWorkingSetSelectionDialog(shell, false);
        IWorkingSet iWorkingSet = this.fActionGroup.getWorkingSet();
        if (iWorkingSet != null) {
            iWorkingSetSelectionDialog.setSelection(new IWorkingSet[]{iWorkingSet});
        }
        if (iWorkingSetSelectionDialog.open() == 0) {
            IWorkingSet[] iWorkingSetArray = iWorkingSetSelectionDialog.getSelection();
            if (iWorkingSetArray != null && iWorkingSetArray.length > 0) {
                this.fActionGroup.setWorkingSet(iWorkingSetArray[0], true);
                iWorkingSetManager.addRecentWorkingSet(iWorkingSetArray[0]);
            } else {
                this.fActionGroup.setWorkingSet(null, true);
            }
        }
    }

    private Shell getShell() {
        if (this.fSite != null) {
            return this.fSite.getShell();
        }
        if (this.fShell != null) {
            return this.fShell;
        }
        return PHPUiPlugin.getActiveWorkbenchShell();
    }
}

