/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.BuildAction;
import org.eclipse.php.internal.ui.actions.RefreshAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.ide.IDEActionFactory;

public class BuildActionGroup
extends ActionGroup {
    private IWorkbenchSite fSite;
    private BuildAction fBuildAction;
    private RefreshAction fRefreshAction;

    public BuildActionGroup(IViewPart iViewPart) {
        this.fSite = iViewPart.getSite();
        Shell shell = this.fSite.getShell();
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        this.fBuildAction = new BuildAction(shell, 10);
        this.fBuildAction.setText(PHPUIMessages.getString("BuildAction_label"));
        this.fBuildAction.setActionDefinitionId("org.eclipse.ui.project.buildProject");
        this.fRefreshAction = new RefreshAction(this.fSite);
        this.fRefreshAction.setActionDefinitionId("org.eclipse.ui.file.refresh");
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.fBuildAction);
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.fRefreshAction);
    }

    public IAction getRefreshAction() {
        return this.fRefreshAction;
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        this.setGlobalActionHandlers(iActionBars);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        ISelection iSelection = this.getContext().getSelection();
        if (!ResourcesPlugin.getWorkspace().isAutoBuilding() && this.isBuildTarget(iSelection)) {
            this.appendToGroup(iMenuManager, (IAction)this.fBuildAction);
        }
        this.appendToGroup(iMenuManager, (IAction)this.fRefreshAction);
        super.fillContextMenu(iMenuManager);
    }

    public void dispose() {
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fBuildAction);
        iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fRefreshAction);
        super.dispose();
    }

    private void setGlobalActionHandlers(IActionBars iActionBars) {
        iActionBars.setGlobalActionHandler(IDEActionFactory.BUILD_PROJECT.getId(), (IAction)this.fBuildAction);
        iActionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.fRefreshAction);
    }

    private void appendToGroup(IMenuManager iMenuManager, IAction iAction) {
        if (iAction.isEnabled()) {
            iMenuManager.appendToGroup("group.build", iAction);
        }
    }

    private boolean isBuildTarget(ISelection iSelection) {
        if (!(iSelection instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        if (iStructuredSelection.size() != 1) {
            return false;
        }
        return iStructuredSelection.getFirstElement() instanceof PHPProjectModel;
    }
}

