/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.templates.resolver;

import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.phpModel.parser.ModelSupport;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.editor.templates.PhpTemplateContext;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class PhpTemplateClassContainerResolver
extends TemplateVariableResolver {
    public static final String NO_CLASS = "no_class_scope";

    public PhpTemplateClassContainerResolver() {
        super("class_container", PHPUIMessages.getString("PhpTemplateClassContainerResolver.1"));
    }

    protected String resolve(TemplateContext templateContext) {
        PhpTemplateContext phpTemplateContext = (PhpTemplateContext)templateContext;
        IModelManager iModelManager = StructuredModelManager.getModelManager();
        if (iModelManager == null) {
            return null;
        }
        IStructuredModel iStructuredModel = iModelManager.getExistingModelForRead(phpTemplateContext.getDocument());
        if (iStructuredModel == null) {
            return null;
        }
        try {
            DOMModelForPHP dOMModelForPHP = (DOMModelForPHP)iStructuredModel;
            PHPFileData pHPFileData = dOMModelForPHP.getFileData();
            if (pHPFileData == null) {
                return null;
            }
            PHPCodeContext pHPCodeContext = ModelSupport.createContext((PHPFileData)pHPFileData, (int)phpTemplateContext.getStart());
            String string = pHPCodeContext.getContainerClassName();
            if (string == null || string.equals("")) {
                return NO_CLASS;
            }
            String string2 = string;
            return string2;
        }
        finally {
            iStructuredModel.releaseFromRead();
        }
    }
}

