/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.search.PHPSearchQuery;
import org.eclipse.php.internal.ui.search.decorators.PHPClassConstantDataDecorator;
import org.eclipse.php.internal.ui.search.decorators.PHPClassDataDecorator;
import org.eclipse.php.internal.ui.search.decorators.PHPConstantDataDecorator;
import org.eclipse.php.internal.ui.search.decorators.PHPDataDecorator;
import org.eclipse.php.internal.ui.search.decorators.PHPFunctionDataDecorator;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;

public class PHPSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    private PHPSearchQuery fQuery;
    private static final Match[] NO_MATCHES = new Match[0];
    private ISearchResultListener fFilterListener;

    public PHPSearchResult(PHPSearchQuery pHPSearchQuery) {
        this.fQuery = pHPSearchQuery;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.fQuery.getImageDescriptor();
    }

    public String getLabel() {
        return this.fQuery.getResultLabel(this.getMatchCount());
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public void setFilterListner(ISearchResultListener iSearchResultListener) {
        this.fFilterListener = iSearchResultListener;
    }

    protected void fireChange(SearchResultEvent searchResultEvent) {
        if (this.fFilterListener != null) {
            this.fFilterListener.searchResultChanged(searchResultEvent);
        }
        super.fireChange(searchResultEvent);
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult abstractTextSearchResult, IEditorPart object) {
        IEditorInput iEditorInput;
        PHPStructuredEditor pHPStructuredEditor = EditorUtility.getPHPStructuredEditor((IWorkbenchPart)object);
        if (pHPStructuredEditor != null) {
            object = pHPStructuredEditor;
        }
        if ((iEditorInput = object.getEditorInput()) instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            return this.computeContainedMatches(abstractTextSearchResult, iFileEditorInput.getFile());
        }
        return NO_MATCHES;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult abstractTextSearchResult, IFile iFile) {
        HashSet hashSet = new HashSet();
        PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iFile.getProject());
        if (pHPProjectModel != null) {
            this.collectMatches(hashSet, pHPProjectModel.getFileData(iFile.getFullPath().toString()));
        }
        return hashSet.toArray(new Match[hashSet.size()]);
    }

    private void collectMatches(Set set, PHPFileData pHPFileData) {
        if (pHPFileData == null) {
            return;
        }
        PHPClassData[] pHPClassDataArray = pHPFileData.getClasses();
        switch (this.fQuery.getSpecification().getScope().getSearchFor()) {
            case 0: {
                PHPClassData[] pHPClassDataArray2 = pHPFileData.getClasses();
                int n = 0;
                while (n < pHPClassDataArray2.length) {
                    this.addToMatches(set, new PHPClassDataDecorator(pHPClassDataArray2[n], null));
                    ++n;
                }
                break;
            }
            case 1: {
                PHPFunctionData[] pHPFunctionDataArray = pHPFileData.getFunctions();
                int n = 0;
                while (n < pHPFunctionDataArray.length) {
                    this.addToMatches(set, new PHPFunctionDataDecorator(pHPFunctionDataArray[n], null));
                    ++n;
                }
                n = 0;
                while (n < pHPClassDataArray.length) {
                    pHPFunctionDataArray = pHPClassDataArray[n].getFunctions();
                    int n2 = 0;
                    while (n2 < pHPFunctionDataArray.length) {
                        this.addToMatches(set, new PHPFunctionDataDecorator(pHPFunctionDataArray[n2], null));
                        ++n2;
                    }
                    ++n;
                }
                break;
            }
            case 2: {
                PHPConstantData[] pHPConstantDataArray = pHPFileData.getConstants();
                int n = 0;
                while (n < pHPConstantDataArray.length) {
                    this.addToMatches(set, new PHPConstantDataDecorator(pHPConstantDataArray[n], null));
                    ++n;
                }
                n = 0;
                while (n < pHPClassDataArray.length) {
                    PHPClassConstData[] pHPClassConstDataArray = pHPClassDataArray[n].getConsts();
                    int n3 = 0;
                    while (n3 < pHPClassConstDataArray.length) {
                        this.addToMatches(set, new PHPClassConstantDataDecorator(pHPClassConstDataArray[n3], null));
                        ++n3;
                    }
                    ++n;
                }
                break;
            }
        }
    }

    private void addToMatches(Set set, PHPDataDecorator pHPDataDecorator) {
        Match[] matchArray = this.getMatches(pHPDataDecorator);
        if (matchArray != null) {
            int n = 0;
            while (n < matchArray.length) {
                set.add(matchArray[n]);
                ++n;
            }
        }
    }

    public IFile getFile(Object object) {
        if (object instanceof CodeData) {
            CodeData codeData = (CodeData)object;
            return (IFile)codeData.getAdapter(IResource.class);
        }
        if (object instanceof IFile) {
            return (IFile)object;
        }
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart object) {
        PHPCodeData pHPCodeData;
        IFile iFile;
        PHPStructuredEditor pHPStructuredEditor = EditorUtility.getPHPStructuredEditor((IWorkbenchPart)object);
        if (pHPStructuredEditor != null) {
            object = pHPStructuredEditor;
        }
        IEditorInput iEditorInput = object.getEditorInput();
        if (match.getElement() instanceof PHPCodeData && (iFile = (IFile)(pHPCodeData = (PHPCodeData)match.getElement()).getAdapter(IResource.class)) != null && iEditorInput != null && iEditorInput instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
            return iFile.equals((Object)iFileEditorInput.getFile());
        }
        return false;
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }
}

