/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.tablewizard.ui.wizardpages.columns;

import org.eclipse.datatools.sqltools.tablewizard.ui.utils.ResourceLoader;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class GenericColumnsComposite
extends Composite {
    private static final String COLUMN_NAME_LABEL = "column.name.label";
    private static final String COLUMN_DATATYPE_LABEL = "column.datatype.label";
    private static final String COLUMN_NULLABLE_LABEL = "column.nullable.label";
    private static final String COLUMN_DEFAULT_VALUE_LABEL = "column.default_value.label";
    private static final String TABLE_NAME_LABEL = "table.name.label";
    private static final String COLUMN_ADD_BUTTON_LABEL = "column.add_button.label";
    private static final String COLUMN_DELETE_BUTTON_LABEL = "column.delete_button.label";
    private static final String COLUMNS_DETAIL_GROUP_LABEL = "columns.detail_group.label";
    private static final String COLUMNS_NAME_LABEL = "columns.name.label";
    private static final String COLUMNS_DATATYPE_LABEL = "columns.datatype.label";
    private static final String COLUMNS_LENGTH_LABEL = "columns.length.label";
    private static final String COLUMNS_NULLABLE_LABEL = "columns.nullable.label";
    private static final String COLUMNS_DEFAULT_VALUE_LABEL = "columns.default_value.label";
    private Composite header = null;
    private Label tableNameLabel = null;
    private Text tableNameText = null;
    private Composite buttonComposite = null;
    private Button addButton = null;
    private Button deleteButton = null;
    private Group detailGroup = null;
    private Label columnNameLabel = null;
    private Text columnNameText = null;
    private Label dataTypeLabel = null;
    private Button notNullCheck = null;
    private Label defaultValueLabel = null;
    private Text defaultValueText = null;
    private TableViewer columnsTableViewer = null;
    private ComboViewer dataTypeComboViewer = null;
    private Label dataTypeLengthLabel = null;
    private Text dataTypeLengthText = null;

    public GenericColumnsComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public TableViewer getColumnsTableViewer() {
        return this.columnsTableViewer;
    }

    public ComboViewer getDataTypeComboViewer() {
        return this.dataTypeComboViewer;
    }

    public Button getAddButton() {
        return this.addButton;
    }

    public Composite getButtonComposite() {
        return this.buttonComposite;
    }

    public Text getColumnNameText() {
        return this.columnNameText;
    }

    public Text getDefaultValueText() {
        return this.defaultValueText;
    }

    public Button getDeleteButton() {
        return this.deleteButton;
    }

    public Group getDetailGroup() {
        return this.detailGroup;
    }

    public Composite getHeader() {
        return this.header;
    }

    public Button getNotNullCheck() {
        return this.notNullCheck;
    }

    public Text getTableNameText() {
        return this.tableNameText;
    }

    public Text getDataTypeLengthText() {
        return this.dataTypeLengthText;
    }

    public Label getDataTypeLengthLabel() {
        return this.dataTypeLengthLabel;
    }

    private void initialize() {
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 4;
        gridData1.verticalAlignment = 4;
        gridData1.heightHint = 160;
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.grabExcessVerticalSpace = true;
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 1;
        this.createHeader();
        this.setLayout((Layout)gridLayout1);
        this.setSize(new Point(596, 300));
        Table columnsTable = new Table((Composite)this, 65536);
        columnsTable.setHeaderVisible(true);
        columnsTable.setLayoutData((Object)gridData1);
        columnsTable.setLinesVisible(true);
        this.columnsTableViewer = new TableViewer(columnsTable);
        TableColumn nameColumn = new TableColumn(columnsTable, 0);
        nameColumn.setWidth(100);
        nameColumn.setText(ResourceLoader.queryString(COLUMN_NAME_LABEL));
        TableColumn dataTypeColumn = new TableColumn(columnsTable, 0);
        dataTypeColumn.setWidth(60);
        dataTypeColumn.setText(ResourceLoader.queryString(COLUMN_DATATYPE_LABEL));
        TableColumn notNullColumn = new TableColumn(columnsTable, 0);
        notNullColumn.setWidth(60);
        notNullColumn.setText(ResourceLoader.queryString(COLUMN_NULLABLE_LABEL));
        TableColumn defaultValueColumn = new TableColumn(columnsTable, 0);
        defaultValueColumn.setWidth(160);
        defaultValueColumn.setText(ResourceLoader.queryString(COLUMN_DEFAULT_VALUE_LABEL));
        this.createButtonComposite();
        this.createDetailGroup();
    }

    private void createHeader() {
        GridData gridData21 = new GridData();
        gridData21.widthHint = 120;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        this.header = new Composite((Composite)this, 0);
        this.header.setLayoutData((Object)gridData);
        this.header.setLayout((Layout)gridLayout);
        this.tableNameLabel = new Label(this.header, 0);
        this.tableNameLabel.setText(ResourceLoader.queryString(TABLE_NAME_LABEL));
        this.tableNameText = new Text(this.header, 2048);
        this.tableNameText.setLayoutData((Object)gridData21);
    }

    private void createButtonComposite() {
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        this.buttonComposite = new Composite((Composite)this, 0);
        this.buttonComposite.setLayout((Layout)gridLayout2);
        this.addButton = new Button(this.buttonComposite, 0);
        this.addButton.setText(ResourceLoader.queryString(COLUMN_ADD_BUTTON_LABEL));
        this.deleteButton = new Button(this.buttonComposite, 0);
        this.deleteButton.setText(ResourceLoader.queryString(COLUMN_DELETE_BUTTON_LABEL));
    }

    private void createDetailGroup() {
        GridData gridData4 = new GridData();
        gridData4.widthHint = 40;
        GridData gridData7 = new GridData();
        gridData7.widthHint = 120;
        GridData gridData5 = new GridData();
        gridData5.widthHint = 120;
        GridData gridData3 = new GridData();
        gridData3.horizontalSpan = 2;
        GridData gridData2 = new GridData();
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.verticalAlignment = 2;
        gridData2.horizontalAlignment = 4;
        GridLayout gridLayout3 = new GridLayout();
        gridLayout3.numColumns = 6;
        this.detailGroup = new Group((Composite)this, 0);
        this.detailGroup.setText(ResourceLoader.queryString(COLUMNS_DETAIL_GROUP_LABEL));
        this.detailGroup.setLayoutData((Object)gridData2);
        this.detailGroup.setLayout((Layout)gridLayout3);
        this.columnNameLabel = new Label((Composite)this.detailGroup, 0);
        this.columnNameLabel.setText(ResourceLoader.queryString(COLUMNS_NAME_LABEL));
        this.columnNameText = new Text((Composite)this.detailGroup, 2048);
        this.columnNameText.setLayoutData((Object)gridData5);
        this.dataTypeLabel = new Label((Composite)this.detailGroup, 0);
        this.dataTypeLabel.setText(ResourceLoader.queryString(COLUMNS_DATATYPE_LABEL));
        this.createDataTypeCombo();
        this.dataTypeLengthLabel = new Label((Composite)this.getDetailGroup(), 0);
        this.dataTypeLengthLabel.setText(ResourceLoader.queryString(COLUMNS_LENGTH_LABEL));
        this.dataTypeLengthText = new Text((Composite)this.getDetailGroup(), 2048);
        this.dataTypeLengthText.setLayoutData((Object)gridData4);
        this.notNullCheck = new Button((Composite)this.detailGroup, 32);
        this.notNullCheck.setText(ResourceLoader.queryString(COLUMNS_NULLABLE_LABEL));
        this.notNullCheck.setLayoutData((Object)gridData3);
        this.defaultValueLabel = new Label((Composite)this.detailGroup, 0);
        this.defaultValueLabel.setText(ResourceLoader.queryString(COLUMNS_DEFAULT_VALUE_LABEL));
        this.defaultValueText = new Text((Composite)this.detailGroup, 2048);
        this.defaultValueText.setLayoutData((Object)gridData7);
    }

    private void createDataTypeCombo() {
        GridData gridData6 = new GridData();
        gridData6.widthHint = 120;
        Combo dataTypeCombo = new Combo((Composite)this.getDetailGroup(), 8);
        dataTypeCombo.setLayoutData((Object)gridData6);
        this.dataTypeComboViewer = new ComboViewer(dataTypeCombo);
    }
}

