/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.ui.wizards;

import java.util.Map;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.enablement.oda.xml.ui.utils.XMLRelationInfoUtil;

public class XMLInformationHolder {
    private static Properties prop;
    private static String EMPTY_STRING;

    static {
        EMPTY_STRING = "";
    }

    public static void saveProperties(Properties newProp) {
        if (prop == null) {
            prop = new Properties();
        }
        prop.putAll((Map<?, ?>)newProp);
    }

    public static Properties getProperties() {
        return prop;
    }

    public static String getPropertyValue(String key) {
        if (prop == null) {
            return null;
        }
        return prop.getProperty(key);
    }

    public static void setPropertyValue(String key, String value) {
        if (prop == null) {
            prop = new Properties();
        }
        if (value != null) {
            prop.setProperty(key, value);
        }
    }

    public static void start(DataSetDesign dataSetDesign) {
        if (dataSetDesign == null) {
            return;
        }
        String queryText = dataSetDesign.getQueryText();
        if (queryText != null && queryText.trim().length() > 0) {
            XMLInformationHolder.setPropertyValue("RELATIONINFORMATION", queryText);
            String tableName = XMLRelationInfoUtil.getTableName(queryText);
            XMLInformationHolder.setPropertyValue("TABLENAME", tableName);
            String xpath = XMLRelationInfoUtil.getXPathExpression(queryText, tableName);
            XMLInformationHolder.setPropertyValue("XPATHTEXT", xpath);
        }
        if (dataSetDesign.getPrivateProperties() != null) {
            String xmlFile = dataSetDesign.getPrivateProperties().getProperty("XML_FILE");
            XMLInformationHolder.setPropertyValue("XML_FILE", xmlFile == null ? EMPTY_STRING : xmlFile);
            String xmlEncoding = dataSetDesign.getPrivateProperties().getProperty("XML_ENCODING");
            XMLInformationHolder.setPropertyValue("XML_ENCODING", xmlEncoding == null ? EMPTY_STRING : xmlEncoding);
            String maxRow = dataSetDesign.getPrivateProperties().getProperty("MAX_ROW");
            XMLInformationHolder.setPropertyValue("MAX_ROW", maxRow != null ? maxRow : "-1");
        }
        if (dataSetDesign.getDataSourceDesign() != null) {
            DataSourceDesign dataSourceDesign = dataSetDesign.getDataSourceDesign();
            Properties dataSourceProp = null;
            try {
                dataSourceProp = DesignSessionUtil.getEffectiveDataSourceProperties((DataSourceDesign)dataSourceDesign);
            }
            catch (OdaException e) {
                dataSourceProp = new Properties();
            }
            String schema = dataSourceProp.getProperty("SCHEMAFILELIST", EMPTY_STRING);
            XMLInformationHolder.setPropertyValue("SCHEMAFILELIST", schema);
            String xmlFile = dataSourceProp.getProperty("FILELIST", EMPTY_STRING);
            XMLInformationHolder.setPropertyValue("FILELIST", xmlFile);
            String xmlEncoding = dataSourceProp.getProperty("ENCODINGLIST", EMPTY_STRING);
            XMLInformationHolder.setPropertyValue("ENCODINGLIST", xmlEncoding);
        }
    }

    public static void destory() {
        prop = null;
    }

    public static boolean hasDestroyed() {
        return prop == null;
    }
}

