/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.internal.core.CoreMessages;

public class FileUtils {
    public static boolean resourceExists(String string) {
        if (string == null || "".equals(string)) {
            return false;
        }
        boolean bl = false;
        try {
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            Path path = new Path(string);
            bl = iWorkspaceRoot.exists((IPath)path);
        }
        catch (Exception exception) {}
        return bl;
    }

    public static String getContents(File file) throws IOException {
        StringBuffer stringBuffer;
        block19: {
            stringBuffer = new StringBuffer();
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string);
                    stringBuffer.append(System.getProperty("line.separator"));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                break block19;
            }
            catch (IOException iOException) {
                try {
                    iOException.printStackTrace();
                    break block19;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return stringBuffer.toString();
    }

    public static void setContents(File file, String string) throws FileNotFoundException, IOException {
        if (file == null) {
            throw new IllegalArgumentException(CoreMessages.getString("FileUtils_2"));
        }
        if (!file.exists()) {
            throw new FileNotFoundException(String.valueOf(CoreMessages.getString("FileUtils_3")) + file);
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException(String.valueOf(CoreMessages.getString("FileUtils_4")) + file);
        }
        if (!file.canWrite()) {
            throw new IllegalArgumentException(String.valueOf(CoreMessages.getString("FileUtils_5")) + file);
        }
        Writer writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(string);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static boolean checkIfEqualFilePaths(String string, String string2) {
        Path path = new Path(string.toLowerCase());
        Path path2 = new Path(string2.toLowerCase());
        if (path.segmentCount() != path2.segmentCount()) {
            return false;
        }
        if (path.getDevice() == null && path2.getDevice() != null || path.getDevice() != null && path2.getDevice() == null) {
            return false;
        }
        if (path.getDevice() != null && !path.getDevice().toLowerCase().equals(path2.getDevice().toLowerCase())) {
            return false;
        }
        int n = 0;
        while (n < path.segmentCount()) {
            if (!path.segment(n).equals(path2.segment(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean checkIfContainerOfFile(String string, String string2) {
        Path path = new Path(string.toLowerCase());
        Path path2 = new Path(string2.toLowerCase());
        if (path.segmentCount() > path2.segmentCount()) {
            return false;
        }
        if (path.getDevice() == null && path2.getDevice() != null || path.getDevice() != null && path2.getDevice() == null) {
            return false;
        }
        if (path.getDevice() != null && !path.getDevice().toLowerCase().equals(path2.getDevice().toLowerCase())) {
            return false;
        }
        int n = 0;
        while (n < path.segmentCount()) {
            if (!path.segment(n).equals(path2.segment(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

