/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.presentation;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.php.internal.core.containers.LocalFileStorage;
import org.eclipse.php.internal.core.containers.ZipEntryStorage;
import org.eclipse.php.internal.core.filesystem.FileStoreFactory;
import org.eclipse.php.internal.debug.core.model.PHPConditionalBreakpoint;
import org.eclipse.php.internal.debug.core.model.PHPLineBreakpoint;
import org.eclipse.php.internal.debug.core.sourcelookup.PHPSourceNotFoundInput;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.PHPStackFrame;
import org.eclipse.php.internal.debug.core.zend.model.PHPThread;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.internal.debug.ui.breakpoint.PHPBreakpointImageDescriptor;
import org.eclipse.php.internal.debug.ui.sourcelookup.PHPSourceNotFoundEditorInput;
import org.eclipse.php.internal.ui.containers.LocalFileStorageEditorInput;
import org.eclipse.php.internal.ui.containers.ZipEntryStorageEditorInput;
import org.eclipse.php.internal.ui.editor.input.NonExistingPHPFileEditorInput;
import org.eclipse.php.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class PHPModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    protected static final String UNTITLED_FOLDER_PATH = "Untitled_Documents";
    private ImageDescriptorRegistry fDebugImageRegistry;

    public void setAttribute(String string, Object object) {
    }

    public Image getImage(Object object) {
        if (object instanceof PHPConditionalBreakpoint) {
            return this.getBreakpointImage((PHPConditionalBreakpoint)object);
        }
        return null;
    }

    private Image getBreakpointImage(PHPConditionalBreakpoint pHPConditionalBreakpoint) {
        try {
            if (pHPConditionalBreakpoint.isConditionEnabled()) {
                PHPBreakpointImageDescriptor pHPBreakpointImageDescriptor = pHPConditionalBreakpoint.isEnabled() ? new PHPBreakpointImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT"), 96) : new PHPBreakpointImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT_DISABLED"), 64);
                return this.getDebugImageRegistry().get((ImageDescriptor)pHPBreakpointImageDescriptor);
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        return null;
    }

    protected ImageDescriptorRegistry getDebugImageRegistry() {
        if (this.fDebugImageRegistry == null) {
            this.fDebugImageRegistry = PHPDebugUIPlugin.getImageDescriptorRegistry();
        }
        return this.fDebugImageRegistry;
    }

    public String getText(Object object) {
        if (object instanceof PHPDebugTarget) {
            return this.getTargetText((PHPDebugTarget)object);
        }
        if (object instanceof PHPThread) {
            return this.getThreadText((PHPThread)object);
        }
        if (object instanceof PHPStackFrame) {
            return this.getStackFrameText((PHPStackFrame)object);
        }
        if (object instanceof PHPLineBreakpoint) {
            PHPLineBreakpoint pHPLineBreakpoint = (PHPLineBreakpoint)object;
            IMarker iMarker = pHPLineBreakpoint.getMarker();
            IResource iResource = iMarker.getResource();
            if (iResource instanceof IFile) {
                return null;
            }
            if (iResource instanceof IWorkspaceRoot) {
                try {
                    String string = (String)iMarker.getAttribute("org.eclipse.php.debug.core.Storage_File");
                    Integer n = (Integer)iMarker.getAttribute("lineNumber");
                    return String.valueOf(string) + " [line: " + n.toString() + "]";
                }
                catch (CoreException coreException) {
                    Logger.logException("Unexpected error in PHPModelPresentation", coreException);
                }
            }
        }
        return null;
    }

    private String getTargetText(PHPDebugTarget pHPDebugTarget) {
        String string = "";
        if (pHPDebugTarget.isTerminated()) {
            string = MessageFormat.format(PHPDebugUIMessages.MPresentation_Terminated_1, new Object[0]);
        }
        return String.valueOf(string) + PHPDebugUIMessages.MPresentation_PHP_APP_1;
    }

    private String getThreadText(PHPThread pHPThread) {
        PHPDebugTarget pHPDebugTarget = (PHPDebugTarget)pHPThread.getDebugTarget();
        String string = "";
        try {
            string = pHPDebugTarget.getName();
        }
        catch (DebugException debugException) {
            Logger.logException("PHPModelPresentation error getting target name", debugException);
        }
        if (pHPThread.isStepping()) {
            string = String.valueOf(string) + PHPDebugUIMessages.MPresentation_Stepping_1;
        } else if (pHPThread.isSuspended()) {
            IBreakpoint[] iBreakpointArray = pHPThread.getBreakpoints();
            if (iBreakpointArray.length == 0) {
                string = String.valueOf(string) + PHPDebugUIMessages.MPresentation_Suspended_1;
            } else {
                IBreakpoint iBreakpoint = iBreakpointArray[0];
                if (iBreakpoint instanceof PHPLineBreakpoint) {
                    string = String.valueOf(string) + PHPDebugUIMessages.MPresentation_SLineBreakpoint_1;
                }
            }
        } else if (pHPThread.isTerminated()) {
            string = String.valueOf(PHPDebugUIMessages.MPresentation_Terminated_1) + string;
        }
        return string;
    }

    private String getStackFrameText(PHPStackFrame pHPStackFrame) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            String string = pHPStackFrame.getName();
            if (string != null && string.length() > 0) {
                stringBuffer.append(pHPStackFrame.getName());
                stringBuffer.append("() ");
            }
            stringBuffer.append(pHPStackFrame.getSourceName());
            stringBuffer.append(String.valueOf(PHPDebugUIMessages.MPresentation_ATLine_1) + pHPStackFrame.getLineNumber());
            return stringBuffer.toString();
        }
        catch (DebugException debugException) {
            Logger.logException("Unexpected error in PHPModelPresentation", debugException);
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer("NPE in getStackFrameText(). Frame = ");
            stringBuffer.append(pHPStackFrame);
            if (pHPStackFrame != null) {
                stringBuffer.append(", Thread = ");
                stringBuffer.append(pHPStackFrame.getThread());
            }
            Logger.logException(stringBuffer.toString(), nullPointerException);
        }
        return "";
    }

    public void computeDetail(IValue iValue, IValueDetailListener iValueDetailListener) {
        String string = "";
        try {
            string = iValue.getValueString();
        }
        catch (DebugException debugException) {}
        iValueDetailListener.detailComputed(iValue, string);
    }

    public IEditorInput getEditorInput(Object object) {
        Object object2;
        if (object instanceof IFile) {
            return new FileEditorInput((IFile)object);
        }
        if (object instanceof PHPLineBreakpoint) {
            object2 = (PHPLineBreakpoint)object;
            IMarker iMarker = object2.getMarker();
            IResource iResource = iMarker.getResource();
            if (iResource instanceof IFile) {
                return new FileEditorInput((IFile)iResource);
            }
            if (iResource instanceof IWorkspaceRoot) {
                try {
                    String string = (String)iMarker.getAttribute("org.eclipse.php.debug.core.Storage_File");
                    String string2 = (String)iMarker.getAttribute("org.eclipse.php.debug.core.Storage_Type");
                    if ("org.eclipse.php.debug.core.Include".equals(string2)) {
                        String string3 = iMarker.getAttribute("org.eclipse.php.debug.core.Project", "");
                        IProject iProject = PHPDebugUIPlugin.getProject(string3);
                        String string4 = iMarker.getAttribute("org.eclipse.php.debug.core.Include_Path_Basedir", "");
                        string = iMarker.getAttribute("org.eclipse.wst.sse.ui.extensions.breakpoint.path", string);
                        File file = new File(string);
                        LocalFileStorage localFileStorage = new LocalFileStorage(file);
                        localFileStorage.setProject(iProject);
                        localFileStorage.setIncBaseDirName(string4);
                        return new LocalFileStorageEditorInput(localFileStorage);
                    }
                    if ("org.eclipse.php.debug.core.External".equals(string2) || "org.eclipse.php.debug.core.Remote".equals(string2)) {
                        File file = new File(string);
                        return new FileStoreEditorInput(FileStoreFactory.createFileStore((File)file));
                    }
                }
                catch (CoreException coreException) {
                    Logger.logException("Unexpected error in PHPModelPresentation", coreException);
                }
            }
        }
        if (object instanceof ZipEntryStorage) {
            return new ZipEntryStorageEditorInput((ZipEntryStorage)object);
        }
        if (object instanceof LocalFileStorage) {
            return new LocalFileStorageEditorInput((LocalFileStorage)object);
        }
        if (object instanceof PHPSourceNotFoundInput) {
            return new PHPSourceNotFoundEditorInput((PHPSourceNotFoundInput)object);
        }
        if (object instanceof IFileStore) {
            if (this.isUntitled(object)) {
                object2 = ((IFileStore)object).toString();
                return new NonExistingPHPFileEditorInput((IPath)new Path((String)object2));
            }
            return new FileStoreEditorInput((IFileStore)object);
        }
        Logger.log(202, "Unknown editor input type: " + object.getClass().getName());
        return null;
    }

    public String getEditorId(IEditorInput iEditorInput, Object object) {
        if (this.isUntitled(object)) {
            return "org.eclipse.php.untitledPhpEditor";
        }
        if (iEditorInput instanceof PHPSourceNotFoundEditorInput) {
            return "org.eclipse.php.debug.SourceNotFoundEditor";
        }
        if (object instanceof IFile || object instanceof ILineBreakpoint || object instanceof ZipEntryStorage || object instanceof LocalFileStorage || object instanceof LocalFile) {
            return "org.eclipse.php.editor";
        }
        return null;
    }

    protected boolean isUntitled(Object object) {
        IFileStore iFileStore;
        IFileStore iFileStore2;
        return object instanceof IFileStore && (iFileStore2 = (iFileStore = (IFileStore)object).getParent()) != null && UNTITLED_FOLDER_PATH.equals(iFileStore2.getName());
    }
}

