/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.model;

import java.util.Collections;
import java.util.List;
import org.eclipse.ant.internal.ui.AntUtil;
import org.eclipse.ant.internal.ui.model.AntModelMessages;
import org.eclipse.ant.internal.ui.model.AntModelProject;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.ant.internal.ui.model.AntTargetNode;
import org.eclipse.ant.internal.ui.model.IAntModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;

public class AntProjectNodeProxy
extends AntProjectNode {
    private String fBuildFileName;
    private String fDefaultTargetName;
    private boolean fParsed = false;

    public AntProjectNodeProxy(String name, String buildFileName) {
        super(null, null);
        this.fName = name;
        this.fBuildFileName = buildFileName;
    }

    public AntProjectNodeProxy(String buildFileName) {
        this(null, buildFileName);
    }

    public void parseBuildFile(boolean force) {
        if (this.fParsed && !force) {
            return;
        }
        this.fChildNodes = null;
        this.fParsed = true;
        AntTargetNode[] nodes = null;
        IPath buildFilePath = AntUtil.getFile(this.getBuildFileName()).getLocation();
        if (buildFilePath == null) {
            this.setProblemSeverity(1);
            this.setProblemMessage(AntModelMessages.AntProjectNodeProxy_0);
            return;
        }
        nodes = AntUtil.getTargets(buildFilePath.toString());
        if (nodes == null || nodes.length < 1) {
            this.setProblemSeverity(1);
            this.setProblemMessage(AntModelMessages.AntProjectNodeProxy_1);
            return;
        }
        AntProjectNode projectNode = nodes[0].getProjectNode();
        if (nodes[0].getTargetName().length() != 0) {
            int i = 0;
            while (i < nodes.length) {
                this.addChildNode(nodes[i]);
                ++i;
            }
        }
        this.fModel = projectNode.getAntModel();
        this.fProject = (AntModelProject)projectNode.getProject();
        this.fLabel = null;
        this.fName = null;
    }

    public void parseBuildFile() {
        this.parseBuildFile(false);
    }

    public String getDescription() {
        if (this.fProject != null) {
            return super.getDescription();
        }
        return null;
    }

    public String getLabel() {
        if (this.fName != null) {
            return this.fName;
        }
        if (this.fProject == null) {
            this.parseBuildFile();
        }
        StringBuffer name = new StringBuffer(super.getLabel());
        AntProjectNode realNode = this.getRealNode();
        if (realNode != null && realNode.getProblemMessage() != null) {
            name.append(" <");
            name.append(this.getRealNode().getProblemMessage());
            name.append('>');
        }
        this.fName = name.toString();
        return this.fName;
    }

    public List getChildNodes() {
        List children;
        if (this.fProject == null) {
            this.parseBuildFile();
        }
        if ((children = super.getChildNodes()) == null) {
            return Collections.EMPTY_LIST;
        }
        return children;
    }

    public String getBuildFileName() {
        return this.fBuildFileName;
    }

    public void setDefaultTargetName(String defaultTarget) {
        this.fDefaultTargetName = defaultTarget;
    }

    public String getDefaultTargetName() {
        if (this.fProject == null) {
            return this.fDefaultTargetName;
        }
        return super.getDefaultTargetName();
    }

    public boolean hasChildren() {
        return true;
    }

    public void dispose() {
        if (this.fProject != null) {
            super.dispose();
        }
    }

    public boolean isErrorNode() {
        if (this.fProject == null) {
            return super.isErrorNode();
        }
        return this.getRealNode().isErrorNode();
    }

    public String getProblemMessage() {
        if (this.isErrorNode()) {
            return this.getBuildFileName();
        }
        return null;
    }

    public boolean isWarningNode() {
        if (this.fProject == null) {
            return super.isWarningNode();
        }
        return this.getRealNode().isWarningNode();
    }

    private AntProjectNode getRealNode() {
        if (this.fModel != null) {
            return this.fModel.getProjectNode();
        }
        return null;
    }

    protected IAntModel getAntModel() {
        if (this.fProject == null) {
            this.parseBuildFile();
        }
        return super.getAntModel();
    }

    public int getLength() {
        AntProjectNode realNode;
        if (this.fProject == null) {
            this.parseBuildFile();
        }
        if ((realNode = this.getRealNode()) == null) {
            return -1;
        }
        return realNode.getLength();
    }

    public int getOffset() {
        AntProjectNode realNode;
        if (this.fProject == null) {
            this.parseBuildFile();
        }
        if ((realNode = this.getRealNode()) == null) {
            return -1;
        }
        return realNode.getOffset();
    }

    public int getSelectionLength() {
        AntProjectNode realNode;
        if (this.fProject == null) {
            this.parseBuildFile();
        }
        if ((realNode = this.getRealNode()) == null) {
            return -1;
        }
        return realNode.getSelectionLength();
    }

    public IFile getBuildFileResource() {
        if (this.fProject == null && this.fBuildFileName != null) {
            return AntUtil.getFile(this.fBuildFileName);
        }
        return super.getBuildFileResource();
    }

    public String toString() {
        return this.getLabel();
    }
}

