/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.core.zend.debugger.ProcessCrashDetector;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPExecutableDebuggerInitializer {
    protected ILaunch launch;

    public PHPExecutableDebuggerInitializer(ILaunch iLaunch) throws IOException {
        this.launch = iLaunch;
    }

    public void initializeDebug(String string, String string2, String string3, String string4) {
        this.initializeDebug(string, string2, string3, string4, null, null);
    }

    public void initializeDebug(String string, String string2, String string3, String string4, Map<String, String> map, String string5) {
        try {
            String[] stringArray;
            File file = new File(string);
            String string6 = file.getParent();
            if (string5 != null && !string5.equals("")) {
                string6 = new File(string5).getParent();
            }
            String string7 = null;
            PHPexeItem[] pHPexeItemArray = PHPexes.getInstance().getAllItems();
            Object[] objectArray = pHPexeItemArray;
            int n = pHPexeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                stringArray = objectArray[n2];
                if (stringArray.getExecutable().equals(file)) {
                    string7 = stringArray.getSapiType();
                    break;
                }
                ++n2;
            }
            stringArray = PHPLaunchUtilities.getProgramArguments(this.launch.getLaunchConfiguration());
            Map<String, String> map2 = PHPLaunchUtilities.getPHPCGILaunchEnvironment(string2, string4, string6, file.getParent(), (String[])(string7 == "CGI" ? stringArray : null));
            if (map == null) {
                map = map2;
            } else {
                map2.putAll(map);
                map = map2;
            }
            String[] stringArray2 = PHPLaunchUtilities.getEnvironment(this.launch.getLaunchConfiguration(), this.asAttributesArray(map));
            objectArray = PHPLaunchUtilities.getCommandLine(this.launch.getLaunchConfiguration(), string, string6, string2, (String[])(string7 == "CLI" ? stringArray : null));
            PHPexes.changePermissions(new File((String)objectArray[0]));
            File file2 = new File(string3);
            Process process = file2.exists() ? Runtime.getRuntime().exec((String[])objectArray, stringArray2, file2) : Runtime.getRuntime().exec((String[])objectArray, stringArray2);
            new Thread(new ProcessCrashDetector(process)).start();
            ProcessOutputReader processOutputReader = new ProcessOutputReader(process);
            new Thread(processOutputReader).start();
        }
        catch (Exception exception) {
            final Display display = Display.getDefault();
            display.asyncExec(new Runnable(){

                public void run() {
                    String string = exception.getLocalizedMessage();
                    if (string != null) {
                        string = string.replaceFirst(String.valueOf(exception.getClass().getName()) + ": ", "");
                        MessageDialog.openError((Shell)display.getActiveShell(), (String)"Error", (String)NLS.bind((String)"Error running PHP executable:\n\n{0}", (Object)string));
                    }
                }
            });
            DebugPlugin.log((Throwable)exception);
        }
    }

    private String[] asAttributesArray(Map<String, String> map) {
        String[] stringArray = new String[map.size()];
        int n = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringArray[n++] = String.valueOf(entry.getKey()) + '=' + entry.getValue();
        }
        return stringArray;
    }

    private class ProcessOutputReader
    implements Runnable {
        Process p;

        ProcessOutputReader(Process process) {
            this.p = process;
        }

        public void run() {
            Object object;
            try {
                object = new byte[1000];
                InputStream inputStream = this.p.getInputStream();
                int n = inputStream.read((byte[])object);
                while (n > 0) {
                    n = inputStream.read((byte[])object);
                }
                inputStream = this.p.getErrorStream();
                n = inputStream.read((byte[])object);
                while (n != -1) {
                    n = inputStream.read((byte[])object);
                }
            }
            catch (IOException iOException) {
                PHPDebugPlugin.log(iOException);
            }
            if (PHPExecutableDebuggerInitializer.this.launch != null && PHPExecutableDebuggerInitializer.this.launch.getDebugTarget() == null) {
                object = PHPExecutableDebuggerInitializer.this.launch.getLaunchConfiguration().getName();
                boolean bl = "run".equals(PHPExecutableDebuggerInitializer.this.launch.getLaunchMode());
                String string = null;
                string = bl ? MessageFormat.format(PHPDebugCoreMessages.Debugger_Error_Message_3, object) : MessageFormat.format(PHPDebugCoreMessages.Debugger_Error_Message_2, object);
                final String string2 = string;
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.Debugger_Launch_Error, (String)string2);
                        DebugPlugin.getDefault().getLaunchManager().removeLaunch(((ProcessOutputReader)ProcessOutputReader.this).PHPExecutableDebuggerInitializer.this.launch);
                    }
                });
            }
        }
    }
}

