/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.history;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistoryProvider;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.GenericHistoryDropAdapter;
import org.eclipse.team.internal.ui.history.GenericHistoryViewDefaultPage;
import org.eclipse.team.internal.ui.history.LocalHistoryPageSource;
import org.eclipse.team.internal.ui.history.WorkbenchHistoryPageSite;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.team.ui.history.IHistoryPage;
import org.eclipse.team.ui.history.IHistoryPageSource;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageSite;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;

public class GenericHistoryView
extends ViewPart
implements IHistoryView,
IPropertyChangeListener,
IShowInTarget {
    private static final String HISTORY_VIEW_GROUP = "org.eclipse.team.ui.historyView";
    private static final String NAVIGATION_GROUP = "org.eclipse.team.ui.navigation";
    private static final int MAX_NAVIGATION_HISTORY_ENTRIES = 15;
    private PageBook book;
    private Action refreshAction;
    private Action linkWithEditorAction;
    private Action pinAction;
    private NavigationHistoryAction navigateAction;
    private PageContainer defaultPageContainer;
    PageContainer currentPageContainer;
    DropTarget dropTarget;
    GenericHistoryDropAdapter dropAdapter;
    NavigationHistory navigationHistory = new NavigationHistory();
    private Object lastSelectedElement;
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                GenericHistoryView.this.editorActivated((IEditorPart)part);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            if (part == GenericHistoryView.this) {
                GenericHistoryView.this.editorActivated(GenericHistoryView.this.getViewSite().getPage().getActiveEditor());
            }
        }

        public void partOpened(IWorkbenchPart part) {
            if (part == GenericHistoryView.this) {
                GenericHistoryView.this.editorActivated(GenericHistoryView.this.getViewSite().getPage().getActiveEditor());
            }
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }
    };
    private IPartListener2 partListener2 = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }

        public void partHidden(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (ref.getPart(true) == GenericHistoryView.this) {
                GenericHistoryView.this.editorActivated(GenericHistoryView.this.getViewSite().getPage().getActiveEditor());
            }
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }
    };
    private ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structSelection = (IStructuredSelection)selection;
                GenericHistoryView.this.lastSelectedElement = structSelection.getFirstElement();
                if (!GenericHistoryView.this.isLinkingEnabled() || !GenericHistoryView.this.checkIfPageIsVisible()) {
                    return;
                }
                if (GenericHistoryView.this.lastSelectedElement != null) {
                    Object resource;
                    if (GenericHistoryView.this.lastSelectedElement instanceof SyncInfoModelElement) {
                        SyncInfoModelElement syncInfoModelElement = (SyncInfoModelElement)GenericHistoryView.this.lastSelectedElement;
                        resource = syncInfoModelElement.getSyncInfo().getLocal();
                    } else {
                        Object object = GenericHistoryView.this.lastSelectedElement;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        resource = Utils.getAdapter(object, clazz);
                    }
                    if (resource != null) {
                        GenericHistoryView.this.showHistory((IResource)resource);
                    } else {
                        GenericHistoryView.this.showHistory(GenericHistoryView.this.lastSelectedElement);
                    }
                    GenericHistoryView.this.lastSelectedElement = null;
                }
            }
        }
    };
    private boolean linkingEnabled;
    private boolean viewPinned;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static boolean sameSource(IHistoryPageSource source1, IHistoryPageSource source2) {
        return source1 == source2 || source1 != null && source2 != null && source1.equals(source2);
    }

    void refreshGlobalActionHandlers() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.clearGlobalActionHandlers();
        Map newActionHandlers = this.currentPageContainer.getSubBars().getGlobalActionHandlers();
        if (newActionHandlers != null) {
            Set keys = newActionHandlers.entrySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                bars.setGlobalActionHandler((String)entry.getKey(), (IAction)entry.getValue());
            }
        }
        bars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
    }

    public void createPartControl(Composite parent) {
        this.book = new PageBook(parent, 0);
        this.linkingEnabled = TeamUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_generichistory_view_linking");
        this.defaultPageContainer = this.createDefaultPage(this.book);
        this.configureToolbars(this.getViewSite().getActionBars());
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
        this.initDragAndDrop();
        this.showPageRec(this.defaultPageContainer);
        this.getSite().getPage().addPartListener(this.partListener);
        this.getSite().getPage().addPartListener(this.partListener2);
        this.getSite().getPage().addPostSelectionListener(this.selectionListener);
    }

    private void configureToolbars(IActionBars actionBars) {
        this.pinAction = new Action(TeamUIMessages.GenericHistoryView_PinCurrentHistory, TeamUIPlugin.getImageDescriptor("elcl16/pin.gif")){

            public void run() {
                if (this.isChecked()) {
                    GenericHistoryView.this.linkWithEditorAction.setChecked(false);
                    GenericHistoryView.this.setLinkingEnabled(false);
                }
                GenericHistoryView.this.setViewPinned(this.isChecked());
            }
        };
        this.pinAction.setChecked(this.isViewPinned());
        this.pinAction.setToolTipText(TeamUIMessages.GenericHistoryView_0);
        this.refreshAction = new Action(TeamUIMessages.GenericHistoryView_Refresh, TeamUIPlugin.getImageDescriptor("elcl16/refresh.gif")){

            public void run() {
                ((IHistoryPage)GenericHistoryView.this.currentPageContainer.getPage()).refresh();
            }
        };
        this.refreshAction.setToolTipText(TeamUIMessages.GenericHistoryView_RefreshTooltip);
        this.refreshAction.setEnabled(true);
        this.linkWithEditorAction = new Action(TeamUIMessages.GenericHistoryView_LinkWithEditor, TeamUIPlugin.getImageDescriptor("elcl16/synced.gif")){

            public void run() {
                if (this.isChecked()) {
                    GenericHistoryView.this.pinAction.setChecked(false);
                    GenericHistoryView.this.setViewPinned(false);
                }
                GenericHistoryView.this.setLinkingEnabled(GenericHistoryView.this.isViewPinned() ? false : this.isChecked());
            }
        };
        this.linkWithEditorAction.setChecked(this.isLinkingEnabled());
        this.linkWithEditorAction.setToolTipText(TeamUIMessages.GenericHistoryView_LinkWithTooltip);
        this.navigateAction = new NavigationHistoryAction();
        Utils.initAction((IAction)this.navigateAction, "action.previousHistory.");
        IToolBarManager tbm = actionBars.getToolBarManager();
        tbm.add((IContributionItem)new Separator(HISTORY_VIEW_GROUP));
        tbm.appendToGroup(HISTORY_VIEW_GROUP, (IAction)this.refreshAction);
        tbm.appendToGroup(HISTORY_VIEW_GROUP, (IAction)this.linkWithEditorAction);
        tbm.appendToGroup(HISTORY_VIEW_GROUP, (IAction)this.pinAction);
        tbm.add((IContributionItem)new Separator(NAVIGATION_GROUP));
        tbm.appendToGroup(NAVIGATION_GROUP, (IAction)this.navigateAction);
        tbm.update(false);
    }

    boolean isLinkingEnabled() {
        return this.linkingEnabled;
    }

    public void setLinkingEnabled(boolean enabled) {
        this.linkingEnabled = enabled;
        TeamUIPlugin.getPlugin().getPreferenceStore().setValue("pref_generichistory_view_linking", enabled);
        if (enabled) {
            this.editorActivated(this.getSite().getPage().getActiveEditor());
        }
    }

    void setViewPinned(boolean pinned) {
        this.viewPinned = pinned;
    }

    void initDragAndDrop() {
        int ops = 7;
        Transfer[] transfers = new Transfer[]{ResourceTransfer.getInstance(), PluginTransfer.getInstance()};
        this.dropTarget = new DropTarget((Control)this.book, ops);
        this.dropTarget.setTransfer(transfers);
        this.dropAdapter = new GenericHistoryDropAdapter(this);
        this.dropTarget.addDropListener((DropTargetListener)this.dropAdapter);
    }

    public void setFocus() {
        if (this.isLinkingEnabled() && this.lastSelectedElement != null) {
            if (this.lastSelectedElement instanceof IEditorPart) {
                this.editorActivated((IEditorPart)this.lastSelectedElement);
            } else {
                Object resource;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resource = Utils.getAdapter(this.lastSelectedElement, clazz)) != null) {
                    this.showHistoryPageFor((IResource)resource, false, false, null);
                } else {
                    this.showHistoryPageFor(this.lastSelectedElement, false, false, null);
                }
            }
            this.lastSelectedElement = null;
        }
        if (this.currentPageContainer.page instanceof IPage) {
            this.currentPageContainer.page.setFocus();
        }
    }

    protected void showPageRec(PageContainer pageContainer) {
        if (this.currentPageContainer == pageContainer) {
            this.addNavigationHistoryEntry();
            return;
        }
        if (this.currentPageContainer != null) {
            this.currentPageContainer.getSubBars().deactivate();
            ((IHistoryPage)this.currentPageContainer.getPage()).removePropertyChangeListener(this);
            this.currentPageContainer.getPage().dispose();
            this.currentPageContainer.getSubBars().dispose();
        }
        this.currentPageContainer = pageContainer;
        Control pageControl = this.currentPageContainer.getPage().getControl();
        if (pageControl != null && !pageControl.isDisposed()) {
            this.book.showPage(pageControl);
            ((IHistoryPage)this.currentPageContainer.getPage()).addPropertyChangeListener(this);
            this.currentPageContainer.getSubBars().activate();
            this.refreshGlobalActionHandlers();
            this.getViewSite().getActionBars().updateActionBars();
            this.addNavigationHistoryEntry();
        }
    }

    private void addNavigationHistoryEntry() {
        Object input;
        if (this.currentPageContainer != null && (input = ((IHistoryPage)this.currentPageContainer.getPage()).getInput()) != null) {
            this.navigationHistory.addEntry(input, ((IHistoryPage)this.currentPageContainer.getPage()).getName(), this.currentPageContainer.getSource());
        }
    }

    protected PageSite initPage(IPageBookViewPage page) {
        try {
            PageSite site = new PageSite(this.getViewSite());
            page.init((IPageSite)site);
            return site;
        }
        catch (PartInitException e) {
            TeamUIPlugin.log((CoreException)((Object)e));
            return null;
        }
    }

    public IHistoryPage showHistoryFor(Object object, boolean force) {
        return this.showHistoryPageFor(object, true, force, null);
    }

    public IHistoryPage showHistoryPageFor(Object object, boolean refresh, boolean force, IHistoryPageSource pageSource) {
        if (!this.getSite().getPage().isPartVisible((IWorkbenchPart)this)) {
            return null;
        }
        if ((pageSource = this.getPageSourceFor(object, pageSource)) == null || !pageSource.canShowHistoryFor(object)) {
            return null;
        }
        IHistoryPage existingPage = this.checkForExistingPage(object, refresh, force, pageSource);
        if (existingPage != null) {
            return existingPage;
        }
        if (this.isViewPinned() && !force) {
            return this.handlePinnedView(object, refresh, pageSource);
        }
        PageContainer tempPageContainer = null;
        tempPageContainer = this.currentPageContainer != null && this.currentPageContainer.canShow(object, pageSource) ? this.currentPageContainer : this.createPage(pageSource, object);
        IHistoryPage historyPage = (IHistoryPage)tempPageContainer.getPage();
        historyPage.setInput(object);
        ((HistoryPage)historyPage).setHistoryView(this);
        this.setContentDescription(historyPage.getName());
        this.showPageRec(tempPageContainer);
        return historyPage;
    }

    private IHistoryPageSource getPageSourceFor(Object object, IHistoryPageSource pageSource) {
        Class<?> clazz;
        if (object == null || pageSource != null) {
            return pageSource;
        }
        IResource resource = Utils.getResource(object);
        if (resource == null) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.team.ui.history.IHistoryPageSource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IHistoryPageSource)Utils.getAdapter(object, clazz2);
        }
        if (resource.getProject() == null) {
            return null;
        }
        RepositoryProvider teamProvider = RepositoryProvider.getProvider((IProject)resource.getProject());
        if (teamProvider == null) {
            return LocalHistoryPageSource.getInstance();
        }
        IFileHistoryProvider fileHistory = teamProvider.getFileHistoryProvider();
        if (fileHistory != null) {
            IHistoryPageSource source;
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("org.eclipse.team.ui.history.IHistoryPageSource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((source = (IHistoryPageSource)Utils.getAdapter(fileHistory, clazz3, true)) != null) {
                return source;
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.team.ui.history.IHistoryPageSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IHistoryPageSource)Utils.getAdapter(teamProvider, clazz, true);
    }

    private IHistoryPage handlePinnedView(Object object, boolean refresh, IHistoryPageSource source) {
        try {
            GenericHistoryView historyView = this.findUnpinnedHistoryView();
            if (historyView != null) {
                this.getSite().getPage().activate((IWorkbenchPart)historyView);
                return historyView.showHistoryPageFor(object, refresh, true, source);
            }
            String id = "org.eclipse.team.ui.GenericHistoryView" + System.currentTimeMillis();
            IViewPart view = this.getSite().getPage().showView("org.eclipse.team.ui.GenericHistoryView", id, 3);
            this.getSite().getPage().activate((IWorkbenchPart)view);
            if (view instanceof GenericHistoryView) {
                return ((GenericHistoryView)view).showHistoryPageFor(object, refresh, true, source);
            }
        }
        catch (PartInitException partInitException) {}
        return null;
    }

    private IHistoryPage checkForExistingPage(Object object, boolean refresh, boolean thisViewOnly, IHistoryPageSource pageSource) {
        IHistoryPage tempPage = this.checkForExistingPage(object, refresh, pageSource);
        if (tempPage != null || thisViewOnly) {
            return tempPage;
        }
        tempPage = this.searchHistoryViewsForObject(object, refresh, pageSource);
        if (tempPage != null) {
            this.getSite().getPage().bringToTop((IWorkbenchPart)tempPage.getHistoryView());
        }
        return tempPage;
    }

    private IHistoryPage checkForExistingPage(Object object, boolean refresh, IHistoryPageSource pageSource) {
        if (this.currentPageContainer != null && this.currentPageContainer.matches(object, pageSource)) {
            IHistoryPage tempPage = (IHistoryPage)this.currentPageContainer.getPage();
            if (refresh) {
                tempPage.refresh();
            }
            return tempPage;
        }
        return null;
    }

    private IHistoryPage searchHistoryViewsForObject(Object object, boolean refresh, IHistoryPageSource pageSource) {
        IWorkbenchPage page = this.getSite().getPage();
        IViewReference[] historyViews = page.getViewReferences();
        int i = 0;
        while (i < historyViews.length) {
            GenericHistoryView ghv;
            IHistoryPage historyPage;
            IViewPart historyView;
            if (historyViews[i].getId().equals("org.eclipse.team.ui.GenericHistoryView") && (historyView = historyViews[i].getView(true)) instanceof GenericHistoryView && (historyPage = (ghv = (GenericHistoryView)historyView).checkForExistingPage(object, refresh, pageSource)) != null) {
                return historyPage;
            }
            ++i;
        }
        return null;
    }

    public GenericHistoryView findUnpinnedHistoryView() {
        IWorkbenchPage page = this.getSite().getPage();
        IViewReference[] historyViews = page.getViewReferences();
        int i = 0;
        while (i < historyViews.length) {
            IViewPart historyView;
            if (historyViews[i].getId().equals("org.eclipse.team.ui.GenericHistoryView") && !((GenericHistoryView)(historyView = historyViews[i].getView(false))).isViewPinned()) {
                return (GenericHistoryView)historyView;
            }
            ++i;
        }
        return null;
    }

    boolean isViewPinned() {
        return this.viewPinned;
    }

    private PageContainer createPage(IHistoryPageSource source, Object object) {
        Page page = source.createPage(object);
        PageSite site = this.initPage((IPageBookViewPage)page);
        ((IHistoryPage)page).setSite(new WorkbenchHistoryPageSite(this, page.getSite()));
        page.createControl((Composite)this.book);
        PageContainer container = new PageContainer(page, source);
        container.setSubBars((SubActionBars)site.getActionBars());
        return container;
    }

    protected PageContainer createDefaultPage(PageBook book) {
        GenericHistoryViewDefaultPage page = new GenericHistoryViewDefaultPage();
        PageSite site = this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        PageContainer container = new PageContainer(page, null);
        container.setSubBars((SubActionBars)site.getActionBars());
        return container;
    }

    protected void editorActivated(IEditorPart editor) {
        if (editor != null && !this.checkIfPageIsVisible()) {
            this.lastSelectedElement = editor;
        }
        if (editor == null || !this.isLinkingEnabled() || !this.checkIfPageIsVisible() || this.isViewPinned()) {
            return;
        }
        IEditorInput input = editor.getEditorInput();
        IFile file = ResourceUtil.getFile((IEditorInput)input);
        if (file != null) {
            this.showHistory(file);
        } else {
            Object pageSource;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.team.ui.history.IHistoryPageSource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((pageSource = Utils.getAdapter(input, clazz)) != null) {
                this.showHistory(input);
            }
        }
    }

    private boolean checkIfPageIsVisible() {
        return this.getViewSite().getPage().isPartVisible((IWorkbenchPart)this);
    }

    public void dispose() {
        super.dispose();
        if (this.dropTarget != null && !this.dropTarget.isDisposed()) {
            this.dropTarget.removeDropListener((DropTargetListener)this.dropAdapter);
        }
        ((IHistoryPage)this.currentPageContainer.getPage()).removePropertyChangeListener(this);
        this.currentPageContainer.getPage().dispose();
        this.defaultPageContainer.getPage().dispose();
        this.currentPageContainer = null;
        this.defaultPageContainer = null;
        this.getSite().getPage().removePartListener(this.partListener);
        this.getSite().getPage().removePartListener(this.partListener2);
        this.getSite().getPage().removePostSelectionListener(this.selectionListener);
        this.navigateAction.dispose();
    }

    public IHistoryPage showHistoryFor(Object object) {
        return this.showHistoryFor(object, false);
    }

    public IHistoryPage getHistoryPage() {
        if (this.currentPageContainer != null && this.currentPageContainer.getPage() != null) {
            return (IHistoryPage)this.currentPageContainer.getPage();
        }
        return (IHistoryPage)this.defaultPageContainer.getPage();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.currentPageContainer.getPage()) {
            if (event.getProperty().equals("org.eclipse.team.ui.name")) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        IHistoryPage historyPage = (IHistoryPage)GenericHistoryView.this.currentPageContainer.getPage();
                        GenericHistoryView.this.setContentDescription(historyPage.getName());
                        GenericHistoryView.this.navigationHistory.updateName(historyPage, GenericHistoryView.this.currentPageContainer.getSource());
                    }
                });
            } else {
                event.getProperty().equals("org.eclipse.team.ui.description");
            }
        }
    }

    public IHistoryView findAppropriateHistoryViewFor(Object input, IHistoryPageSource pageSource) {
        IHistoryPage page = this.searchHistoryViewsForObject(input, false, pageSource);
        if (page != null) {
            return page.getHistoryView();
        }
        return this.findUnpinnedHistoryView();
    }

    private void showHistory(Object object) {
        if (this.getHistoryPage().getInput() != object) {
            this.showHistoryPageFor(object, false, false, null);
        }
    }

    public boolean show(ShowInContext context) {
        IStructuredSelection ss;
        ISelection selection = context.getSelection();
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && this.showHistoryFor(ss.getFirstElement()) != null) {
            return true;
        }
        if (context.getInput() != null) {
            return this.showHistoryFor(context.getInput()) != null;
        }
        return false;
    }

    abstract class MenuCreator
    implements IMenuCreator {
        private MenuManager menuManager;

        MenuCreator() {
        }

        public void dispose() {
            if (this.menuManager != null) {
                this.menuManager.dispose();
                this.menuManager = null;
            }
        }

        public Menu getMenu(Control parent) {
            Menu fMenu = null;
            if (this.menuManager == null) {
                this.menuManager = new MenuManager();
                fMenu = this.menuManager.createContextMenu(parent);
                IAction[] actions = this.getDropDownActions();
                int i = actions.length - 1;
                while (i >= 0) {
                    IAction action = actions[i];
                    this.menuManager.add(action);
                    --i;
                }
                this.updateMenuState();
            } else {
                fMenu = this.menuManager.getMenu();
            }
            return fMenu;
        }

        protected void updateMenuState() {
            if (this.menuManager != null) {
                this.menuManager.update(true);
            }
        }

        protected abstract IAction[] getDropDownActions();

        public Menu getMenu(Menu parent) {
            return null;
        }

        public void rebuildMenu() {
            if (this.menuManager != null) {
                this.menuManager.dispose();
                this.menuManager = null;
            }
        }
    }

    class NavigationHistory {
        List history = new ArrayList();
        int position;
        private boolean navigating;

        NavigationHistory() {
        }

        public int size() {
            return this.history.size();
        }

        public void gotoPreviousEntry() {
            if (this.position > 0) {
                --this.position;
                this.gotoEntry();
            } else {
                this.position = this.history.size() - 1;
                this.gotoEntry();
            }
        }

        private void gotoEntry() {
            try {
                this.navigating = true;
                NavigationHistoryEntry currentEntry = this.getCurrentEntry();
                GenericHistoryView.this.showHistoryPageFor(currentEntry.object, true, true, currentEntry.source);
            }
            finally {
                this.navigating = false;
            }
        }

        private NavigationHistoryEntry getCurrentEntry() {
            return (NavigationHistoryEntry)this.history.get(this.position);
        }

        public void addEntry(Object object, String name, IHistoryPageSource source) {
            if (!this.navigating) {
                NavigationHistoryEntry navigationHistoryEntry = new NavigationHistoryEntry(object, name, source);
                if (this.history.contains(navigationHistoryEntry)) {
                    this.history.remove(navigationHistoryEntry);
                }
                this.history.add(navigationHistoryEntry);
                if (this.history.size() > 15) {
                    this.history.remove(0);
                }
                this.position = this.history.size() - 1;
            }
            GenericHistoryView.this.navigateAction.update();
        }

        public NavigationHistoryEntry[] getEntries() {
            return this.history.toArray(new NavigationHistoryEntry[this.history.size()]);
        }

        private NavigationHistoryEntry getEntry(int i) {
            return (NavigationHistoryEntry)this.history.get(i);
        }

        public void gotoEntry(NavigationHistoryEntry navigationHistoryEntry) {
            this.position = this.history.indexOf(navigationHistoryEntry);
            this.gotoEntry();
        }

        public NavigationHistoryEntry getPreviousEntry() {
            int next = this.position - 1;
            if (next < 0) {
                next = this.size() - 1;
            }
            return this.getEntry(next);
        }

        public void updateName(IHistoryPage historyPage, IHistoryPageSource pageSource) {
            NavigationHistoryEntry[] historyEntries = this.getEntries();
            int i = 0;
            while (i < historyEntries.length) {
                NavigationHistoryEntry historyEntry = historyEntries[i];
                if (historyEntry.matches(historyPage, pageSource)) {
                    historyEntry.name = historyPage.getName();
                }
                ++i;
            }
            GenericHistoryView.this.navigateAction.update();
        }
    }

    class NavigationHistoryAction
    extends Action {
        private MenuCreator menuCreator;
        private IAction[] actions;

        public NavigationHistoryAction() {
            this.menuCreator = new MenuCreator(this, GenericHistoryView.this){
                final /* synthetic */ NavigationHistoryAction this$1;
                {
                    this.this$1 = navigationHistoryAction;
                }

                protected IAction[] getDropDownActions() {
                    return NavigationHistoryAction.access$0(this.this$1);
                }
            };
            this.setMenuCreator(this.menuCreator);
            this.update();
        }

        private IAction[] createActions() {
            NavigationHistoryEntry[] entries = this.getDropDownEntries();
            ArrayList<NavigationHistoryEntryAction> actions = new ArrayList<NavigationHistoryEntryAction>();
            int i = 0;
            while (i < entries.length) {
                NavigationHistoryEntry navigationHistoryEntry = entries[i];
                actions.add(new NavigationHistoryEntryAction(navigationHistoryEntry));
                ++i;
            }
            return actions.toArray(new IAction[actions.size()]);
        }

        protected NavigationHistoryEntry[] getDropDownEntries() {
            return GenericHistoryView.this.navigationHistory.getEntries();
        }

        public void run() {
            GenericHistoryView.this.navigationHistory.gotoPreviousEntry();
            this.updateCheckState();
        }

        public void update() {
            this.setEnabled(GenericHistoryView.this.navigationHistory.size() > 1);
            if (this.isEnabled()) {
                this.setToolTipText(NLS.bind((String)TeamUIMessages.GenericHistoryView_1, (Object)GenericHistoryView.this.navigationHistory.getPreviousEntry().name));
            } else {
                this.setToolTipText(TeamUIMessages.GenericHistoryView_2);
            }
            this.actions = null;
            this.menuCreator.rebuildMenu();
            this.updateCheckState();
        }

        private void updateCheckState() {
            IAction[] actions = this.getActions();
            int i = 0;
            while (i < actions.length) {
                IAction action = actions[i];
                if (action instanceof NavigationHistoryEntryAction) {
                    NavigationHistoryEntryAction a = (NavigationHistoryEntryAction)action;
                    a.update();
                }
                ++i;
            }
            this.menuCreator.updateMenuState();
        }

        public void dispose() {
            this.menuCreator.dispose();
        }

        private IAction[] getActions() {
            if (this.actions == null) {
                this.actions = this.createActions();
            }
            return this.actions;
        }

        static /* synthetic */ IAction[] access$0(NavigationHistoryAction navigationHistoryAction) {
            return navigationHistoryAction.getActions();
        }
    }

    static class NavigationHistoryEntry {
        Object object;
        String name;
        IHistoryPageSource source;

        public NavigationHistoryEntry(Object object, String name, IHistoryPageSource source) {
            this.object = object;
            this.name = name;
            this.source = source;
        }

        public boolean equals(Object obj) {
            if (obj instanceof NavigationHistoryEntry) {
                NavigationHistoryEntry other = (NavigationHistoryEntry)obj;
                return other.object.equals(this.object) && GenericHistoryView.sameSource(this.source, other.source);
            }
            return false;
        }

        public boolean matches(IHistoryPage historyPage, IHistoryPageSource pageSource) {
            return this.object.equals(historyPage.getInput()) && GenericHistoryView.sameSource(this.source, pageSource);
        }

        public int hashCode() {
            return this.object.hashCode();
        }
    }

    class NavigationHistoryEntryAction
    extends Action {
        private final NavigationHistoryEntry navigationHistoryEntry;

        public NavigationHistoryEntryAction(NavigationHistoryEntry navigationHistoryEntry) {
            super(navigationHistoryEntry.name);
            this.navigationHistoryEntry = navigationHistoryEntry;
        }

        public void run() {
            GenericHistoryView.this.navigationHistory.gotoEntry(this.navigationHistoryEntry);
            GenericHistoryView.this.navigateAction.updateCheckState();
        }

        public void update() {
            this.setChecked(GenericHistoryView.this.navigationHistory.getCurrentEntry() == this.navigationHistoryEntry);
        }
    }

    class PageContainer {
        private Page page;
        private SubActionBars subBars;
        private final IHistoryPageSource source;

        public PageContainer(Page page, IHistoryPageSource source) {
            this.page = page;
            this.source = source;
        }

        public Page getPage() {
            return this.page;
        }

        public void setPage(Page page) {
            this.page = page;
        }

        public SubActionBars getSubBars() {
            return this.subBars;
        }

        public void setSubBars(SubActionBars subBars) {
            this.subBars = subBars;
        }

        public IHistoryPageSource getSource() {
            return this.source;
        }

        public boolean matches(Object object, IHistoryPageSource pageSource) {
            Object input;
            if (this.page instanceof IHistoryPage && (input = ((IHistoryPage)this.page).getInput()) != null) {
                return input.equals(object) && GenericHistoryView.sameSource(GenericHistoryView.this.getPageSourceFor(object, pageSource), GenericHistoryView.this.getPageSourceFor(input, this.source));
            }
            return false;
        }

        public boolean canShow(Object object, IHistoryPageSource pageSource) {
            if (this.page instanceof IHistoryPage && GenericHistoryView.sameSource(GenericHistoryView.this.getPageSourceFor(object, pageSource), GenericHistoryView.this.getPageSourceFor(((IHistoryPage)this.page).getInput(), this.source))) {
                return ((IHistoryPage)this.page).isValidInput(object);
            }
            return false;
        }
    }
}

