/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core;

import java.beans.PropertyChangeListener;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.core.util.preferences.IXMLPreferencesStorable;
import org.eclipse.php.internal.server.core.Logger;
import org.eclipse.php.internal.server.core.ServerHelper;

public class Server
implements IXMLPreferencesStorable {
    public static final String SERVER_ELEMENT = "server";
    public static final String NAME = "name";
    public static final String BASE_URL = "base_url";
    public static final String DOCUMENT_ROOT = "document_root";
    public static final String PORT = "port";
    public static final String HOSTNAME = "hostname";
    public static final String FILE_NAME = "file_name";
    private static final int DEFAULT_HTTP_PORT = 80;
    private ServerHelper helper = new ServerHelper(this);

    public Server() {
    }

    public Server(String string, String string2, String string3, String string4) {
        this();
        this.setName(string);
        this.setHost(string2);
        this.setBaseURL(string3);
        this.setDocumentRoot(string4);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.helper.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.helper.removePropertyChangeListener(propertyChangeListener);
    }

    public void setAttribute(String string, String string2) {
        this.helper.setAttribute(string, string2);
    }

    public String getAttribute(String string, String string2) {
        return this.helper.getAttribute(string, string2);
    }

    public void removeAttribute(String string) {
        this.helper.removeAttribute(string);
    }

    public String getContextRoot(IProject iProject) {
        PHPProjectOptions pHPProjectOptions = PHPProjectOptions.forProject((IProject)iProject);
        String string = (String)pHPProjectOptions.getOption("org.eclipse.php.core.contextRoot");
        if (string == null || string.equals("")) {
            string = iProject.getFullPath().toString();
        }
        return string;
    }

    public String getName() {
        return this.getAttribute(NAME, "");
    }

    public void setName(String string) {
        this.setAttribute(NAME, string);
    }

    public String getBaseURL() {
        return this.getAttribute(BASE_URL, "");
    }

    public void setBaseURL(String string) {
        this.setAttribute(BASE_URL, string);
    }

    public String getHost() {
        return this.getAttribute(HOSTNAME, "localhost");
    }

    public void setHost(String string) {
        this.setAttribute(HOSTNAME, string);
    }

    public void setDocumentRoot(String string) {
        this.setAttribute(DOCUMENT_ROOT, string);
    }

    public String getDocumentRoot() {
        return this.getAttribute(DOCUMENT_ROOT, "");
    }

    public URL getRootURL() {
        try {
            String string = this.getPortString();
            String string2 = this.getBaseURL();
            if (string2.equals("")) {
                string2 = "http://" + this.getHost();
            }
            URL uRL = null;
            uRL = string.equals("80") ? new URL(String.valueOf(string2) + "/") : new URL(String.valueOf(string2) + ":" + string + "/");
            return uRL;
        }
        catch (Exception exception) {
            Logger.logException("Could not get root URL", exception);
            return null;
        }
    }

    protected static String renderCommandLine(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length < 1) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            stringBuffer.append(string);
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public int getPort() {
        int n = Integer.parseInt(this.getPortString());
        if (n < 0) {
            n = 80;
        }
        return n;
    }

    public String getPortString() {
        return this.getAttribute(PORT, "80");
    }

    public void setPort(String string) {
        try {
            if (string.equals("")) {
                this.setAttribute(PORT, "80");
            } else {
                this.setAttribute(PORT, string);
            }
        }
        catch (Throwable throwable) {}
    }

    public int hashCode() {
        if (this.getName() != null) {
            return this.getName().hashCode();
        }
        return 1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Server)) {
            return false;
        }
        String string = this.getName();
        String string2 = ((Server)object).getName();
        if (string == null && string2 != null) {
            return false;
        }
        return string.equals(string2);
    }

    public String toString() {
        return "Server [" + this.getName() + "::" + this.getHost() + ']';
    }

    public void restoreFromMap(HashMap hashMap) {
        HashMap hashMap2 = (HashMap)hashMap.get(SERVER_ELEMENT);
        for (String string : hashMap2.keySet()) {
            this.setAttribute(string, (String)hashMap2.get(string));
        }
    }

    public HashMap storeToMap() {
        HashMap hashMap = new HashMap(this.helper.map);
        HashMap hashMap2 = new HashMap(1);
        hashMap2.put(SERVER_ELEMENT, hashMap);
        return hashMap2;
    }

    public boolean isLocal() {
        try {
            String string = this.getHost();
            if (string != null) {
                InetAddress inetAddress = InetAddress.getByName(string);
                return inetAddress.isLoopbackAddress() || inetAddress.isSiteLocalAddress();
            }
        }
        catch (Exception exception) {}
        return false;
    }
}

