/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.editor.PHPResourceMarkerAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.editors.text.StorageDocumentProvider;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.encoding.CodedReaderCreator;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.util.Utilities;
import org.eclipse.wst.sse.ui.internal.IModelProvider;
import org.eclipse.wst.sse.ui.internal.debug.BreakpointRulerAction;
import org.eclipse.wst.sse.ui.internal.editor.EditorModelUtil;
import org.eclipse.wst.sse.ui.internal.extension.BreakpointProviderBuilder;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.breakpoint.IExtendedStorageEditorInput;

public class LocalStorageModelProvider
extends StorageDocumentProvider
implements IModelProvider {
    private static LocalStorageModelProvider fInstance = null;
    private IElementStateListener fInternalListener;
    private Map fModelInfoMap = new HashMap();
    private boolean fReuseModelDocument = true;

    public static synchronized LocalStorageModelProvider getInstance() {
        if (fInstance == null) {
            fInstance = new LocalStorageModelProvider();
        }
        return fInstance;
    }

    private LocalStorageModelProvider() {
        this.fInternalListener = new InternalElementStateListener();
    }

    String calculateBaseLocation(IStorageEditorInput iStorageEditorInput) {
        String string = null;
        try {
            try {
                IStorage iStorage = iStorageEditorInput.getStorage();
                if (iStorage != null) {
                    IPath iPath = iStorage.getFullPath();
                    String string2 = iStorage.getName();
                    if (iPath != null) {
                        if (!iPath.lastSegment().equals(string2)) {
                            IPath iPath2 = iPath.addTrailingSeparator();
                            string = iPath2.append(string2).toOSString();
                        } else {
                            string = iPath.makeAbsolute().toOSString();
                        }
                    }
                    if (string == null) {
                        string = string2;
                    }
                }
            }
            catch (CoreException coreException) {
                Logger.logException(coreException);
                if (string == null) {
                    string = iStorageEditorInput.getName();
                }
            }
        }
        finally {
            if (string == null) {
                string = iStorageEditorInput.getName();
            }
        }
        return string;
    }

    String calculateID(IStorageEditorInput iStorageEditorInput) {
        boolean bl;
        String string;
        block14: {
            string = null;
            bl = false;
            try {
                try {
                    IStorage iStorage = iStorageEditorInput.getStorage();
                    if (iStorage != null) {
                        IPath iPath = iStorage.getFullPath();
                        String string2 = iStorage.getName();
                        boolean bl2 = bl = iPath == null || iPath.toOSString().equals(string2);
                        if (iPath != null) {
                            if (!iPath.lastSegment().equals(string2)) {
                                IPath iPath2 = iPath.addTrailingSeparator();
                                string = iPath2.append(string2).toOSString();
                            } else {
                                string = iPath.makeAbsolute().toOSString();
                            }
                        }
                        if (string == null) {
                            string = string2;
                        }
                    }
                }
                catch (CoreException coreException) {
                    Logger.logException(coreException);
                    if (string == null) {
                        string = "";
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (string == null) {
                    string = "";
                }
                throw throwable;
            }
            if (string == null) {
                string = "";
            }
        }
        if (bl) {
            string = String.valueOf(iStorageEditorInput.hashCode()) + string;
        }
        return string;
    }

    protected IAnnotationModel createAnnotationModel(Object object) throws CoreException {
        Object object2 = null;
        if (object instanceof IStorageEditorInput) {
            IStorageEditorInput iStorageEditorInput = (IStorageEditorInput)object;
            String string = this.getModel((IEditorInput)iStorageEditorInput) != null ? this.getModel((IEditorInput)iStorageEditorInput).getContentTypeIdentifier() : null;
            String string2 = BreakpointRulerAction.getFileExtension((IEditorInput)((IEditorInput)object));
            IResource iResource = BreakpointProviderBuilder.getInstance().getResource((IEditorInput)iStorageEditorInput, string, string2);
            String string3 = iStorageEditorInput.getName();
            if (iStorageEditorInput.getStorage() != null && iStorageEditorInput.getStorage().getFullPath() != null) {
                string3 = iStorageEditorInput.getStorage().getFullPath().toOSString();
            }
            object2 = iResource != null ? new PHPResourceMarkerAnnotationModel(iResource, string3) : new AnnotationModel();
        }
        if (object2 == null) {
            object2 = super.createAnnotationModel(object);
        }
        return object2;
    }

    protected IDocument createDocument(Object object) {
        IStructuredDocument iStructuredDocument = null;
        if (object instanceof IEditorInput) {
            ModelInfo modelInfo = this.getModelInfoFor((IEditorInput)object);
            if (modelInfo == null) {
                throw new IllegalArgumentException("no corresponding model info found");
            }
            IStructuredModel iStructuredModel = modelInfo.fStructuredModel;
            if (iStructuredModel != null) {
                block24: {
                    if (!this.fReuseModelDocument && object instanceof IStorageEditorInput) {
                        Reader reader = null;
                        IStructuredDocument iStructuredDocument2 = null;
                        try {
                            CodedReaderCreator codedReaderCreator = new CodedReaderCreator(this.calculateID((IStorageEditorInput)object), Utilities.getMarkSupportedStream((InputStream)((IStorageEditorInput)object).getStorage().getContents()));
                            reader = codedReaderCreator.getCodedReader();
                            iStructuredDocument2 = iStructuredModel.getStructuredDocument();
                            int n = iStructuredDocument2.getLength();
                            StringBuffer stringBuffer = new StringBuffer();
                            int n2 = 2048;
                            char[] cArray = new char[n2];
                            int n3 = 0;
                            boolean bl = false;
                            while (!bl) {
                                n3 = reader.read(cArray, 0, n2);
                                if (n3 == -1) {
                                    bl = true;
                                    continue;
                                }
                                stringBuffer.append(cArray, 0, n3);
                            }
                            iStructuredDocument2.replaceText((Object)this, 0, n, stringBuffer.toString(), true);
                            iStructuredModel.setDirtyState(false);
                        }
                        catch (CoreException coreException) {
                            Logger.logException(coreException);
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (IOException iOException) {
                                    Logger.logException(iOException);
                                }
                            }
                            break block24;
                        }
                        catch (IOException iOException) {
                            try {
                                Logger.logException(iOException);
                                break block24;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (reader != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (IOException iOException2) {
                                        Logger.logException(iOException2);
                                    }
                                }
                            }
                        }
                        if (reader == null) break block24;
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {
                            Logger.logException(iOException);
                        }
                    }
                }
                if (iStructuredDocument == null) {
                    iStructuredDocument = iStructuredModel.getStructuredDocument();
                }
            }
        }
        return iStructuredDocument;
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object object) throws CoreException {
        if (this.getModelInfoFor((IEditorInput)object) == null) {
            this.createModelInfo((IEditorInput)object);
        }
        AbstractDocumentProvider.ElementInfo elementInfo = super.createElementInfo(object);
        return elementInfo;
    }

    public void createModelInfo(IEditorInput iEditorInput) {
        IStructuredModel iStructuredModel;
        if (this.getModelInfoFor(iEditorInput) == null && (iStructuredModel = this.selfCreateModel(iEditorInput)) != null) {
            this.createModelInfo(iEditorInput, iStructuredModel, true);
        }
    }

    public void createModelInfo(IEditorInput iEditorInput, IStructuredModel iStructuredModel, boolean bl) {
        if (this.getModelInfoFor(iEditorInput) != null || this.getModelInfoFor(iStructuredModel) != null) {
            return;
        }
        if (iEditorInput instanceof IExtendedStorageEditorInput) {
            ((IExtendedStorageEditorInput)iEditorInput).addElementStateListener(this.fInternalListener);
        }
        EditorModelUtil.addFactoriesTo((IStructuredModel)iStructuredModel);
        ModelInfo modelInfo = new ModelInfo(iStructuredModel, iEditorInput, bl);
        this.fModelInfoMap.put(iEditorInput, modelInfo);
    }

    protected void disposeElementInfo(Object object, AbstractDocumentProvider.ElementInfo elementInfo) {
        if (object instanceof IEditorInput) {
            IEditorInput iEditorInput = (IEditorInput)object;
            ModelInfo modelInfo = this.getModelInfoFor(iEditorInput);
            this.disposeModelInfo(modelInfo);
        }
        super.disposeElementInfo(object, elementInfo);
    }

    public void disposeModelInfo(ModelInfo modelInfo) {
        if (modelInfo.fElement instanceof IStorageEditorInput) {
            if (modelInfo.fElement instanceof IExtendedStorageEditorInput) {
                ((IExtendedStorageEditorInput)modelInfo.fElement).removeElementStateListener(this.fInternalListener);
            }
            if (modelInfo.fShouldReleaseOnInfoDispose) {
                modelInfo.fStructuredModel.releaseFromEdit();
            }
        }
        this.fModelInfoMap.remove(modelInfo.fElement);
    }

    protected void doResetDocument(Object object, IProgressMonitor iProgressMonitor) throws CoreException {
        this.fReuseModelDocument = false;
        super.doResetDocument(object, iProgressMonitor);
        this.fReuseModelDocument = true;
    }

    protected void doSaveDocument(IProgressMonitor iProgressMonitor, Object object, IDocument iDocument, boolean bl) throws CoreException {
        IDocumentProvider iDocumentProvider = null;
        if (object instanceof IEditorInput) {
            iDocumentProvider = DocumentProviderRegistry.getDefault().getDocumentProvider((IEditorInput)object);
        }
        if (iDocumentProvider == null) {
            iDocumentProvider = new FileDocumentProvider();
        }
        iDocumentProvider.saveDocument(iProgressMonitor, object, iDocument, bl);
    }

    public IStructuredModel getModel(IEditorInput iEditorInput) {
        IStructuredModel iStructuredModel = null;
        ModelInfo modelInfo = this.getModelInfoFor(iEditorInput);
        if (modelInfo != null) {
            iStructuredModel = modelInfo.fStructuredModel;
        }
        return iStructuredModel;
    }

    public IStructuredModel getModel(Object object) {
        if (object instanceof IEditorInput) {
            return this.getModel((IEditorInput)object);
        }
        return null;
    }

    private ModelInfo getModelInfoFor(IEditorInput iEditorInput) {
        ModelInfo modelInfo = (ModelInfo)this.fModelInfoMap.get(iEditorInput);
        return modelInfo;
    }

    private ModelInfo getModelInfoFor(IStructuredModel iStructuredModel) {
        ModelInfo modelInfo = null;
        if (iStructuredModel != null) {
            ModelInfo[] modelInfoArray = this.fModelInfoMap.values().toArray(new ModelInfo[0]);
            int n = 0;
            while (n < modelInfoArray.length) {
                ModelInfo modelInfo2 = modelInfoArray[n];
                if (iStructuredModel.equals(modelInfo2.fStructuredModel)) {
                    modelInfo = modelInfo2;
                    break;
                }
                ++n;
            }
        }
        return modelInfo;
    }

    public IStructuredModel loadModel(IStorageEditorInput iStorageEditorInput) {
        return this.loadModel(iStorageEditorInput, false);
    }

    public IStructuredModel loadModel(IStorageEditorInput iStorageEditorInput, boolean bl) {
        IStructuredModel iStructuredModel;
        block22: {
            InputStream inputStream;
            String string;
            block20: {
                string = this.calculateID(iStorageEditorInput);
                if (string == null) {
                    return null;
                }
                inputStream = null;
                try {
                    inputStream = iStorageEditorInput.getStorage().getContents();
                }
                catch (CoreException coreException) {
                    if (!bl) break block20;
                    Logger.logException(coreException);
                }
            }
            iStructuredModel = null;
            try {
                try {
                    iStructuredModel = StructuredModelManager.getModelManager().getModelForEdit(string, inputStream, null);
                    iStructuredModel.setBaseLocation(this.calculateBaseLocation(iStorageEditorInput));
                }
                catch (IOException iOException) {
                    if (bl) {
                        Logger.logException(iOException);
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException2) {
                        }
                        catch (Exception exception) {
                            Logger.logException(exception);
                        }
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                    }
                    catch (Exception exception) {
                        Logger.logException(exception);
                    }
                }
                throw throwable;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                }
                catch (Exception exception) {
                    Logger.logException(exception);
                }
            }
        }
        return iStructuredModel;
    }

    private IStructuredModel selfCreateModel(IEditorInput iEditorInput) {
        return this.loadModel((IStorageEditorInput)iEditorInput);
    }

    private class InternalElementStateListener
    implements IElementStateListener {
        private InternalElementStateListener() {
        }

        public void elementContentAboutToBeReplaced(Object object) {
            LocalStorageModelProvider.this.fireElementContentAboutToBeReplaced(object);
        }

        public void elementContentReplaced(Object object) {
            StorageDocumentProvider.StorageInfo storageInfo;
            block22: {
                storageInfo = (StorageDocumentProvider.StorageInfo)LocalStorageModelProvider.this.getElementInfo(object);
                if (storageInfo != null && storageInfo.fModel != null) {
                    storageInfo.fModel.disconnect(storageInfo.fDocument);
                }
                Reader reader = null;
                IStructuredDocument iStructuredDocument = null;
                try {
                    CodedReaderCreator codedReaderCreator = new CodedReaderCreator(LocalStorageModelProvider.this.calculateID((IStorageEditorInput)object), Utilities.getMarkSupportedStream((InputStream)((IStorageEditorInput)object).getStorage().getContents()));
                    reader = codedReaderCreator.getCodedReader();
                    iStructuredDocument = (IStructuredDocument)storageInfo.fDocument;
                    int n = iStructuredDocument.getLength();
                    StringBuffer stringBuffer = new StringBuffer();
                    int n2 = 2048;
                    char[] cArray = new char[n2];
                    int n3 = 0;
                    boolean bl = false;
                    while (!bl) {
                        n3 = reader.read(cArray, 0, n2);
                        if (n3 == -1) {
                            bl = true;
                            continue;
                        }
                        stringBuffer.append(cArray, 0, n3);
                    }
                    iStructuredDocument.replaceText((Object)this, 0, n, stringBuffer.toString(), true);
                }
                catch (CoreException coreException) {
                    Logger.logException(coreException);
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {
                            Logger.logException(iOException);
                        }
                    }
                    break block22;
                }
                catch (IOException iOException) {
                    try {
                        Logger.logException(iOException);
                        break block22;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException2) {
                                Logger.logException(iOException2);
                            }
                        }
                    }
                }
                if (reader == null) break block22;
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    Logger.logException(iOException);
                }
            }
            if (storageInfo.fCanBeSaved) {
                storageInfo.fCanBeSaved = false;
                LocalStorageModelProvider.this.addUnchangedElementListeners(object, (AbstractDocumentProvider.ElementInfo)storageInfo);
            }
            LocalStorageModelProvider.this.fireElementContentReplaced(object);
            LocalStorageModelProvider.this.fireElementDirtyStateChanged(object, false);
            if (storageInfo != null && storageInfo.fModel != null) {
                storageInfo.fModel.connect(storageInfo.fDocument);
            }
        }

        public void elementDeleted(Object object) {
            LocalStorageModelProvider.this.fireElementDeleted(object);
        }

        public void elementDirtyStateChanged(Object object, boolean bl) {
            LocalStorageModelProvider.this.fireElementDirtyStateChanged(object, bl);
        }

        public void elementMoved(Object object, Object object2) {
            LocalStorageModelProvider.this.fireElementMoved(object, object2);
        }
    }

    private class ModelInfo {
        public IEditorInput fElement;
        public boolean fShouldReleaseOnInfoDispose;
        public IStructuredModel fStructuredModel;

        public ModelInfo(IStructuredModel iStructuredModel, IEditorInput iEditorInput, boolean bl) {
            this.fElement = iEditorInput;
            this.fStructuredModel = iStructuredModel;
            this.fShouldReleaseOnInfoDispose = bl;
        }
    }
}

