/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.folding.PHPFoldingStructureProviderDescriptor;
import org.eclipse.php.internal.ui.folding.PHPFoldingStructureProviderRegistry;
import org.eclipse.php.internal.ui.preferences.IPreferenceConfigurationBlock;
import org.eclipse.php.internal.ui.util.PixelConverter;
import org.eclipse.php.ui.folding.IPHPFoldingPreferenceBlock;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.preferences.OverlayPreferenceStore;

class FoldingConfigurationBlock
implements IPreferenceConfigurationBlock {
    private final OverlayPreferenceStore fStore;
    private Combo fProviderCombo;
    private Button fFoldingCheckbox;
    private ComboViewer fProviderViewer;
    private Composite fGroup;
    private StackLayout fStackLayout;
    private final Map fProviderDescriptors;
    private final Map fProviderPreferences;
    private final Map fProviderControls;

    public FoldingConfigurationBlock(OverlayPreferenceStore overlayPreferenceStore) {
        Assert.isNotNull((Object)overlayPreferenceStore);
        this.fStore = overlayPreferenceStore;
        this.fStore.addKeys(this.createOverlayStoreKeys());
        this.fProviderDescriptors = this.createListModel();
        this.fProviderPreferences = new HashMap();
        this.fProviderControls = new HashMap();
    }

    private Map createListModel() {
        PHPFoldingStructureProviderRegistry pHPFoldingStructureProviderRegistry = PHPUiPlugin.getDefault().getFoldingStructureProviderRegistry();
        pHPFoldingStructureProviderRegistry.reloadExtensions();
        PHPFoldingStructureProviderDescriptor[] pHPFoldingStructureProviderDescriptorArray = pHPFoldingStructureProviderRegistry.getFoldingProviderDescriptors();
        HashMap<String, PHPFoldingStructureProviderDescriptor> hashMap = new HashMap<String, PHPFoldingStructureProviderDescriptor>();
        PHPFoldingStructureProviderDescriptor[] pHPFoldingStructureProviderDescriptorArray2 = pHPFoldingStructureProviderDescriptorArray;
        int n = pHPFoldingStructureProviderDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            PHPFoldingStructureProviderDescriptor pHPFoldingStructureProviderDescriptor = pHPFoldingStructureProviderDescriptorArray2[n2];
            hashMap.put(pHPFoldingStructureProviderDescriptor.getId(), pHPFoldingStructureProviderDescriptor);
            ++n2;
        }
        return hashMap;
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> arrayList = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "foldingEnabled"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "editor_folding_provider"));
        OverlayPreferenceStore.OverlayKey[] overlayKeyArray = new OverlayPreferenceStore.OverlayKey[arrayList.size()];
        arrayList.toArray(overlayKeyArray);
        return overlayKeyArray;
    }

    public Control createControl(Composite composite) {
        GridLayout gridLayout;
        Composite composite2;
        Composite composite3 = new Composite(composite, 0);
        GridData gridData = new GridData(80);
        composite3.setLayoutData((Object)gridData);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        PixelConverter pixelConverter = new PixelConverter((Control)composite3);
        gridLayout2.verticalSpacing = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        composite3.setLayout((Layout)gridLayout2);
        this.fFoldingCheckbox = new Button(composite3, 32);
        this.fFoldingCheckbox.setText(PHPUIMessages.getString("FoldingConfigurationBlock_enable"));
        gridData = new GridData(34);
        this.fFoldingCheckbox.setLayoutData((Object)gridData);
        this.fFoldingCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = FoldingConfigurationBlock.this.fFoldingCheckbox.getSelection();
                FoldingConfigurationBlock.this.fStore.setValue("foldingEnabled", bl);
                FoldingConfigurationBlock.this.updateCheckboxDependencies();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        Label label = new Label(composite3, 0x1000000);
        gridData = new GridData(770);
        label.setLayoutData((Object)gridData);
        if (this.fProviderDescriptors.size() > 1) {
            composite2 = new Composite(composite3, 0);
            gridData = new GridData(770);
            gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            composite2.setLayout((Layout)gridLayout);
            Label label2 = new Label(composite2, 0x1000000);
            gridData = new GridData(36);
            label2.setLayoutData((Object)gridData);
            label2.setText(PHPUIMessages.getString("FoldingConfigurationBlock_combo_caption"));
            label = new Label(composite3, 0x1000000);
            gridData = new GridData(770);
            label.setLayoutData((Object)gridData);
            this.fProviderCombo = new Combo(composite2, 12);
            gridData = new GridData(132);
            this.fProviderCombo.setLayoutData((Object)gridData);
            this.fProviderViewer = this.createProviderViewer();
        }
        composite2 = new Composite(composite3, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.fGroup = new Composite(composite2, 0);
        gridData = new GridData(34);
        this.fGroup.setLayoutData((Object)gridData);
        this.fStackLayout = new StackLayout();
        this.fGroup.setLayout((Layout)this.fStackLayout);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite3, "org.eclipse.php.help.folding_preferences");
        return composite3;
    }

    private ComboViewer createProviderViewer() {
        ComboViewer comboViewer = new ComboViewer(this.fProviderCombo);
        comboViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }

            public Object[] getElements(Object object) {
                return FoldingConfigurationBlock.this.fProviderDescriptors.values().toArray();
            }
        });
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object object) {
                return null;
            }

            public String getText(Object object) {
                return ((PHPFoldingStructureProviderDescriptor)object).getName();
            }
        });
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
                if (!iStructuredSelection.isEmpty()) {
                    FoldingConfigurationBlock.this.fStore.setValue("editor_folding_provider", ((PHPFoldingStructureProviderDescriptor)iStructuredSelection.getFirstElement()).getId());
                    FoldingConfigurationBlock.this.updateListDependencies();
                }
            }
        });
        comboViewer.setInput((Object)this.fProviderDescriptors);
        comboViewer.refresh();
        return comboViewer;
    }

    private void updateCheckboxDependencies() {
    }

    void updateListDependencies() {
        IPHPFoldingPreferenceBlock iPHPFoldingPreferenceBlock;
        String string;
        String string2 = this.fStore.getString("editor_folding_provider");
        PHPFoldingStructureProviderDescriptor pHPFoldingStructureProviderDescriptor = (PHPFoldingStructureProviderDescriptor)this.fProviderDescriptors.get(string2);
        if (pHPFoldingStructureProviderDescriptor == null) {
            string = PHPUIMessages.getString("FoldingConfigurationBlock_error_not_exist");
            PHPUiPlugin.log((IStatus)new Status(2, PHPUiPlugin.getPluginId(), 0, string, null));
            iPHPFoldingPreferenceBlock = new ErrorPreferences(string);
        } else {
            iPHPFoldingPreferenceBlock = (IPHPFoldingPreferenceBlock)this.fProviderPreferences.get(string2);
            if (iPHPFoldingPreferenceBlock == null) {
                try {
                    iPHPFoldingPreferenceBlock = pHPFoldingStructureProviderDescriptor.createPreferences();
                    this.fProviderPreferences.put(string2, iPHPFoldingPreferenceBlock);
                }
                catch (CoreException coreException) {
                    PHPUiPlugin.log(coreException);
                    iPHPFoldingPreferenceBlock = new ErrorPreferences(coreException.getLocalizedMessage());
                }
            }
        }
        string = (Control)this.fProviderControls.get(string2);
        if (string == null) {
            string = iPHPFoldingPreferenceBlock.createControl(this.fGroup);
            if (string == null) {
                String string3 = PHPUIMessages.getString("FoldingConfigurationBlock_info_no_preferences");
                string = new ErrorPreferences(string3).createControl(this.fGroup);
            } else {
                this.fProviderControls.put(string2, string);
            }
        }
        Dialog.applyDialogFont((Control)string);
        this.fStackLayout.topControl = string;
        string.pack();
        this.fGroup.layout();
        this.fGroup.getParent().layout();
        iPHPFoldingPreferenceBlock.initialize();
    }

    public void initialize() {
        this.restoreFromPreferences();
    }

    public void performOk() {
        this.fStore.propagate();
        for (IPHPFoldingPreferenceBlock iPHPFoldingPreferenceBlock : this.fProviderPreferences.values()) {
            iPHPFoldingPreferenceBlock.performOk();
        }
        boolean bl = this.fStore.getBoolean("foldingEnabled");
        SSEUIPlugin.getDefault().getPreferenceStore().setValue("foldingEnabled", bl);
    }

    public void performDefaults() {
        this.restoreFromPreferences();
        for (IPHPFoldingPreferenceBlock iPHPFoldingPreferenceBlock : this.fProviderPreferences.values()) {
            iPHPFoldingPreferenceBlock.performDefaults();
        }
    }

    public void dispose() {
        for (IPHPFoldingPreferenceBlock iPHPFoldingPreferenceBlock : this.fProviderPreferences.values()) {
            iPHPFoldingPreferenceBlock.dispose();
        }
    }

    private void restoreFromPreferences() {
        boolean bl = this.fStore.getBoolean("foldingEnabled");
        this.fFoldingCheckbox.setSelection(bl);
        this.updateCheckboxDependencies();
        String string = this.fStore.getString("editor_folding_provider");
        Object v = this.fProviderDescriptors.get(string);
        if (v != null) {
            if (this.fProviderViewer == null) {
                this.updateListDependencies();
            } else {
                this.fProviderViewer.setSelection((ISelection)new StructuredSelection(v), true);
            }
        }
    }

    private static class ErrorPreferences
    implements IPHPFoldingPreferenceBlock {
        private String fMessage;

        protected ErrorPreferences(String string) {
            this.fMessage = string;
        }

        public Control createControl(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayout((Layout)new FillLayout(512));
            Label label = new Label(composite2, 0x1000000);
            label.setText(this.fMessage);
            return composite2;
        }

        public void initialize() {
        }

        public void performOk() {
        }

        public void performDefaults() {
        }

        public void dispose() {
        }
    }
}

