/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.phpElementData;

import org.eclipse.core.runtime.Platform;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;

public abstract class AbstractCodeData
implements CodeData {
    protected String name;
    private boolean isUserCode;
    protected UserData userData;

    public AbstractCodeData(String string) {
        this(string, null);
    }

    public AbstractCodeData(String string, UserData userData) {
        this.name = string;
        this.userData = userData;
        this.isUserCode = userData != null;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isUserCode() {
        return this.isUserCode;
    }

    public final UserData getUserData() {
        return this.userData;
    }

    public int compareTo(CodeData codeData) {
        int n = this.name.compareToIgnoreCase(codeData.getName());
        if (n != 0) {
            return n;
        }
        boolean bl = codeData.isUserCode();
        if (!this.isUserCode) {
            if (!bl) {
                return 0;
            }
            return -1;
        }
        if (!bl) {
            return 1;
        }
        return this.userData.getFileName().compareTo(codeData.getUserData().getFileName());
    }

    public String toString() {
        if (this.getUserData() == null) {
            return this.name;
        }
        return String.valueOf(this.name) + " in " + this.getUserData().getFileName();
    }

    public Object getAdapter(Class clazz) {
        return Platform.getAdapterManager().getAdapter((Object)this, clazz);
    }
}

