/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.pathmapper;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.php.internal.core.util.preferences.IXMLPreferencesStorable;
import org.eclipse.php.internal.core.util.preferences.XMLPreferencesReader;
import org.eclipse.php.internal.core.util.preferences.XMLPreferencesWriter;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.preferences.IPHPExesListener;
import org.eclipse.php.internal.debug.core.preferences.PHPExesEvent;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.IServersManagerListener;
import org.eclipse.php.internal.server.core.manager.ServerManagerEvent;
import org.eclipse.php.internal.server.core.manager.ServersManager;

public class PathMapperRegistry
implements IXMLPreferencesStorable,
IServersManagerListener,
IPHPExesListener {
    private static final String PATH_MAPPER_PREF_KEY = String.valueOf(PHPDebugPlugin.getID()) + ".pathMapper";
    private static PathMapperRegistry instance;
    private HashMap<Server, PathMapper> serverPathMapper = new HashMap();
    private HashMap<PHPexeItem, PathMapper> phpExePathMapper = new HashMap();

    private PathMapperRegistry() {
        this.loadFromPreferences();
    }

    public static synchronized PathMapperRegistry getInstance() {
        if (instance == null) {
            instance = new PathMapperRegistry();
        }
        return instance;
    }

    public static PathMapper getByPHPExe(PHPexeItem pHPexeItem) {
        PathMapper pathMapper = PathMapperRegistry.getInstance().phpExePathMapper.get(pHPexeItem);
        if (pathMapper == null) {
            pathMapper = new PathMapper();
            PathMapperRegistry.getInstance().phpExePathMapper.put(pHPexeItem, pathMapper);
            PHPexes.getInstance().addPHPExesListener(PathMapperRegistry.getInstance());
        }
        return pathMapper;
    }

    public static PathMapper getByServer(Server server) {
        PathMapper pathMapper = PathMapperRegistry.getInstance().serverPathMapper.get(server);
        if (pathMapper == null) {
            pathMapper = new PathMapper();
            PathMapperRegistry.getInstance().serverPathMapper.put(server, pathMapper);
            ServersManager.addManagerListener((IServersManagerListener)PathMapperRegistry.getInstance());
        }
        return pathMapper;
    }

    public static PathMapper getByLaunchConfiguration(ILaunchConfiguration iLaunchConfiguration) {
        PathMapper pathMapper = null;
        try {
            String string = iLaunchConfiguration.getAttribute("name", null);
            if (string != null) {
                pathMapper = PathMapperRegistry.getByServer(ServersManager.getServer((String)string));
            }
        }
        catch (CoreException coreException) {
            PHPDebugPlugin.log(coreException);
        }
        return pathMapper;
    }

    public void loadFromPreferences() {
        HashMap[] hashMapArray = XMLPreferencesReader.read((Preferences)PHPProjectPreferences.getModelPreferences(), (String)PATH_MAPPER_PREF_KEY);
        if (hashMapArray.length == 1) {
            this.restoreFromMap(hashMapArray[0]);
        }
    }

    public static void storeToPreferences() {
        XMLPreferencesWriter.write((Preferences)PHPProjectPreferences.getModelPreferences(), (String)PATH_MAPPER_PREF_KEY, (IXMLPreferencesStorable)PathMapperRegistry.getInstance());
    }

    public synchronized void restoreFromMap(HashMap hashMap) {
        if (hashMap == null) {
            return;
        }
        this.serverPathMapper.clear();
        this.phpExePathMapper.clear();
        hashMap = (HashMap)hashMap.get("pathMappers");
        if (hashMap == null) {
            return;
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            HashMap hashMap2 = (HashMap)hashMap.get(iterator.next());
            String string = (String)hashMap2.get("server");
            String string2 = (String)hashMap2.get("phpExe");
            String string3 = (String)hashMap2.get("phpIni");
            PathMapper pathMapper = new PathMapper();
            pathMapper.restoreFromMap((HashMap)hashMap2.get("mapper"));
            if (string != null) {
                object = ServersManager.getServer((String)string);
                if (object == null) continue;
                this.serverPathMapper.put((Server)object, pathMapper);
                continue;
            }
            if (string2 == null || (object = PHPexes.getInstance().getItemForFile(string2, string3)) == null) continue;
            this.phpExePathMapper.put((PHPexeItem)object, pathMapper);
        }
    }

    public synchronized HashMap storeToMap() {
        PathMapper pathMapper;
        Object object;
        HashMap<String, Object> hashMap;
        HashMap hashMap2 = new HashMap();
        Iterator<Object> iterator = this.serverPathMapper.keySet().iterator();
        int n = 1;
        while (iterator.hasNext()) {
            hashMap = new HashMap<String, Object>();
            object = (Server)iterator.next();
            pathMapper = this.serverPathMapper.get(object);
            hashMap.put("server", object.getName());
            hashMap.put("mapper", pathMapper.storeToMap());
            hashMap2.put("item" + n++, hashMap);
        }
        iterator = this.phpExePathMapper.keySet().iterator();
        while (iterator.hasNext()) {
            hashMap = new HashMap();
            object = (PHPexeItem)iterator.next();
            pathMapper = this.phpExePathMapper.get(object);
            hashMap.put("phpExe", ((PHPexeItem)object).getExecutable().toString());
            if (((PHPexeItem)object).getINILocation() != null) {
                hashMap.put("phpIni", ((PHPexeItem)object).getINILocation().toString());
            }
            hashMap.put("mapper", pathMapper.storeToMap());
            hashMap2.put("item" + n++, hashMap);
        }
        hashMap = new HashMap();
        hashMap.put("pathMappers", hashMap2);
        return hashMap;
    }

    public void serverAdded(ServerManagerEvent serverManagerEvent) {
        if (!this.serverPathMapper.containsKey(serverManagerEvent.getServer())) {
            this.serverPathMapper.put(serverManagerEvent.getServer(), new PathMapper());
        }
    }

    public void serverModified(ServerManagerEvent serverManagerEvent) {
    }

    public void serverRemoved(ServerManagerEvent serverManagerEvent) {
        this.serverPathMapper.remove(serverManagerEvent.getServer());
    }

    public void phpExeAdded(PHPExesEvent pHPExesEvent) {
        if (!this.phpExePathMapper.containsKey(pHPExesEvent.getPHPExeItem())) {
            this.phpExePathMapper.put(pHPExesEvent.getPHPExeItem(), new PathMapper());
        }
    }

    public void phpExeRemoved(PHPExesEvent pHPExesEvent) {
        this.phpExePathMapper.remove(pHPExesEvent.getPHPExeItem());
    }
}

