/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger.handlers;

import java.util.LinkedList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.php.debug.core.debugger.handlers.IDebugMessageHandler;
import org.eclipse.php.debug.core.debugger.messages.IDebugMessage;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.model.PHPConditionalBreakpoint;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;
import org.eclipse.php.internal.debug.core.zend.debugger.Breakpoint;
import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.ContinueProcessFileNotification;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.StartProcessFileNotification;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;

public class StartProcessFileNotificationHandler
implements IDebugMessageHandler {
    protected boolean isFirstFileToDebug = true;

    public void handle(IDebugMessage iDebugMessage, PHPDebugTarget pHPDebugTarget) {
        StartProcessFileNotification startProcessFileNotification = (StartProcessFileNotification)iDebugMessage;
        String string = startProcessFileNotification.getFileName();
        this.prepareForProcessing(string, pHPDebugTarget);
        RemoteDebugger remoteDebugger = (RemoteDebugger)pHPDebugTarget.getRemoteDebugger();
        remoteDebugger.sendCustomNotification(new ContinueProcessFileNotification());
    }

    protected void prepareForProcessing(String string, PHPDebugTarget pHPDebugTarget) {
        VirtualPath virtualPath;
        IBreakpoint[] iBreakpointArray;
        RemoteDebugger remoteDebugger = (RemoteDebugger)pHPDebugTarget.getRemoteDebugger();
        ILaunchConfiguration iLaunchConfiguration = pHPDebugTarget.getLaunch().getLaunchConfiguration();
        remoteDebugger.removeCWDCache();
        pHPDebugTarget.setLastFileName(string);
        boolean bl = Boolean.toString(true).equals(pHPDebugTarget.getLaunch().getAttribute("webServerDebugger"));
        String string2 = "";
        try {
            string2 = iLaunchConfiguration.getAttribute("php_debug_type", "");
        }
        catch (CoreException coreException) {
            PHPDebugPlugin.log(coreException);
        }
        String string3 = null;
        if (this.isFirstFileToDebug) {
            if (bl) {
                iBreakpointArray = pHPDebugTarget.mapFirstDebugFile(string);
                string3 = iBreakpointArray != null ? iBreakpointArray.getResolvedPath() : string;
                if (string2.equals("php_web_script_debug")) {
                    virtualPath = new VirtualPath(string);
                    virtualPath.removeLastSegment();
                    remoteDebugger.setCurrentWorkingDirectory(virtualPath.toString());
                }
            } else {
                try {
                    iBreakpointArray = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(Path.fromOSString((String)string));
                    if (iBreakpointArray != null) {
                        string3 = iBreakpointArray.getFullPath().toString();
                    }
                }
                catch (Exception exception) {}
                if (string3 == null) {
                    string3 = string;
                }
            }
        } else {
            string3 = remoteDebugger.convertToLocalFilename(string);
        }
        if (string3 != null && "debug".equals(pHPDebugTarget.getLaunch().getLaunchMode())) {
            IBreakpoint[] iBreakpointArray2 = iBreakpointArray = this.findBreakpoints(string3, pHPDebugTarget);
            int n = iBreakpointArray.length;
            int n2 = 0;
            while (n2 < n) {
                virtualPath = iBreakpointArray2[n2];
                try {
                    if (virtualPath.isEnabled()) {
                        PHPConditionalBreakpoint pHPConditionalBreakpoint = (PHPConditionalBreakpoint)((Object)virtualPath);
                        Breakpoint breakpoint = pHPConditionalBreakpoint.getRuntimeBreakpoint();
                        int n3 = (Integer)virtualPath.getMarker().getAttribute("lineNumber");
                        Breakpoint breakpoint2 = new Breakpoint(string, n3);
                        boolean bl2 = pHPConditionalBreakpoint.isConditionEnabled();
                        if (bl2) {
                            breakpoint2.setConditionalFlag(bl2);
                            breakpoint2.setExpression(pHPConditionalBreakpoint.getCondition());
                        }
                        pHPDebugTarget.getRemoteDebugger().addBreakpoint(breakpoint2);
                        breakpoint.setID(breakpoint2.getID());
                    }
                }
                catch (CoreException coreException) {
                    PHPDebugPlugin.log(coreException);
                }
                ++n2;
            }
        }
        this.isFirstFileToDebug = false;
    }

    protected IBreakpoint[] findBreakpoints(String string, PHPDebugTarget pHPDebugTarget) {
        IBreakpointManager iBreakpointManager = pHPDebugTarget.getBreakpointManager();
        if (!iBreakpointManager.isEnabled()) {
            return new IBreakpoint[0];
        }
        IBreakpoint[] iBreakpointArray = iBreakpointManager.getBreakpoints("org.eclipse.php.debug.core");
        LinkedList<IBreakpoint> linkedList = new LinkedList<IBreakpoint>();
        IBreakpoint[] iBreakpointArray2 = iBreakpointArray;
        int n = iBreakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint iBreakpoint = iBreakpointArray2[n2];
            IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(string);
            if (iBreakpoint.getMarker().getResource().equals((Object)iResource)) {
                linkedList.add(iBreakpoint);
            }
            try {
                Object object = iBreakpoint.getMarker().getAttribute("org.eclipse.wst.sse.ui.extensions.breakpoint.path");
                if (object != null && new VirtualPath(string).equals(new VirtualPath((String)object))) {
                    linkedList.add(iBreakpoint);
                }
            }
            catch (CoreException coreException) {
                PHPDebugPlugin.log(coreException);
            }
            ++n2;
        }
        return linkedList.toArray(new IBreakpoint[linkedList.size()]);
    }
}

