/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.core.internal.JpaModelManager;
import org.eclipse.jpt.core.internal.JptCorePlugin;
import org.eclipse.jpt.core.internal.content.orm.EntityMappingsInternal;
import org.eclipse.jpt.core.internal.content.orm.OrmFactory;
import org.eclipse.jpt.core.internal.content.orm.OrmResource;
import org.eclipse.jpt.core.internal.content.orm.resource.OrmArtifactEdit;
import org.eclipse.jpt.core.internal.content.persistence.Persistence;
import org.eclipse.jpt.core.internal.content.persistence.PersistenceFactory;
import org.eclipse.jpt.core.internal.content.persistence.PersistenceUnit;
import org.eclipse.jpt.core.internal.content.persistence.resource.PersistenceArtifactEdit;
import org.eclipse.jpt.core.internal.content.persistence.resource.PersistenceResource;
import org.eclipse.jpt.core.internal.facet.IJpaFacetDataModelProperties;
import org.eclipse.jpt.core.internal.facet.JpaFacetUtils;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class JpaFacetPostInstallDelegate
implements IDelegate,
IJpaFacetDataModelProperties {
    private static final String WEB_PROJECT_DEPLOY_PREFIX = "WEB-INF/classes";
    private static final String PERSISTENCE_XML_FILE_PATH = "META-INF/persistence.xml";
    private static final String ORM_XML_FILE_PATH = "META-INF/orm.xml";

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 2);
        }
        JpaModelManager.instance().createJpaProject(project);
        IDataModel dataModel = (IDataModel)config;
        JpaFacetUtils.setPlatform(project, dataModel.getStringProperty("IJpaFacetDataModelProperties.PLATFORM_ID"));
        JpaFacetUtils.setConnectionName(project, dataModel.getStringProperty("IJpaFacetDataModelProperties.CONNECTION"));
        JpaFacetUtils.setDiscoverAnnotatedClasses(project, dataModel.getBooleanProperty("IJpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES"));
        this.createPersistenceXml(project, dataModel);
        if (dataModel.getBooleanProperty("IJpaFacetDataModelProperties.CREATE_ORM_XML")) {
            this.createOrmXml(project, dataModel);
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        JpaModelManager.instance().fillJpaProject(project);
        if (monitor != null) {
            monitor.worked(2);
        }
    }

    private void createPersistenceXml(IProject project, IDataModel dataModel) {
        PersistenceArtifactEdit pae;
        PersistenceResource resource;
        String deployPath = PERSISTENCE_XML_FILE_PATH;
        try {
            if (FacetedProjectFramework.hasProjectFacet((IProject)project, (String)"jst.web")) {
                deployPath = "WEB-INF/classes/" + deployPath;
            }
        }
        catch (CoreException ce) {
            JptCorePlugin.log(ce);
        }
        if ((resource = (pae = PersistenceArtifactEdit.getArtifactEditForWrite(project)).getPersistenceResource(deployPath)).getPersistence() == null) {
            Persistence persistence = PersistenceFactory.eINSTANCE.createPersistence();
            persistence.setVersion("1.0");
            PersistenceUnit pUnit = PersistenceFactory.eINSTANCE.createPersistenceUnit();
            pUnit.setName(project.getName());
            persistence.getPersistenceUnits().add((Object)pUnit);
            resource.getContents().add((Object)persistence);
            pae.save(null);
        }
        pae.dispose();
    }

    private void createOrmXml(IProject project, IDataModel dataModel) {
        OrmArtifactEdit oae;
        OrmResource resource;
        String deployPath = ORM_XML_FILE_PATH;
        try {
            if (FacetedProjectFramework.hasProjectFacet((IProject)project, (String)"jst.web")) {
                deployPath = "WEB-INF/classes/" + deployPath;
            }
        }
        catch (CoreException ce) {
            JptCorePlugin.log(ce);
        }
        if ((resource = (oae = OrmArtifactEdit.getArtifactEditForWrite(project)).getOrmResource(deployPath)).getEntityMappings() == null) {
            EntityMappingsInternal entityMappings = OrmFactory.eINSTANCE.createEntityMappingsInternal();
            entityMappings.setVersion("1.0");
            resource.getContents().add((Object)entityMappings);
            oae.save(null);
        }
        oae.dispose();
    }
}

