/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.Messages;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryRegistryUtil;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util.JSFLibraryRegistryResourceFactoryImpl;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util.JSFLibraryRegistryResourceImpl;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util.JSFLibraryRegistryUpgradeUtil;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util.UpgradeStatus;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.util.VersionUpgradeOperation;

class MigrateV1toV2Operation
extends VersionUpgradeOperation {
    private final URI _v1Registry;
    private final URI _v2Registry;

    public MigrateV1toV2Operation(String label, URI v1Registry, URI v2Registry) {
        super(label, 1, 2);
        this._v1Registry = v1Registry;
        this._v2Registry = v2Registry;
    }

    public IStatus doCommit() {
        JSFLibraryRegistryUpgradeUtil.deleteFile(this._v1Registry.toFileString());
        return Status.OK_STATUS;
    }

    public IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
        JSFLibraryRegistryUpgradeUtil.copyFile(this._v1Registry.toFileString(), JSFLibraryRegistryUpgradeUtil.getBackupFileName(this._v1Registry.toFileString()));
        JSFLibraryRegistryResourceFactoryImpl resourceFactory = new JSFLibraryRegistryResourceFactoryImpl();
        JSFLibraryRegistryResourceImpl res = (JSFLibraryRegistryResourceImpl)resourceFactory.createResource(this._v1Registry);
        try {
            URI newRegURI = JSFLibraryRegistryUpgradeUtil.getRegistryURI(".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistryV2.xml");
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("DISABLE_NOTIFY", Boolean.TRUE);
            res.load(options);
            JSFLibraryRegistryUtil.getInstance().saveJSFLibraryRegistry();
            JSFLibraryRegistryUpgradeUtil.copyFile(this._v1Registry.toFileString(), newRegURI.toFileString());
            JSFLibraryRegistryUpgradeUtil.deleteFile(this._v1Registry.toFileString());
            return new UpgradeStatus();
        }
        catch (IOException iOException) {
            try {
                res.save(Collections.EMPTY_MAP);
                URI newRegURI = JSFLibraryRegistryUpgradeUtil.getRegistryURI(".metadata/.plugins/org.eclipse.jst.jsf.core/JSFLibraryRegistryV2.xml");
                JSFLibraryRegistryUpgradeUtil.copyFile(this._v1Registry.toFileString(), newRegURI.toFileString());
                JSFLibraryRegistryUpgradeUtil.deleteFile(this._v1Registry.toFileString());
                JSFLibraryRegistryUpgradeUtil.copyFile(this._v1Registry.toFileString().concat(".bkp"), this._v1Registry.toFileString());
                return new UpgradeStatus(0, true, Messages.JSFRegistryMigration05_to_10_customMessage);
            }
            catch (IOException e) {
                JSFCorePlugin.log(4, "Error during repository upgrade from v1 to v2", e);
                return new UpgradeStatus(4, false, Messages.JSFRegistryMigrationCannot05_to_10_customMessage);
            }
        }
    }

    public IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.doExecute(monitor, info);
    }

    public boolean canUndo() {
        return super.canUndo() && !this.hasCommitted();
    }

    public IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        JSFLibraryRegistryUpgradeUtil.copyFile(this._v1Registry.toFileString().concat(".bkp"), this._v1Registry.toFileString());
        JSFLibraryRegistryUpgradeUtil.deleteFile(this._v2Registry.toFileString());
        JSFLibraryRegistryUpgradeUtil.deleteFile(this._v1Registry.toFileString().concat(".bkp"));
        return Status.OK_STATUS;
    }
}

