/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.deltaddl;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.DDLGenerator;
import org.eclipse.datatools.connectivity.sqm.core.rte.EngineeringOption;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DatabaseDefinitionRegistryImpl;
import org.eclipse.datatools.enablement.sybase.ddl.ISybaseDdlGenerator;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlGenerator;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlScript;
import org.eclipse.datatools.enablement.sybase.deltaddl.DeltaDdlGenServiceImpl;
import org.eclipse.datatools.enablement.sybase.deltaddl.IDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.deltaddl.ISybaseDeltaDdlGenerator;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.sdo.EChangeSummary;
import org.eclipse.emf.ecore.sdo.EDataObject;
import org.eclipse.emf.ecore.sdo.EProperty;

public class SybaseDeltaDdlGeneration
implements ISybaseDeltaDdlGenerator {
    public static final int CREATE = 1;
    public static final int DROP = 2;
    public static final int MODIFIED = 4;
    protected Map modifyRecords = null;
    protected EChangeSummary changeSummary = null;
    protected Collection redoChanges = null;
    protected EngineeringOption[] options = null;

    public String[] generateDeltaDDL(EChangeSummary changeSummary, IProgressMonitor monitor) {
        this.changeSummary = changeSummary;
        this.changeSummary.summarize();
        Map changeMap = this.buildChangeMap(monitor);
        this.analyze(changeMap);
        String[] statements = this.processChangeMap(changeMap, monitor);
        this.changeSummary = null;
        this.redoChanges = null;
        this.modifyRecords = null;
        this.options = null;
        return statements;
    }

    public String[] generateDeltaDDL(EChangeSummary changeSummary, EngineeringOption[] options, IProgressMonitor monitor) {
        this.options = options;
        return this.generateDeltaDDL(changeSummary, monitor);
    }

    protected int getChangeFlag(EObject element, EObject changed, EStructuralFeature feature, ChangeSummary.Setting setting) {
        ArrayList<FeatureChangeRecord> records;
        int flag = 4;
        if (this.modifyRecords == null) {
            this.modifyRecords = new HashMap();
        }
        if ((records = (ArrayList<FeatureChangeRecord>)this.modifyRecords.get(element)) == null) {
            records = new ArrayList<FeatureChangeRecord>();
            this.modifyRecords.put(element, records);
        }
        FeatureChangeRecord cr = new FeatureChangeRecord();
        cr.feature = feature;
        cr.oldValue = setting.getValue();
        cr.newValue = changed.eGet(feature);
        records.add(cr);
        return flag;
    }

    protected void analyze(Map changeMap) {
        LinkedList elements = new LinkedList();
        elements.addAll(changeMap.keySet());
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            SQLObject sqlObj;
            IDeltaDdlGenProvider provider;
            EObject e = (EObject)it.next();
            if (!(e instanceof SQLObject) || (provider = this.getProvider(sqlObj = (SQLObject)e)) == null) continue;
            provider.analyze(sqlObj, changeMap, this.modifyRecords);
        }
    }

    protected String[] processChangeMap(Map changeMap, IProgressMonitor monitor) {
        ISybaseDdlGenerator ddlGenerator = (ISybaseDdlGenerator)this.getDDLGenerator();
        SybaseDdlScript script = new SybaseDdlScript();
        this.undo();
        this.processDropStatements(ddlGenerator, changeMap, script, monitor);
        this.redo();
        this.processCreateStatements(ddlGenerator, changeMap, script, monitor);
        this.processAlterStatements(changeMap, script, monitor);
        this.changeSummary = null;
        this.polishScripts(changeMap, script);
        return script.getStatements();
    }

    protected void polishScripts(Map changeMap, SybaseDdlScript script) {
    }

    protected void processCreateStatements(ISybaseDdlGenerator ddlGenerator, Map changeMap, SybaseDdlScript script, IProgressMonitor monitor) {
        Iterator it = changeMap.keySet().iterator();
        while (it.hasNext()) {
            SQLObject sqlObj;
            IDeltaDdlGenProvider provider;
            EObject key = (EObject)it.next();
            int flag = (Integer)changeMap.get(key);
            if ((flag & 1) == 0 || !(key instanceof SQLObject) || (provider = this.getProvider(sqlObj = (SQLObject)key)) == null) continue;
            provider.processCreateStatement(sqlObj, this.generateQuotedIdentifiers(), this.generateFullyQualifiedNames(), this.generateFullSyntax(), script, ddlGenerator, monitor);
        }
    }

    protected void processDropStatements(DDLGenerator ddlGenerator, Map changeMap, SybaseDdlScript script, IProgressMonitor monitor) {
        Iterator it = changeMap.keySet().iterator();
        while (it.hasNext()) {
            SQLObject sqlObj;
            IDeltaDdlGenProvider provider;
            EObject key = (EObject)it.next();
            int flag = (Integer)changeMap.get(key);
            if ((flag & 2) == 0 || !(key instanceof SQLObject) || (provider = this.getProvider(sqlObj = (SQLObject)key)) == null) continue;
            provider.processDropStatement(sqlObj, this.generateQuotedIdentifiers(), this.generateFullyQualifiedNames(), script, ddlGenerator, monitor);
        }
    }

    protected void processAlterStatements(Map changeMap, SybaseDdlScript script, IProgressMonitor monitor) {
        Iterator it = changeMap.keySet().iterator();
        while (it.hasNext()) {
            SQLObject sqlObj;
            IDeltaDdlGenProvider provider;
            EObject key = (EObject)it.next();
            int flag = (Integer)changeMap.get(key);
            if ((flag & 3) != 0 || !(key instanceof SQLObject) || (provider = this.getProvider(sqlObj = (SQLObject)key)) == null) continue;
            provider.processAlterStatement(sqlObj, this.modifyRecords, this.generateQuotedIdentifiers(), this.generateFullyQualifiedNames(), this.generateFullSyntax(), script, monitor);
        }
    }

    private IDeltaDdlGenProvider getProvider(SQLObject obj) {
        DatabaseDefinition def;
        EObject root = ContainmentServiceImpl.INSTANCE.getRootElement((EObject)obj);
        if (root instanceof Database && (def = DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition((Database)root)) != null) {
            IDeltaDdlGenProvider provider = DeltaDdlGenServiceImpl.INSTANCE.getDeltaDdlGenProvider(def.getProduct(), def.getVersion(), (EObject)obj);
            return provider;
        }
        return null;
    }

    protected EngineeringOption[] getOptions() {
        if (this.options == null) {
            return ((SybaseDdlGenerator)this.getDDLGenerator()).getGenrerationOptions();
        }
        return this.options;
    }

    protected final boolean generateQuotedIdentifiers() {
        return ((SybaseDdlGenerator)this.getDDLGenerator()).generateQuotedIdentifiers(this.getOptions());
    }

    protected final boolean generateFullyQualifiedNames() {
        return ((SybaseDdlGenerator)this.getDDLGenerator()).generateFullyQualifiedNames(this.getOptions());
    }

    protected final boolean generateFullSyntax() {
        return ((SybaseDdlGenerator)this.getDDLGenerator()).generateFullSyntax(this.getOptions());
    }

    private Map buildChangeMap(IProgressMonitor monitor) {
        HashMap<EDataObject, Integer> changeMap = new HashMap<EDataObject, Integer>();
        Iterator it = this.changeSummary.getChangedDataObjects().iterator();
        while (it.hasNext()) {
            EDataObject changed;
            EDataObject element;
            Object changedObject = it.next();
            if (!(changedObject instanceof EDataObject) || (element = (EDataObject)this.getDisplayableElement((EObject)(changed = (EDataObject)changedObject))) == null) continue;
            int flag = 0;
            if (changeMap.containsKey(element)) {
                flag = (Integer)changeMap.get(element);
            }
            if (flag == 2 || flag == 1) continue;
            if (this.changeSummary.isCreated((DataObject)element)) {
                if (this.changeSummary.isDeleted((DataObject)element)) continue;
                flag = 1;
            } else if (this.changeSummary.isDeleted((DataObject)element)) {
                flag = 2;
            } else {
                List oldValues;
                if (this.changeSummary.isCreated((DataObject)changed) || this.changeSummary.isDeleted((DataObject)changed) || (oldValues = this.changeSummary.getOldValues((DataObject)changed)) == null) continue;
                Iterator vi = oldValues.iterator();
                while (vi.hasNext()) {
                    ChangeSummary.Setting changeSetting = (ChangeSummary.Setting)vi.next();
                    EProperty p = (EProperty)changeSetting.getProperty();
                    EStructuralFeature f = p.getEStructuralFeature();
                    if (!changeSetting.isSet() && !changed.eIsSet(f)) continue;
                    Object currentValue = changed.eGet(f);
                    Object previousValue = changeSetting.getValue();
                    if (currentValue == null) {
                        currentValue = "";
                    }
                    if (previousValue == null) {
                        previousValue = "";
                    }
                    if (currentValue.equals(previousValue)) continue;
                    flag |= this.getChangeFlag((EObject)element, (EObject)changed, f, changeSetting);
                }
            }
            if (flag == 0) continue;
            changeMap.put(element, new Integer(flag));
        }
        return changeMap;
    }

    protected final DDLGenerator getDDLGenerator() {
        EObject x = (EObject)this.changeSummary.getDataGraph().getRootObject();
        Database database = (Database)ContainmentServiceImpl.INSTANCE.getRootElement(x);
        DatabaseDefinition def = DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition(database);
        return def.getDDLGenerator();
    }

    protected final void undo() {
        LinkedList<ChangeRecord> undoStack = new LinkedList<ChangeRecord>();
        LinkedList<ChangeRecord> redoStack = new LinkedList<ChangeRecord>();
        Iterator it = this.changeSummary.getChangedDataObjects().iterator();
        while (it.hasNext()) {
            EDataObject changed;
            List oldValues;
            Object changedObject = it.next();
            if (!(changedObject instanceof EDataObject) || (oldValues = this.changeSummary.getOldValues((DataObject)(changed = (EDataObject)changedObject))) == null) continue;
            Iterator vi = oldValues.iterator();
            while (vi.hasNext()) {
                ChangeSummary.Setting changeSetting = (ChangeSummary.Setting)vi.next();
                EProperty p = (EProperty)changeSetting.getProperty();
                EStructuralFeature f = p.getEStructuralFeature();
                changeSetting.getValue();
                ChangeRecord c1 = new ChangeRecord();
                c1.element = changed;
                c1.feature = f;
                c1.isSet = true;
                if (f.isUnsettable()) {
                    c1.isSet = changeSetting.isSet();
                }
                if (c1.isSet) {
                    c1.value = changeSetting.getValue();
                    if (c1.value instanceof Collection) {
                        LinkedList l = new LinkedList();
                        l.addAll((Collection)c1.value);
                        c1.value = l;
                    }
                } else {
                    c1.value = null;
                }
                undoStack.add(c1);
                ChangeRecord c2 = new ChangeRecord();
                c2.element = changed;
                c2.feature = f;
                c2.isSet = true;
                if (f.isUnsettable()) {
                    c2.isSet = changed.eIsSet(f);
                }
                if (c2.isSet) {
                    c2.value = changed.eGet(f);
                    if (c2.value instanceof Collection) {
                        LinkedList l = new LinkedList();
                        l.addAll((Collection)c2.value);
                        c2.value = l;
                    }
                }
                redoStack.add(c2);
            }
        }
        this.executeChangeRecords(undoStack);
        this.redoChanges = redoStack;
    }

    protected final void redo() {
        this.executeChangeRecords(this.redoChanges);
    }

    protected final EObject getDisplayableElement(EObject e) {
        while (e != null && !ContainmentServiceImpl.INSTANCE.isDisplayableElement(e)) {
            e = ContainmentServiceImpl.INSTANCE.getContainer(e);
        }
        return e;
    }

    private void executeChangeRecords(Collection changeRecords) {
        Iterator it = changeRecords.iterator();
        while (it.hasNext()) {
            ChangeRecord r = (ChangeRecord)it.next();
            if (r.isSet) {
                if (r.feature.isMany()) {
                    Collection c = (Collection)r.element.eGet(r.feature);
                    c.clear();
                    c.addAll((Collection)r.value);
                    continue;
                }
                r.element.eSet(r.feature, r.value);
                continue;
            }
            r.element.eUnset(r.feature);
        }
    }

    private static class ChangeRecord {
        public EObject element;
        public EStructuralFeature feature;
        public Object value;
        public boolean isSet;

        private ChangeRecord() {
        }
    }

    public static class FeatureChangeRecord {
        public EStructuralFeature feature;
        public Object oldValue;
        public Object newValue;
    }
}

