/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSelectionProviderAction;
import org.eclipse.ui.views.markers.internal.Util;

public class ActionOpenMarker
extends MarkerSelectionProviderAction {
    private final String IMAGE_PATH = "elcl16/gotoobj_tsk.gif";
    private final String DISABLED_IMAGE_PATH = "dlcl16/gotoobj_tsk.gif";
    protected IWorkbenchPart part;

    public ActionOpenMarker(IWorkbenchPart part, ISelectionProvider provider) {
        super(provider, MarkerMessages.openAction_title);
        this.part = part;
        this.setImageDescriptor(IDEWorkbenchPlugin.getIDEImageDescriptor("elcl16/gotoobj_tsk.gif"));
        this.setDisabledImageDescriptor(IDEWorkbenchPlugin.getIDEImageDescriptor("dlcl16/gotoobj_tsk.gif"));
        this.setEnabled(false);
    }

    public void run() {
        IMarker[] markers = this.getSelectedMarkers();
        int i = 0;
        while (i < markers.length) {
            IEditorInput input;
            IFile file;
            IMarker marker = markers[i];
            IEditorPart editor = this.part.getSite().getPage().getActiveEditor();
            if (editor != null && (file = ResourceUtil.getFile(input = editor.getEditorInput())) != null && marker.getResource().equals((Object)file)) {
                this.part.getSite().getPage().activate((IWorkbenchPart)editor);
            }
            if (marker.getResource() instanceof IFile) {
                try {
                    IFile file2 = (IFile)marker.getResource();
                    if (file2.getLocation() == null || file2.getLocationURI() == null) {
                        return;
                    }
                    IDE.openEditor(this.part.getSite().getPage(), marker, OpenStrategy.activateOnOpen());
                }
                catch (PartInitException e) {
                    CoreException nestedException = null;
                    IStatus status = e.getStatus();
                    if (status != null && status.getException() instanceof CoreException) {
                        nestedException = (CoreException)status.getException();
                    }
                    if (nestedException != null) {
                        this.reportStatus(nestedException.getStatus());
                    }
                    this.reportError(e.getLocalizedMessage());
                }
            }
            ++i;
        }
    }

    private void reportError(String message) {
        Status status = new Status(4, "org.eclipse.ui.ide", message);
        this.reportStatus((IStatus)status);
    }

    private void reportStatus(IStatus status) {
        StatusAdapter adapter = new StatusAdapter(status);
        adapter.setProperty(StatusAdapter.TITLE_PROPERTY, (Object)MarkerMessages.OpenMarker_errorTitle);
        StatusManager.getManager().handle(adapter, 2);
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(Util.allConcreteSelection(selection));
    }
}

