/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IArchiveReference;
import org.eclipse.update.core.ICategory;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentConsumer;
import org.eclipse.update.core.IFeatureFactory;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteContentProvider;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.ISiteWithMirrors;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.IVerificationListener;
import org.eclipse.update.core.IVerifier;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.ArchiveReferenceModel;
import org.eclipse.update.core.model.CategoryModel;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.core.model.URLEntryModel;
import org.eclipse.update.internal.core.FeatureTypeFactory;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.URLKey;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class Site
extends SiteModel
implements ISiteWithMirrors {
    public static final String DEFAULT_INSTALLED_FEATURE_PATH = "features/";
    public static final String DEFAULT_PLUGIN_PATH = "plugins/";
    public static final String DEFAULT_FEATURE_PATH = "features/";
    public static final String SITE_FILE = "site";
    public static final String SITE_XML = "site.xml";
    private ISiteContentProvider siteContentProvider;
    private Map featureCache = Collections.synchronizedMap(new HashMap());

    public boolean equals(Object obj) {
        if (!(obj instanceof ISite)) {
            return false;
        }
        if (this.getURL() == null) {
            return false;
        }
        ISite otherSite = (ISite)obj;
        return UpdateManagerUtils.sameURL(this.getURL(), otherSite.getURL());
    }

    public URL getURL() {
        URL url = null;
        try {
            url = this.getSiteContentProvider().getURL();
        }
        catch (CoreException e) {
            UpdateCore.warn(null, e);
        }
        return url;
    }

    public IURLEntry getDescription() {
        return (IURLEntry)((Object)this.getDescriptionModel());
    }

    public ICategory[] getCategories() {
        CategoryModel[] result = this.getCategoryModels();
        if (result.length == 0) {
            return new ICategory[0];
        }
        return (ICategory[])result;
    }

    public ICategory getCategory(String key) {
        ICategory result = null;
        boolean found = false;
        int length = this.getCategoryModels().length;
        int i = 0;
        while (i < length) {
            if (this.getCategoryModels()[i].getName().equals(key)) {
                result = (ICategory)((Object)this.getCategoryModels()[i]);
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            String URLString = this.getURL() != null ? this.getURL().toExternalForm() : "<no site url>";
            UpdateCore.warn(NLS.bind((String)Messages.Site_CannotFindCategory, (Object[])new String[]{key, URLString}));
            if (this.getCategoryModels().length <= 0) {
                UpdateCore.warn(Messages.Site_NoCategories);
            }
        }
        return result;
    }

    public ISiteFeatureReference[] getRawFeatureReferences() {
        SiteFeatureReferenceModel[] result = this.getFeatureReferenceModels();
        if (result.length == 0) {
            return new ISiteFeatureReference[0];
        }
        return (ISiteFeatureReference[])result;
    }

    public ISiteFeatureReference[] getFeatureReferences() {
        if (this.getCurrentConfiguredSite() != null) {
            return this.filterFeatures(this.getRawFeatureReferences());
        }
        return this.getRawFeatureReferences();
    }

    private ISiteFeatureReference[] filterFeatures(ISiteFeatureReference[] allIncluded) {
        ArrayList<ISiteFeatureReference> list = new ArrayList<ISiteFeatureReference>();
        if (allIncluded != null) {
            int i = 0;
            while (i < allIncluded.length) {
                ISiteFeatureReference included = allIncluded[i];
                if (UpdateManagerUtils.isValidEnvironment(included)) {
                    list.add(included);
                } else if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_WARNINGS) {
                    UpdateCore.warn("Filtered out feature reference:" + included);
                }
                ++i;
            }
        }
        ISiteFeatureReference[] result = new ISiteFeatureReference[list.size()];
        if (!list.isEmpty()) {
            list.toArray(result);
        }
        return result;
    }

    public ISiteFeatureReference getFeatureReference(IFeature feature) {
        if (feature == null) {
            UpdateCore.warn("Site:getFeatureReference: The feature is null");
            return null;
        }
        ISiteFeatureReference[] references = this.getFeatureReferences();
        ISiteFeatureReference currentReference = null;
        int i = 0;
        while (i < references.length) {
            currentReference = references[i];
            try {
                if (feature.getVersionedIdentifier().equals(currentReference.getVersionedIdentifier())) {
                    return currentReference;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
        UpdateCore.warn("Feature " + feature + " not found on site" + this.getURL());
        return null;
    }

    public IArchiveReference[] getArchives() {
        ArchiveReferenceModel[] result = this.getArchiveReferenceModels();
        if (result.length == 0) {
            return new IArchiveReference[0];
        }
        return (IArchiveReference[])result;
    }

    public ISiteContentProvider getSiteContentProvider() throws CoreException {
        if (this.siteContentProvider == null) {
            throw Utilities.newCoreException(Messages.Site_NoContentProvider, null);
        }
        return this.siteContentProvider;
    }

    public String getDefaultPackagedFeatureType() {
        return "org.eclipse.update.core.packaged";
    }

    public IPluginEntry[] getPluginEntries() {
        throw new UnsupportedOperationException();
    }

    public int getPluginEntryCount() {
        throw new UnsupportedOperationException();
    }

    public IPluginEntry[] getPluginEntriesOnlyReferencedBy(IFeature feature) throws CoreException {
        IPluginEntry[] pluginsToRemove = new IPluginEntry[]{};
        if (feature == null) {
            return pluginsToRemove;
        }
        IPluginEntry[] entries = feature.getPluginEntries();
        if (entries != null) {
            HashSet<VersionedIdentifier> allPluginID = new HashSet<VersionedIdentifier>();
            ISiteFeatureReference[] features = this.getFeatureReferences();
            if (features != null) {
                int indexFeatures = 0;
                while (indexFeatures < features.length) {
                    IPluginEntry[] pluginEntries;
                    IFeature featureToCompare = null;
                    try {
                        featureToCompare = features[indexFeatures].getFeature(null);
                    }
                    catch (CoreException e) {
                        UpdateCore.warn(null, e);
                    }
                    if (!feature.equals(featureToCompare) && (pluginEntries = features[indexFeatures].getFeature(null).getPluginEntries()) != null) {
                        int indexEntries = 0;
                        while (indexEntries < pluginEntries.length) {
                            allPluginID.add(pluginEntries[indexEntries].getVersionedIdentifier());
                            ++indexEntries;
                        }
                    }
                    ++indexFeatures;
                }
            }
            ArrayList<IPluginEntry> plugins = new ArrayList<IPluginEntry>();
            int indexPlugins = 0;
            while (indexPlugins < entries.length) {
                if (!allPluginID.contains(entries[indexPlugins].getVersionedIdentifier())) {
                    plugins.add(entries[indexPlugins]);
                }
                ++indexPlugins;
            }
            if (!plugins.isEmpty()) {
                pluginsToRemove = new IPluginEntry[plugins.size()];
                plugins.toArray(pluginsToRemove);
            }
        }
        return pluginsToRemove;
    }

    public void addPluginEntry(IPluginEntry pluginEntry) {
        throw new UnsupportedOperationException();
    }

    public long getDownloadSizeFor(IFeature feature) {
        throw new UnsupportedOperationException();
    }

    public long getInstallSizeFor(IFeature feature) {
        throw new UnsupportedOperationException();
    }

    public IFeatureReference install(IFeature sourceFeature, IVerificationListener verificationListener, IProgressMonitor progress) throws InstallAbortedException, CoreException {
        throw new UnsupportedOperationException();
    }

    public IFeatureReference install(IFeature sourceFeature, IFeatureReference[] optionalFeatures, IVerificationListener verificationListener, IProgressMonitor progress) throws InstallAbortedException, CoreException {
        throw new UnsupportedOperationException();
    }

    public IFeatureReference install(IFeature sourceFeature, IFeatureReference[] optionalFeatures, IFeatureContentConsumer parentContentConsumer, IVerifier parentVerifier, IVerificationListener verificationListener, IProgressMonitor progress) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void remove(IFeature feature, IProgressMonitor progress) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void setSiteContentProvider(ISiteContentProvider siteContentProvider) {
        this.siteContentProvider = siteContentProvider;
    }

    public IConfiguredSite getCurrentConfiguredSite() {
        return (IConfiguredSite)((Object)this.getConfiguredSiteModel());
    }

    public IFeature createFeature(String type, URL url) throws CoreException {
        return this.createFeature(type, url, null);
    }

    public IFeature createFeature(String type, URL url, IProgressMonitor monitor) throws CoreException {
        IFeatureFactory factory;
        if (url == null) {
            UpdateCore.warn("The feature URL passed is null");
            return null;
        }
        URLKey key = new URLKey(url);
        IFeature feature = (IFeature)this.featureCache.get(key);
        if (feature != null) {
            return feature;
        }
        if (type == null || type.equals("")) {
            type = this.getDefaultPackagedFeatureType();
        }
        if ((feature = (factory = FeatureTypeFactory.getInstance().getFactory(type)).createFeature(url, this, monitor)) != null) {
            this.featureCache.put(key, feature);
        }
        return feature;
    }

    protected void removeFeatureFromCache(URL featureURL) {
        URLKey key = new URLKey(featureURL);
        this.featureCache.remove(key);
    }

    public IURLEntry[] getMirrorSiteEntries() {
        URLEntryModel[] result = this.getMirrorSiteEntryModels();
        if (result.length == 0) {
            return new IURLEntry[0];
        }
        return (IURLEntry[])result;
    }
}

