/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.project.build;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.php.core.project.build.IPHPBuilderExtension;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.project.build.FullPhpProjectBuildVisitor;
import org.eclipse.php.internal.core.project.build.PhpResourceDeltaBuildVisitor;

public class DefaultPHPBuilderExtension
implements IPHPBuilderExtension {
    public boolean isEnabled() {
        return true;
    }

    public void startupOnInitialize(IncrementalProjectBuilder incrementalProjectBuilder) {
    }

    public void clean(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        this.cleanBuild(iProject.getProject());
    }

    public IProject[] build(IProject iProject, IResourceDelta iResourceDelta, int n, Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        if (n == 6) {
            this.fullBuild(iProject, iProgressMonitor);
            return null;
        }
        if (iResourceDelta == null) {
            return null;
        }
        this.buildDelta(iResourceDelta, iProgressMonitor);
        return null;
    }

    private void fullBuild(IProject iProject, IProgressMonitor iProgressMonitor) {
        try {
            iProject.accept((IResourceVisitor)new FullPhpProjectBuildVisitor(iProgressMonitor));
            PHPWorkspaceModelManager.getInstance().fireProjectModelChanged(iProject);
        }
        catch (CoreException coreException) {
            PHPCorePlugin.log(coreException);
            return;
        }
    }

    private void buildDelta(IResourceDelta iResourceDelta, IProgressMonitor iProgressMonitor) throws CoreException {
        iResourceDelta.accept((IResourceDeltaVisitor)new PhpResourceDeltaBuildVisitor(iProgressMonitor));
    }

    private void cleanBuild(IProject iProject) {
        try {
            if (!iProject.hasNature("org.eclipse.php.core.PHPNature")) {
                return;
            }
        }
        catch (CoreException coreException) {
            PHPCorePlugin.log(coreException);
            return;
        }
        PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iProject);
        if (pHPProjectModel != null) {
            pHPProjectModel.clear();
            return;
        }
    }
}

