/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editpolicies;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.FeedbackHelper;
import org.eclipse.gef.editpolicies.SelectionHandlesEditPolicy;
import org.eclipse.gef.editpolicies.StrokePointList;
import org.eclipse.gef.handles.ConnectionEndHandle;
import org.eclipse.gef.handles.ConnectionHandle;
import org.eclipse.gef.handles.ConnectionStartHandle;
import org.eclipse.gef.requests.ReconnectRequest;

public class ConnectionEndpointEditPolicy
extends SelectionHandlesEditPolicy {
    private ConnectionAnchor originalAnchor;
    private FeedbackHelper feedbackHelper;
    private ConnectionFocus focus;

    protected List createSelectionHandles() {
        ArrayList<ConnectionHandle> list = new ArrayList<ConnectionHandle>();
        list.add(new ConnectionEndHandle((ConnectionEditPart)this.getHost()));
        list.add(new ConnectionStartHandle((ConnectionEditPart)this.getHost()));
        return list;
    }

    protected void eraseConnectionMoveFeedback(ReconnectRequest request) {
        if (this.originalAnchor == null) {
            return;
        }
        if (request.isMovingStartAnchor()) {
            this.getConnection().setSourceAnchor(this.originalAnchor);
        } else {
            this.getConnection().setTargetAnchor(this.originalAnchor);
        }
        this.originalAnchor = null;
        this.feedbackHelper = null;
    }

    public void eraseSourceFeedback(Request request) {
        if ("Reconnection target".equals(request.getType()) || "Reconnection source".equals(request.getType())) {
            this.eraseConnectionMoveFeedback((ReconnectRequest)request);
        }
    }

    public Command getCommand(Request request) {
        return null;
    }

    protected Connection getConnection() {
        return (Connection)((GraphicalEditPart)this.getHost()).getFigure();
    }

    protected FeedbackHelper getFeedbackHelper(ReconnectRequest request) {
        if (this.feedbackHelper == null) {
            this.feedbackHelper = new FeedbackHelper();
            this.feedbackHelper.setConnection(this.getConnection());
            this.feedbackHelper.setMovingStartAnchor(request.isMovingStartAnchor());
        }
        return this.feedbackHelper;
    }

    protected void hideFocus() {
        if (this.focus != null) {
            this.removeFeedback((IFigure)this.focus);
            this.focus = null;
        }
    }

    protected void showConnectionMoveFeedback(ReconnectRequest request) {
        NodeEditPart node = null;
        if (request.getTarget() instanceof NodeEditPart) {
            node = (NodeEditPart)request.getTarget();
        }
        if (this.originalAnchor == null) {
            this.originalAnchor = request.isMovingStartAnchor() ? this.getConnection().getSourceAnchor() : this.getConnection().getTargetAnchor();
        }
        ConnectionAnchor anchor = null;
        if (node != null) {
            anchor = request.isMovingStartAnchor() ? node.getSourceConnectionAnchor(request) : node.getTargetConnectionAnchor(request);
        }
        FeedbackHelper helper = this.getFeedbackHelper(request);
        helper.update(anchor, request.getLocation());
    }

    protected void showFocus() {
        if (this.focus == null) {
            this.focus = new ConnectionFocus();
            this.addFeedback((IFigure)this.focus);
        }
    }

    public void showSourceFeedback(Request request) {
        if ("Reconnection source".equals(request.getType()) || "Reconnection target".equals(request.getType())) {
            this.showConnectionMoveFeedback((ReconnectRequest)request);
        }
    }

    class ConnectionFocus
    extends Polygon
    implements PropertyChangeListener {
        AncestorListener ancestorListener = new AncestorListener.Stub(this){
            final /* synthetic */ ConnectionFocus this$1;
            {
                this.this$1 = connectionFocus;
            }

            public void ancestorMoved(IFigure ancestor) {
                this.this$1.revalidate();
            }
        };

        ConnectionFocus() {
            this.setFill(false);
            this.setForegroundColor(ColorConstants.white);
            this.setXOR(true);
            this.setOutline(true);
        }

        public void addNotify() {
            super.addNotify();
            ConnectionEndpointEditPolicy.this.getConnection().addPropertyChangeListener("points", (PropertyChangeListener)this);
            ConnectionEndpointEditPolicy.this.getConnection().addAncestorListener(this.ancestorListener);
        }

        protected void outlineShape(Graphics g) {
            g.setLineDash(new int[]{1, 1});
            super.outlineShape(g);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.revalidate();
        }

        public void removeNotify() {
            ConnectionEndpointEditPolicy.this.getConnection().removePropertyChangeListener("points", (PropertyChangeListener)this);
            ConnectionEndpointEditPolicy.this.getConnection().removeAncestorListener(this.ancestorListener);
            super.removeNotify();
        }

        public void validate() {
            if (this.isValid()) {
                return;
            }
            PointList points = ConnectionEndpointEditPolicy.this.getConnection().getPoints().getCopy();
            ConnectionEndpointEditPolicy.this.getConnection().translateToAbsolute((Translatable)points);
            points = StrokePointList.strokeList(points, 5);
            this.translateToRelative((Translatable)points);
            this.setPoints(points);
        }
    }
}

