/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.converter.operations.jsf;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jst.pagedesigner.converter.ConvertPosition;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.dtmanager.converter.ITransformOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.AbstractTransformOperation;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.TransformOperationFactory;
import org.eclipse.jst.pagedesigner.jsf.core.dom.JSFDOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ColumnOperation
extends AbstractTransformOperation {
    public Element transform(Element srcElement, Element curElement) {
        Element tdElement = this.createElement("td");
        Node parentNode = srcElement.getParentNode();
        if (parentNode != null && parentNode.getNodeType() == 1 && parentNode.getLocalName().equals("dataTable")) {
            int offset;
            ArrayList<String> columnClassesList = new ArrayList<String>();
            String columnClassesAttribute = ((Element)parentNode).getAttribute("columnClasses");
            if (columnClassesAttribute != null && columnClassesAttribute.length() > 0) {
                StringTokenizer tokenizer = new StringTokenizer(columnClassesAttribute, ", ");
                while (tokenizer.hasMoreTokens()) {
                    columnClassesList.add(tokenizer.nextToken());
                }
            }
            if ((offset = EditModelQuery.getInstance().getSameTypeNodeIndex((Node)srcElement)) < columnClassesList.size()) {
                ITransformOperation operation = TransformOperationFactory.getInstance().getTransformOperation("CreateAttributeOperation", new String[]{"class", (String)columnClassesList.get(offset)});
                operation.transform(srcElement, tdElement);
            }
        }
        if (EditModelQuery.getInstance().hasNonTransparentChild((Node)srcElement, new String[]{"facet"})) {
            Node childNode = srcElement.getFirstChild();
            int index = 0;
            while (childNode != null) {
                if (!(childNode instanceof Element) || !JSFDOMUtil.isFacet((Element)childNode)) {
                    this.tagConverterContext.addChild(childNode, new ConvertPosition((Node)tdElement, index++));
                }
                childNode = childNode.getNextSibling();
            }
        } else {
            this.appendChildText(" ", tdElement);
        }
        return tdElement;
    }
}

