/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.locator;

import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.visitor.ApplyAll;

public class Locator
extends ApplyAll {
    private int offset;
    private ASTNode currentNode;

    public static Statement locateStatement(Program program, int n) {
        if (program == null || n < 0 || program.getLength() < n) {
            throw new IllegalArgumentException();
        }
        Statement[] statementArray = program.getStatements();
        int n2 = 0;
        while (n2 < statementArray.length) {
            Statement statement = statementArray[n2];
            if (Locator.inNode(statement, n)) {
                return statement;
            }
            ++n2;
        }
        return null;
    }

    public static synchronized ASTNode locateNode(Program program, int n) {
        if (program == null || !Locator.inNode(program, n)) {
            throw new IllegalArgumentException();
        }
        Locator locator = new Locator(n);
        program.accept(locator);
        return locator.currentNode;
    }

    private Locator(int n) {
        this.offset = n;
    }

    private static final boolean inNode(ASTNode aSTNode, int n) {
        return n >= aSTNode.getStart() && aSTNode.getStart() + aSTNode.getLength() >= n;
    }

    public void apply(ASTNode aSTNode) {
        assert (aSTNode != null);
        if (Locator.inNode(aSTNode, this.offset)) {
            this.currentNode = aSTNode;
            aSTNode.childrenAccept(this);
        }
    }
}

