/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.reconcile;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcileResult;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.phpModel.phpElementData.IPHPMarker;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.reconcile.ReconcileAnnotationKey;
import org.eclipse.wst.sse.ui.internal.reconcile.StructuredReconcileStep;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class ReconcileStepForPHP
extends StructuredReconcileStep {
    protected IReconcileResult[] reconcileModel(DirtyRegion dirtyRegion, IRegion iRegion) {
        IStructuredModel iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead((IDocument)this.getStructuredDocument());
        IReconcileResult[] iReconcileResultArray = this.EMPTY_RECONCILE_RESULT_SET;
        try {
            if (iStructuredModel != null) {
                DOMModelForPHP dOMModelForPHP = (DOMModelForPHP)iStructuredModel;
                dOMModelForPHP.updateFileData();
                PHPFileData pHPFileData = dOMModelForPHP.getFileData();
                if (pHPFileData == null) {
                    IReconcileResult[] iReconcileResultArray2 = this.EMPTY_RECONCILE_RESULT_SET;
                    return iReconcileResultArray2;
                }
                IPHPMarker[] iPHPMarkerArray = pHPFileData.getMarkers();
                ArrayList<IReconcileResult> arrayList = new ArrayList<IReconcileResult>();
                if (iPHPMarkerArray != null) {
                    int n = 0;
                    while (iPHPMarkerArray.length > n) {
                        IReconcileResult iReconcileResult = this.createAnnotation(iPHPMarkerArray[n]);
                        if (iReconcileResult != null) {
                            arrayList.add(iReconcileResult);
                        }
                        ++n;
                    }
                }
                iReconcileResultArray = arrayList.toArray(new IReconcileResult[arrayList.size()]);
            }
        }
        finally {
            if (iStructuredModel != null) {
                iStructuredModel.releaseFromRead();
            }
        }
        return iReconcileResultArray;
    }

    protected IReconcileResult[] createAnnotations(List list) {
        ArrayList<TemporaryAnnotation> arrayList = new ArrayList<TemporaryAnnotation>();
        int n = 0;
        while (n < list.size()) {
            block11: {
                IMessage iMessage = (IMessage)list.get(n);
                int n2 = iMessage.getOffset();
                if (n2 >= 0) {
                    String string = null;
                    try {
                        string = iMessage.getText(iMessage.getClass().getClassLoader());
                    }
                    catch (Exception exception) {
                        Logger.logException((String)"exception reporting message from validator", (Throwable)exception);
                        break block11;
                    }
                    String string2 = "org.eclipse.wst.sse.ui.temp.info";
                    switch (iMessage.getSeverity()) {
                        case 1: {
                            string2 = "org.eclipse.wst.sse.ui.temp.error";
                            break;
                        }
                        case 2: {
                            string2 = "org.eclipse.wst.sse.ui.temp.warning";
                            break;
                        }
                        case 4: {
                            string2 = "org.eclipse.wst.sse.ui.temp.warning";
                            break;
                        }
                        case 3: {
                            string2 = "org.eclipse.wst.sse.ui.temp.warning";
                        }
                    }
                    int n3 = iMessage.getLength();
                    if (n3 >= 0) {
                        Position position = new Position(n2, n3);
                        IStructuredDocument iStructuredDocument = this.getStructuredDocument();
                        ReconcileAnnotationKey reconcileAnnotationKey = this.createKey(iStructuredDocument.getRegionAtCharacterOffset(n2), 0);
                        arrayList.add(new TemporaryAnnotation(position, string2, string, reconcileAnnotationKey));
                    }
                }
            }
            ++n;
        }
        return arrayList.toArray(new IReconcileResult[arrayList.size()]);
    }

    protected IReconcileResult createAnnotation(IPHPMarker iPHPMarker) {
        String string = iPHPMarker.getDescription();
        UserData userData = iPHPMarker.getUserData();
        int n = userData.getStartPosition();
        int n2 = userData.getEndPosition();
        int n3 = n2 - n;
        LocalizedMessage localizedMessage = new LocalizedMessage(1, string);
        if (n < 0 || n3 < 0) {
            return null;
        }
        String string2 = null;
        try {
            string2 = localizedMessage.getText(localizedMessage.getClass().getClassLoader());
        }
        catch (Exception exception) {
            Logger.logException((String)"exception reporting message from validator", (Throwable)exception);
            return null;
        }
        String string3 = "org.eclipse.wst.sse.ui.temp.info";
        String string4 = iPHPMarker.getType();
        if (string4.equals("TASK")) {
            string3 = "org.eclipse.wst.sse.ui.temp.info";
        } else if (string4.equals("ERROR")) {
            string3 = "org.eclipse.wst.sse.ui.temp.error";
        } else if (string4.equals("WARNING")) {
            string3 = "org.eclipse.wst.sse.ui.temp.warning";
        }
        Position position = new Position(n, n3);
        IStructuredDocument iStructuredDocument = this.getStructuredDocument();
        ReconcileAnnotationKey reconcileAnnotationKey = this.createKey(iStructuredDocument.getRegionAtCharacterOffset(n), 0);
        return new TemporaryAnnotation(position, string3, string2, reconcileAnnotationKey);
    }
}

