/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.IStatusChangeListener;
import org.eclipse.php.internal.ui.preferences.ProjectSelectionDialog;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.php.internal.ui.util.StatusUtil;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.php.internal.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.internal.ui.wizards.fields.LayoutUtil;
import org.eclipse.php.internal.ui.wizards.fields.SelectionButtonDialogField;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PreferencesUtil;

public abstract class PropertyAndPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    protected Control fConfigurationBlockControl;
    private ControlEnableState fBlockEnableState = null;
    private Link fChangeWorkspaceSettings;
    private SelectionButtonDialogField fUseProjectSettings;
    private IStatus fBlockStatus = new StatusInfo();
    private Composite fParentComposite;
    private IProject fProject = null;
    private Map fData = null;
    public static final String DATA_NO_LINK = "PropertyAndPreferencePage.nolink";

    protected abstract Control createPreferenceContent(Composite var1);

    protected abstract boolean hasProjectSpecificOptions(IProject var1);

    protected abstract String getPreferencePageID();

    protected abstract String getPropertyPageID();

    protected boolean supportsProjectSpecificOptions() {
        return this.getPropertyPageID() != null;
    }

    protected boolean offerLink() {
        return this.fData == null || !Boolean.TRUE.equals(this.fData.get(DATA_NO_LINK));
    }

    protected Label createDescriptionLabel(Composite composite) {
        this.fParentComposite = composite;
        if (this.isProjectPreferencePage()) {
            Composite composite2 = new Composite(composite, 0);
            composite2.setFont(composite.getFont());
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            gridLayout.numColumns = 2;
            composite2.setLayout((Layout)gridLayout);
            composite2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            IDialogFieldListener iDialogFieldListener = new IDialogFieldListener(){

                public void dialogFieldChanged(DialogField dialogField) {
                    PropertyAndPreferencePage.this.enableProjectSpecificSettings(((SelectionButtonDialogField)dialogField).isSelected());
                }
            };
            this.fUseProjectSettings = new SelectionButtonDialogField(32);
            this.fUseProjectSettings.setDialogFieldListener(iDialogFieldListener);
            this.fUseProjectSettings.setLabelText(PHPUIMessages.getString("PropertyAndPreferencePage_useprojectsettings_label"));
            this.fUseProjectSettings.doFillIntoGrid(composite2, 1);
            LayoutUtil.setHorizontalGrabbing((Control)this.fUseProjectSettings.getSelectionButton(null));
            if (this.offerLink()) {
                this.fChangeWorkspaceSettings = this.createLink(composite2, PHPUIMessages.getString("PropertyAndPreferencePage_useworkspacesettings_change"));
                this.fChangeWorkspaceSettings.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
            } else {
                LayoutUtil.setHorizontalSpan((Control)this.fUseProjectSettings.getSelectionButton(null), 2);
            }
            Label label = new Label(composite2, 258);
            label.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            label.setFont(composite2.getFont());
        } else if (this.supportsProjectSpecificOptions() && this.offerLink()) {
            this.fChangeWorkspaceSettings = this.createLink(composite, PHPUIMessages.getString("PropertyAndPreferencePage_showprojectspecificsettings_label"));
            this.fChangeWorkspaceSettings.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        }
        return super.createDescriptionLabel(composite);
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setFont(composite.getFont());
        GridData gridData = new GridData(4, 4, true, true);
        this.fConfigurationBlockControl = this.createPreferenceContent(composite2);
        this.fConfigurationBlockControl.setLayoutData((Object)gridData);
        if (this.isProjectPreferencePage()) {
            boolean bl = this.hasProjectSpecificOptions(this.getProject());
            this.enableProjectSpecificSettings(bl);
        }
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private Link createLink(Composite composite, String string) {
        Link link = new Link(composite, 0);
        link.setFont(composite.getFont());
        link.setText("<A>" + string + "</A>");
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PropertyAndPreferencePage.this.doLinkActivated((Link)selectionEvent.widget);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                PropertyAndPreferencePage.this.doLinkActivated((Link)selectionEvent.widget);
            }
        });
        return link;
    }

    protected boolean useProjectSettings() {
        return this.isProjectPreferencePage() && this.fUseProjectSettings != null && this.fUseProjectSettings.isSelected();
    }

    protected boolean isProjectPreferencePage() {
        return this.fProject != null;
    }

    protected IProject getProject() {
        return this.fProject;
    }

    final void doLinkActivated(Link link) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put(DATA_NO_LINK, Boolean.TRUE);
        if (this.isProjectPreferencePage()) {
            this.openWorkspacePreferences(hashMap);
        } else {
            IProject iProject;
            Object object;
            HashSet<IProject> hashSet = new HashSet<IProject>();
            try {
                object = PHPUiPlugin.getWorkspace();
                iProject = object.getRoot().getProjects();
                int n = 0;
                while (n < ((IProject[])iProject).length) {
                    IProject iProject2 = iProject[n];
                    if (iProject2.hasNature("org.eclipse.php.core.PHPNature") && this.hasProjectSpecificOptions(iProject2.getProject())) {
                        hashSet.add(iProject2);
                    }
                    ++n;
                }
            }
            catch (CoreException coreException) {}
            object = new ProjectSelectionDialog(this.getShell(), hashSet);
            if (object.open() == 0) {
                iProject = (IProject)object.getFirstResult();
                this.openProjectProperties(iProject.getProject(), hashMap);
            }
        }
    }

    protected final void openWorkspacePreferences(Object object) {
        String string = this.getPreferencePageID();
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)string, (String[])new String[]{string}, (Object)object).open();
    }

    protected final void openProjectProperties(IProject iProject, Object object) {
        String string = this.getPropertyPageID();
        if (string != null) {
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)iProject, (String)string, (String[])new String[]{string}, (Object)object).open();
        }
    }

    protected void enableProjectSpecificSettings(boolean bl) {
        this.fUseProjectSettings.setSelection(bl);
        this.enablePreferenceContent(bl);
        this.updateLinkVisibility();
        this.doStatusChanged();
    }

    private void updateLinkVisibility() {
        if (this.fChangeWorkspaceSettings == null || this.fChangeWorkspaceSettings.isDisposed()) {
            return;
        }
        if (this.isProjectPreferencePage()) {
            this.fChangeWorkspaceSettings.setEnabled(!this.useProjectSettings());
        }
    }

    protected void setPreferenceContentStatus(IStatus iStatus) {
        this.fBlockStatus = iStatus;
        this.doStatusChanged();
    }

    protected IStatusChangeListener getNewStatusChangedListener() {
        return new IStatusChangeListener(){

            public void statusChanged(IStatus iStatus) {
                PropertyAndPreferencePage.this.setPreferenceContentStatus(iStatus);
            }
        };
    }

    protected IStatus getPreferenceContentStatus() {
        return this.fBlockStatus;
    }

    protected void doStatusChanged() {
        if (!this.isProjectPreferencePage() || this.useProjectSettings()) {
            this.updateStatus(this.fBlockStatus);
        } else {
            this.updateStatus(new StatusInfo());
        }
    }

    protected void enablePreferenceContent(boolean bl) {
        if (bl) {
            if (this.fBlockEnableState != null) {
                this.fBlockEnableState.restore();
                this.fBlockEnableState = null;
            }
        } else if (this.fBlockEnableState == null) {
            this.fBlockEnableState = ControlEnableState.disable((Control)this.fConfigurationBlockControl);
        }
    }

    protected void performDefaults() {
        if (this.useProjectSettings()) {
            this.enableProjectSpecificSettings(false);
        }
        super.performDefaults();
    }

    private void updateStatus(IStatus iStatus) {
        this.setValid(!iStatus.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, iStatus);
    }

    public void init(IWorkbench iWorkbench) {
    }

    public IAdaptable getElement() {
        return this.fProject;
    }

    public void setElement(IAdaptable iAdaptable) {
        this.fProject = (IProject)iAdaptable.getAdapter(IResource.class);
    }

    public void applyData(Object object) {
        if (object instanceof Map) {
            this.fData = (Map)object;
        }
        if (this.fChangeWorkspaceSettings != null && !this.offerLink()) {
            this.fChangeWorkspaceSettings.dispose();
            this.fParentComposite.layout(true, true);
        }
    }

    protected Map getData() {
        return this.fData;
    }
}

