/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.preferences.PHPTemplateStore;
import org.eclipse.php.internal.ui.wizards.NewPhpTemplatesWizardPage;
import org.eclipse.php.internal.ui.wizards.PHPFileCreationWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;

public class PHPFileCreationWizard
extends Wizard
implements INewWizard {
    protected PHPFileCreationWizardPage phpFileCreationWizardPage;
    protected ISelection selection;
    protected NewPhpTemplatesWizardPage newPhpTemplatesWizardPage;

    public PHPFileCreationWizard() {
        this.setWindowTitle(PHPUIMessages.getString("PHPFileCreationWizard.5"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.phpFileCreationWizardPage = new PHPFileCreationWizardPage(this.selection);
        this.addPage((IWizardPage)this.phpFileCreationWizardPage);
        this.newPhpTemplatesWizardPage = new NewPhpTemplatesWizardPage();
        this.addPage((IWizardPage)this.newPhpTemplatesWizardPage);
    }

    public boolean performFinish() {
        final String string = this.phpFileCreationWizardPage.getContainerName();
        final String string2 = this.phpFileCreationWizardPage.getFileName();
        final PHPTemplateStore.CompiledTemplate compiledTemplate = this.newPhpTemplatesWizardPage.compileTemplate();
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                try {
                    try {
                        new FileCreator().createFile(PHPFileCreationWizard.this, string, string2, iProgressMonitor, compiledTemplate.string, compiledTemplate.offset);
                    }
                    catch (CoreException coreException) {
                        throw new InvocationTargetException(coreException);
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)PHPUIMessages.getString("PHPFileCreationWizard.0"), (String)throwable.getMessage());
            return false;
        }
        return true;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.selection = iStructuredSelection;
    }

    public static class FileCreator {
        public void createFile(Wizard wizard, String string, String string2, IProgressMonitor iProgressMonitor, String string3) throws CoreException {
            this.createFile(wizard, string, string2, iProgressMonitor, string3, 0, null);
        }

        public void createFile(Wizard wizard, String string, String string2, IProgressMonitor iProgressMonitor, String string3, int n) throws CoreException {
            this.createFile(wizard, string, string2, iProgressMonitor, string3, n, null);
        }

        public void createFile(Wizard wizard, String string, String string2, IProgressMonitor iProgressMonitor, String string3, final int n, final String string4) throws CoreException {
            iProgressMonitor.beginTask(NLS.bind((String)PHPUIMessages.getString("newPhpFile_create"), (Object)string2), 2);
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IResource iResource = iWorkspaceRoot.findMember((IPath)new Path(string));
            if (!iResource.exists() || !(iResource instanceof IContainer)) {
                FileCreator.throwCoreException(String.valueOf(PHPUIMessages.getString("PHPFileCreationWizard.1")) + string + PHPUIMessages.getString("PHPFileCreationWizard.2"));
            }
            IContainer iContainer = (IContainer)iResource;
            final IFile iFile = iContainer.getFile((IPath)new Path(string2));
            String string5 = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, new IScopeContext[]{new ProjectScope(iContainer.getProject())});
            if (string5 == null) {
                string5 = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, new IScopeContext[]{new InstanceScope()});
            }
            if (string5 == null) {
                string5 = System.getProperty("line.separator");
            }
            if (string3 != null) {
                string3 = string3.replaceAll("(\n\r?|\r\n?)", string5);
            }
            try {
                InputStream inputStream = FileCreator.openContentStream(string3);
                if (iFile.exists()) {
                    iFile.setContents(inputStream, true, true, iProgressMonitor);
                } else {
                    iFile.create(inputStream, true, iProgressMonitor);
                }
                inputStream.close();
            }
            catch (IOException iOException) {
                Logger.logException(iOException);
                return;
            }
            iProgressMonitor.worked(1);
            iProgressMonitor.setTaskName(NLS.bind((String)PHPUIMessages.getString("newPhpFile_openning"), (Object)string2));
            wizard.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        IEditorPart iEditorPart = string4 == null ? IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)true) : IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (String)string4, (boolean)true);
                        if (iEditorPart instanceof PHPStructuredEditor) {
                            StructuredTextViewer structuredTextViewer = ((PHPStructuredEditor)iEditorPart).getTextViewer();
                            structuredTextViewer.setSelectedRange(n, 0);
                        }
                        FileCreator.this.normalizeFile(iFile);
                    }
                    catch (PartInitException partInitException) {}
                }
            });
            iProgressMonitor.worked(1);
        }

        private static InputStream openContentStream(String string) {
            if (string == null) {
                string = "";
            }
            return new ByteArrayInputStream(string.getBytes());
        }

        private static void throwCoreException(String string) throws CoreException {
            Status status = new Status(4, PHPUIMessages.getString("PHPFileCreationWizard.4"), 0, string, null);
            throw new CoreException((IStatus)status);
        }

        protected void normalizeFile(IFile iFile) {
        }
    }
}

