/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.UntitledPHPEditor;
import org.eclipse.php.internal.ui.editor.input.NonExistingPHPFileEditorInput;
import org.eclipse.php.internal.ui.preferences.PHPTemplateStore;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class UntitledPHPDocumentWizard
extends Wizard
implements INewWizard {
    private IWorkbenchWindow fWindow;
    private static final String UNTITLED_EDITOR_ID = "org.eclipse.php.untitledPhpEditor";
    private static final String UNTITLED_FOLDER_PATH = "/Untitled_Documents";
    private static final String UNTITLED_PHP_DOC_PREFIX = "PHPDocument";

    public UntitledPHPDocumentWizard() {
    }

    public UntitledPHPDocumentWizard(IWorkbenchWindow iWorkbenchWindow) {
        this.fWindow = iWorkbenchWindow;
    }

    public void dispose() {
        this.fWindow = null;
    }

    public boolean performFinish() {
        Template template;
        UntitledPHPEditor untitledPHPEditor;
        block9: {
            String string;
            block8: {
                block7: {
                    IPath iPath = PHPUiPlugin.getDefault().getStateLocation();
                    IPath iPath2 = iPath.append(UNTITLED_FOLDER_PATH);
                    IFileStore iFileStore = EFS.getLocalFileSystem().getStore(iPath2);
                    NonExistingPHPFileEditorInput nonExistingPHPFileEditorInput = new NonExistingPHPFileEditorInput(iFileStore, UNTITLED_PHP_DOC_PREFIX);
                    File file = nonExistingPHPFileEditorInput.getPath().toFile();
                    file.deleteOnExit();
                    IWorkbenchPage iWorkbenchPage = this.fWindow.getActivePage();
                    IEditorPart iEditorPart = iWorkbenchPage.openEditor((IEditorInput)nonExistingPHPFileEditorInput, UNTITLED_EDITOR_ID);
                    untitledPHPEditor = null;
                    if (iEditorPart instanceof UntitledPHPEditor) {
                        untitledPHPEditor = (UntitledPHPEditor)iEditorPart;
                    }
                    PHPWorkspaceModelManager.getInstance().getModelForFile(file.getAbsolutePath());
                    if (untitledPHPEditor != null) break block7;
                    return true;
                }
                string = PHPUiPlugin.getDefault().getPreferenceStore().getString("newFileTemplateName");
                if (string != null && string.length() != 0) break block8;
                return true;
            }
            TemplateStore templateStore = PHPUiPlugin.getDefault().getTemplateStore();
            template = templateStore.findTemplate(string);
            if (template != null) break block9;
            return true;
        }
        try {
            PHPTemplateStore.CompiledTemplate compiledTemplate = PHPTemplateStore.compileTemplate(PHPUiPlugin.getDefault().getTemplateContextRegistry(), template);
            IDocumentProvider iDocumentProvider = untitledPHPEditor.getDocumentProvider();
            IDocument iDocument = untitledPHPEditor.getDocument();
            iDocument.set(compiledTemplate.string);
            iDocumentProvider.saveDocument(null, (Object)untitledPHPEditor.getEditorInput(), iDocument, true);
            untitledPHPEditor.selectAndReveal(compiledTemplate.offset, 0);
        }
        catch (PartInitException partInitException) {
            Logger.logException(partInitException);
            return false;
        }
        catch (CoreException coreException) {
            Logger.logException(coreException);
            return false;
        }
        return true;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.fWindow = iWorkbench.getActiveWorkbenchWindow();
    }
}

