/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.help.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.help.IToc;
import org.eclipse.help.ITocContribution;
import org.eclipse.help.ITopic;
import org.eclipse.help.IUAElement;
import org.eclipse.help.internal.Topic;
import org.eclipse.help.internal.toc.TocFileProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpContextGenerator {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String INVALID_LABEL_CHARS = "[^a-zA-Z$\\d]";
    private static final String INVALID_CHAR_REPLACEMENT = "_";
    private static final String PHP_CONTRIBUTOR_ID = "org.eclipse.php.help";
    private static final String JAVA_HELP_CONTEXT_TEMPLATE = "template.txt";
    private static final String JAVA_HELP_CONTEXT_NAME = "IPHPHelpContextIds.java";
    private static final String HELP_CONTEXT_FILE = "helpContexts.xml";
    private static final String DESCRIPTION_POSTFIX = " Help";
    private static final String CONTEXT_BLOCK = "\t<context id=\"%1$s\">" + NEW_LINE + "\t\t<description>%2$s</description>" + NEW_LINE + "\t\t<topic href=\"%3$s\" label=\"%4$s\"/>" + NEW_LINE + "\t</context>" + NEW_LINE;
    private static final String JAVA_CONSTANT_LINE = "public static final String %1$s = PREFIX + \"%2$s\"; //$NON-NLS-1$ [%3$s]" + NEW_LINE;
    private LinkedHashSet<String> topics = new LinkedHashSet();

    public void run() {
        TocFileProvider tocFileProvider = new TocFileProvider();
        ITocContribution[] iTocContributionArray = tocFileProvider.getTocContributions(null);
        ArrayList<ITocContribution> arrayList = new ArrayList<ITocContribution>();
        ITocContribution[] iTocContributionArray2 = iTocContributionArray;
        int n = iTocContributionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITocContribution iTocContribution = iTocContributionArray2[n2];
            if (!iTocContribution.isPrimary() && PHP_CONTRIBUTOR_ID.equals(iTocContribution.getContributorId())) {
                arrayList.add(iTocContribution);
            }
            ++n2;
        }
        try {
            this.generateFiles(arrayList);
        }
        catch (Exception exception) {}
    }

    private void generateFiles(ArrayList<ITocContribution> arrayList) throws Exception {
        File file = this.getJavaTemplateFile();
        File file2 = new File(file.getParent(), HELP_CONTEXT_FILE);
        File file3 = new File(file.getParent(), JAVA_HELP_CONTEXT_NAME);
        StringBuilder stringBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + NEW_LINE + "<!-- Auto generated using the HelpContextGenerator -->" + NEW_LINE + "<contexts>" + NEW_LINE);
        StringBuilder stringBuilder2 = new StringBuilder();
        this.loadJavaTemplate(stringBuilder2, file);
        for (ITocContribution iTocContribution : arrayList) {
            IToc iToc = iTocContribution.getToc();
            IUAElement[] iUAElementArray = iToc.getChildren();
            this.writeElements(iUAElementArray, stringBuilder, stringBuilder2, 1);
        }
        stringBuilder2.append('}');
        stringBuilder.append("</contexts>");
        this.writeFile(file2, stringBuilder.toString());
        this.writeFile(file3, stringBuilder2.toString());
    }

    private void writeElements(IUAElement[] iUAElementArray, StringBuilder stringBuilder, StringBuilder stringBuilder2, int n) {
        IUAElement[] iUAElementArray2 = iUAElementArray;
        int n2 = iUAElementArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IUAElement iUAElement = iUAElementArray2[n3];
            if (iUAElement instanceof ITopic) {
                ITopic[] iTopicArray;
                ITopic iTopic = (ITopic)iUAElement;
                String string = iTopic.getHref();
                String string2 = iTopic.getLabel();
                String string3 = this.cleanLabel(string2).toLowerCase();
                String string4 = string3;
                if (Character.isDigit(string4.charAt(0))) {
                    string4 = String.valueOf('_') + string4;
                }
                if (this.topics.contains(string4)) {
                    iTopicArray = (ITopic[])((Topic)iTopic).getParentElement();
                    String string5 = this.cleanLabel(iTopicArray.getLabel()).toLowerCase();
                    if (Character.isDigit(string5.charAt(0))) {
                        string5 = String.valueOf('_') + string5;
                    }
                    string4 = String.valueOf(string5) + string4;
                }
                this.topics.add(string4);
                int n4 = 0;
                while (n4 < n) {
                    stringBuilder2.append('\t');
                    ++n4;
                }
                stringBuilder2.append(String.format(JAVA_CONSTANT_LINE, string4.toUpperCase(), string3, string));
                stringBuilder.append(String.format(CONTEXT_BLOCK, string3, String.valueOf(string2) + DESCRIPTION_POSTFIX, string, string2));
                iTopicArray = iTopic.getSubtopics();
                if (iTopicArray != null && iTopicArray.length > 0) {
                    this.writeElements((IUAElement[])iTopicArray, stringBuilder, stringBuilder2, n + 1);
                }
            }
            ++n3;
        }
    }

    private String cleanLabel(String string) {
        return string.replaceAll(INVALID_LABEL_CHARS, INVALID_CHAR_REPLACEMENT);
    }

    private void loadJavaTemplate(StringBuilder stringBuilder, File file) throws IOException {
        String string = null;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string);
            stringBuilder.append(NEW_LINE);
        }
    }

    private void writeFile(File file, String string) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        try {
            bufferedWriter.write(string);
            bufferedWriter.flush();
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
    }

    private File getJavaTemplateFile() throws IOException {
        URL uRL = this.getClass().getResource(JAVA_HELP_CONTEXT_TEMPLATE);
        File file = new File(URLDecoder.decode(uRL.getFile(), "UTF-8"));
        if (!file.exists()) {
            file = new File(URLDecoder.decode(FileLocator.toFileURL((URL)uRL).getFile(), "UTF-8"));
        }
        String string = file.toString().replace(String.valueOf(File.separatorChar) + "bin" + File.separatorChar, String.valueOf(File.separatorChar) + "src" + File.separatorChar);
        file = new File(string);
        return file;
    }
}

