/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.documentModel.parser;

import org.eclipse.core.resources.IProject;
import org.eclipse.php.internal.core.project.properties.handlers.PhpVersionProjectPropertyHandler;

public class PHPLexerStates {
    private static final int BASE = 100;
    public static final int ST_PHP_IN_SCRIPTING = 100;
    public static final int ST_PHP_LINE_COMMENT = 101;
    private static final int SIZE = 100;
    private static int[] unifiedToVersioned4 = new int[100];
    private static int[] versionedToUnified4 = new int[100];
    private static int[] unifiedToVersioned5 = new int[100];
    private static int[] versionedToUnified5 = new int[100];

    static {
        PHPLexerStates.buildHash();
    }

    public static int toUniversalState(IProject iProject, int n) {
        assert (n < 100) : "State provided is not version dependent state";
        if (n == -1) {
            return -1;
        }
        String string = PhpVersionProjectPropertyHandler.getVersion(iProject);
        if (string.equals("php5")) {
            return versionedToUnified5[n];
        }
        return versionedToUnified4[n];
    }

    public static int toSpecificVersionState(IProject iProject, int n) {
        assert (n >= 100) : "State provided is not universal state";
        String string = PhpVersionProjectPropertyHandler.getVersion(iProject);
        if (string.equals("php5")) {
            return unifiedToVersioned5[n - 100];
        }
        return unifiedToVersioned4[n - 100];
    }

    private static void buildHash() {
        int n = 0;
        while (n < 100) {
            PHPLexerStates.unifiedToVersioned4[n] = -1;
            PHPLexerStates.versionedToUnified4[n] = -1;
            PHPLexerStates.unifiedToVersioned5[n] = -1;
            PHPLexerStates.versionedToUnified5[n] = -1;
            ++n;
        }
        PHPLexerStates.unifiedToVersioned5[0] = 1;
        PHPLexerStates.unifiedToVersioned5[1] = 12;
        PHPLexerStates.versionedToUnified5[1] = 100;
        PHPLexerStates.versionedToUnified5[12] = 101;
        PHPLexerStates.unifiedToVersioned4[0] = 2;
        PHPLexerStates.unifiedToVersioned4[1] = 20;
        PHPLexerStates.versionedToUnified4[2] = 100;
        PHPLexerStates.versionedToUnified4[20] = 101;
    }
}

