/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.php.core.documentModel.IWorkspaceModelListener;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.core.phpModel.parser.CompositePhpModel;
import org.eclipse.php.internal.core.phpModel.parser.ExternalFilesModel;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.IncludePathModelListener;
import org.eclipse.php.internal.core.phpModel.parser.PHPIncludePathModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPLanguageManager;
import org.eclipse.php.internal.core.phpModel.parser.PHPLanguageManagerProvider;
import org.eclipse.php.internal.core.phpModel.parser.PHPParserManager;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPUserModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.parser.ParserClient;
import org.eclipse.php.internal.core.phpModel.parser.PhpModelProxy;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.internal.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.internal.core.preferences.PreferencesSupport;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.options.IPhpProjectOptionChangeListener;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.core.project.properties.handlers.PhpVersionChangedHandler;
import org.eclipse.php.internal.core.project.properties.handlers.PhpVersionProjectPropertyHandler;
import org.eclipse.php.internal.core.project.properties.handlers.UseAspTagsHandler;
import org.eclipse.php.internal.core.util.DefaultCacheManager;
import org.eclipse.php.internal.core.util.IncludeCacheManager;

public class PHPIncludePathModelManager
extends PhpModelProxy
implements ExternalFilesModel {
    public static final String COMPOSITE_INCLUDE_PATH_MODEL_ID = "CompositeIncludePathModel";
    CompositePhpModel compositePhpModel = new CompositePhpModel(){

        public String getID() {
            return PHPIncludePathModelManager.COMPOSITE_INCLUDE_PATH_MODEL_ID;
        }

        public void initialize(IProject iProject) {
        }
    };
    private PHPParserManager parserManager;
    private String phpVersion;
    private ArrayList libraries;
    private ArrayList projects;
    private ArrayList variables;
    private String[] validExtensions;
    private IncludePathListener includePathListener;
    private PhpVersionListener phpVersionListener;
    private IProject project;
    private HashMap modelsToCache;
    private IncludeCacheManager includeCacheManager;
    private boolean initialized;
    private IResourceChangeListener projectResourcesListener;
    private List<IncludePathModelListener> modelListeners;

    public PHPIncludePathModelManager() {
        this.model = this.compositePhpModel;
        this.libraries = new ArrayList();
        this.projects = new ArrayList();
        this.variables = new ArrayList();
        this.modelsToCache = new HashMap();
    }

    public void addIncludePathModelListener(IncludePathModelListener includePathModelListener) {
        if (this.modelListeners == null) {
            this.modelListeners = new ArrayList<IncludePathModelListener>(1);
            this.modelListeners.add(includePathModelListener);
        } else if (!this.modelListeners.contains(includePathModelListener)) {
            this.modelListeners.add(includePathModelListener);
        }
    }

    public void removeIncludePathModelListener(IncludePathModelListener includePathModelListener) {
        if (this.modelListeners == null) {
            return;
        }
        this.modelListeners.remove(includePathModelListener);
    }

    public IPhpModel getModel(String string) {
        return this.compositePhpModel.getModel(string);
    }

    public void initialize(IProject iProject) {
        if (this.initialized) {
            if (iProject != this.project) {
                PHPCorePlugin.logErrorMessage("PHPIncludePathModelManager in already initialized with a different project.");
            }
            return;
        }
        this.includeCacheManager = DefaultCacheManager.instance().getIncludeCacheManager();
        this.project = iProject;
        this.initListeners();
        this.setPHPVersion(PhpVersionProjectPropertyHandler.getVersion(iProject));
        PHPProjectOptions pHPProjectOptions = PHPProjectOptions.forProject(iProject);
        if (pHPProjectOptions == null) {
            return;
        }
        IIncludePathEntry[] iIncludePathEntryArray = pHPProjectOptions.readRawIncludePath();
        this.loadChanges(iIncludePathEntryArray);
        ArrayList arrayList = new ArrayList(this.variables);
        arrayList.addAll(this.libraries);
        this.includeCacheManager.includePathChanged(iProject, this.getAsCachedNames(arrayList));
        this.initialized = true;
    }

    public IPhpModel[] listModels() {
        return this.compositePhpModel.getModels();
    }

    private void addLibrary(File file) {
        if (this.getIndexOf(file) != -1) {
            return;
        }
        this.libraries.add(file);
        this.innerAddLibrary(file);
    }

    private void fireModelAdded(IPhpModel iPhpModel) {
        if (this.modelListeners == null) {
            return;
        }
        for (IncludePathModelListener includePathModelListener : this.modelListeners) {
            includePathModelListener.includeModelAdded(iPhpModel);
        }
    }

    private void innerAddLibrary(File file) {
        PHPIncludePathModel pHPIncludePathModel = new PHPIncludePathModel(file.getPath(), PHPIncludePathModel.IncludePathModelType.LIBRARY);
        PHPLanguageManager pHPLanguageManager = PHPLanguageManagerProvider.instance().getPHPLanguageManager(this.phpVersion);
        ParserClient parserClient = pHPLanguageManager.createParserClient(pHPIncludePathModel, this.project);
        this.updateExtentionList();
        if (file.exists()) {
            PHPIncludePathModel pHPIncludePathModel2 = new PHPIncludePathModel(file.getPath(), PHPIncludePathModel.IncludePathModelType.LIBRARY);
            DefaultCacheManager.instance().load(this.project, pHPIncludePathModel2, true);
            this.recursiveParse(file, parserClient, pHPIncludePathModel, pHPIncludePathModel2);
        }
        this.compositePhpModel.addModel(pHPIncludePathModel);
        this.fireModelAdded(pHPIncludePathModel);
    }

    private void recursiveParse(File file, ParserClient parserClient, PHPIncludePathModel pHPIncludePathModel, PHPIncludePathModel pHPIncludePathModel2) {
        if (file == null) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray2[n2];
            if (file2.isDirectory()) {
                this.recursiveParse(file2, parserClient, pHPIncludePathModel, pHPIncludePathModel2);
            } else if (file2.isFile() && this.isPhpFile(file2.getName())) {
                String string = file2.getPath();
                PHPFileData pHPFileData = pHPIncludePathModel2.getFileData(string);
                if (this.isValid(pHPFileData, file2)) {
                    pHPIncludePathModel.insert(pHPFileData);
                    pHPIncludePathModel2.delete(string);
                } else {
                    this.modelsToCache.put(pHPIncludePathModel, pHPIncludePathModel);
                    this.parse(file2, parserClient);
                }
            }
            ++n2;
        }
    }

    private boolean isValid(PHPFileData pHPFileData, File file) {
        if (pHPFileData != null && file != null) {
            return pHPFileData.getCreationTimeLastModified() - file.lastModified() >= 0L;
        }
        return false;
    }

    private void parse(File file, ParserClient parserClient) {
        try {
            FileReader fileReader = new FileReader(file);
            this.parserManager.parseNow(fileReader, file.getPath(), file.lastModified(), parserClient, new Pattern[0], UseAspTagsHandler.useAspTagsAsPhp(this.project));
        }
        catch (FileNotFoundException fileNotFoundException) {
            PHPCorePlugin.log(fileNotFoundException);
            return;
        }
    }

    private boolean isPhpFile(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n + 1);
        String[] stringArray = this.validExtensions;
        int n2 = this.validExtensions.length;
        int n3 = 0;
        while (n3 < n2) {
            String string3 = stringArray[n3];
            if (string2.equals(string3)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    private void removeLibrary(File file) {
        int n = this.getIndexOf(file);
        if (n == -1) {
            return;
        }
        this.libraries.remove(n);
        this.innerRemoveLibrary(file);
    }

    private void innerRemoveLibrary(File file) {
        IPhpModel iPhpModel = this.compositePhpModel.remove(file.getPath());
        if (iPhpModel != null) {
            this.modelsToCache.remove(iPhpModel);
            this.fireModelRemoved(iPhpModel);
        }
    }

    private void fireModelRemoved(IPhpModel iPhpModel) {
        if (this.modelListeners == null) {
            return;
        }
        for (IncludePathModelListener includePathModelListener : this.modelListeners) {
            includePathModelListener.includeModelRemoved(this.model);
        }
    }

    private void updatePHPVersion(String string, String string2) {
        IPhpModel[] iPhpModelArray;
        this.setPHPVersion(string2);
        this.includeCacheManager.phpVersionChanged(this.project, string, string2);
        DefaultCacheManager defaultCacheManager = DefaultCacheManager.instance();
        IPhpModel[] iPhpModelArray2 = iPhpModelArray = this.compositePhpModel.getModels();
        int n = iPhpModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPhpModel iPhpModel = iPhpModelArray2[n2];
            File file = defaultCacheManager.getSharedCacheFile(string2, iPhpModel.getID());
            if (!file.exists()) {
                this.modelsToCache.put(iPhpModel, iPhpModel);
            } else {
                this.modelsToCache.remove(iPhpModel);
            }
            ++n2;
        }
    }

    private void setPHPVersion(String string) {
        this.phpVersion = string;
        PHPLanguageManager pHPLanguageManager = PHPLanguageManagerProvider.instance().getPHPLanguageManager(this.phpVersion);
        this.parserManager = pHPLanguageManager.createPHPParserManager();
    }

    private int getIndexOf(File file) {
        int n = 0;
        String string = file.getPath();
        for (File file2 : this.libraries) {
            if (file2.getPath().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void includePathChanged(IPath[] iPathArray) {
        File[] fileArray = new File[iPathArray.length];
        int n = 0;
        while (n < iPathArray.length) {
            fileArray[n] = new File(iPathArray[n].toString());
            this.addLibrary(fileArray[n]);
            ++n;
        }
        ArrayList arrayList = this.libraries;
        File[] fileArray2 = new File[arrayList.size()];
        arrayList.toArray(fileArray2);
        File[] fileArray3 = fileArray2;
        int n2 = fileArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            File file = fileArray3[n3];
            String string = file.getPath();
            boolean bl = false;
            File[] fileArray4 = fileArray;
            int n4 = fileArray.length;
            int n5 = 0;
            while (n5 < n4) {
                File file2 = fileArray4[n5];
                if (file2.getPath().equals(string)) {
                    bl = true;
                    break;
                }
                ++n5;
            }
            if (!bl) {
                this.removeLibrary(file);
            }
            ++n3;
        }
    }

    private void projectListChanged(IResource[] iResourceArray) {
        IResource[] iResourceArray2;
        IResource[] iResourceArray3 = iResourceArray;
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            iResourceArray2 = iResourceArray3[n2];
            this.addProject((IResource)iResourceArray2);
            ++n2;
        }
        iResourceArray2 = new IResource[this.projects.size()];
        this.projects.toArray(iResourceArray2);
        IResource[] iResourceArray4 = iResourceArray2;
        int n3 = iResourceArray2.length;
        n = 0;
        while (n < n3) {
            IResource iResource = iResourceArray4[n];
            String string = iResource.getName();
            boolean bl = false;
            IResource[] iResourceArray5 = iResourceArray;
            int n4 = iResourceArray.length;
            int n5 = 0;
            while (n5 < n4) {
                IResource iResource2 = iResourceArray5[n5];
                if (iResource2.getName().equals(string)) {
                    bl = true;
                    break;
                }
                ++n5;
            }
            if (!bl) {
                this.removeProject(iResource);
            }
            ++n;
        }
    }

    private void addProject(IResource iResource) {
        if (this.getIndexOf(iResource) != -1) {
            return;
        }
        this.projects.add(iResource);
        this.innerAddProject((IProject)iResource);
    }

    private void innerAddProject(IProject iProject) {
        PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iProject);
        IPhpModel iPhpModel = null;
        iPhpModel = pHPProjectModel == null ? new PHPUserModel() : pHPProjectModel.getModel(PHPUserModel.ID);
        ModelWrapper modelWrapper = new ModelWrapper(iPhpModel);
        modelWrapper.initialize(iProject);
        this.compositePhpModel.addModel(modelWrapper);
    }

    public boolean removeProject(IResource iResource) {
        int n = this.getIndexOf(iResource);
        if (n == -1) {
            return false;
        }
        this.projects.remove(n);
        this.innerRemoveProject(iResource);
        return true;
    }

    private void innerRemoveProject(IResource iResource) {
        IPhpModel iPhpModel = this.compositePhpModel.remove(iResource.getName());
        ((ModelWrapper)iPhpModel).dispose();
    }

    private int getIndexOf(IResource iResource) {
        int n = 0;
        String string = iResource.getName();
        for (IResource iResource2 : this.projects) {
            if (iResource2.getName().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void updateExtentionList() {
        IContentType iContentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
        this.validExtensions = iContentType.getFileSpecs(8);
    }

    private void initListeners() {
        PHPProjectOptions pHPProjectOptions = PHPProjectOptions.forProject(this.project);
        if (pHPProjectOptions == null) {
            return;
        }
        this.includePathListener = new IncludePathListener();
        pHPProjectOptions.addOptionChangeListener("org.eclipse.php.core.includePath", this.includePathListener);
        this.phpVersionListener = new PhpVersionListener();
        PhpVersionChangedHandler.getInstance().addPhpVersionChangedListener(this.phpVersionListener);
        if (this.projectResourcesListener == null) {
            this.projectResourcesListener = new ProjectResourceChangeListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.projectResourcesListener, 1);
        }
    }

    public void dispose() {
        super.dispose();
        PHPProjectOptions pHPProjectOptions = PHPProjectOptions.forProject(this.project);
        if (pHPProjectOptions != null) {
            pHPProjectOptions.removeOptionChangeListener("org.eclipse.php.core.includePath", this.includePathListener);
        }
        PhpVersionChangedHandler.getInstance().removePhpVersionChangedListener(this.phpVersionListener);
        IPath iPath = this.project.getLocation();
        if (iPath != null) {
            for (IPhpModel iPhpModel : this.modelsToCache.keySet()) {
                DefaultCacheManager.instance().save(this.project, iPhpModel, true);
            }
        }
    }

    public void clear() {
        this.rebuild();
    }

    private void rebuild() {
        this.rebuildList(this.libraries);
        this.rebuildVariablesList();
    }

    private void rebuildList(ArrayList arrayList) {
        for (File file : arrayList) {
            this.innerRemoveLibrary(file);
            this.innerAddLibrary(file);
        }
    }

    private void rebuildVariablesList() {
        for (IPath iPath : this.variables) {
            this.innerRemoveVariable(iPath);
            this.innerAddVariable(iPath);
        }
    }

    private void loadChanges(IIncludePathEntry[] iIncludePathEntryArray) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        IIncludePathEntry[] iIncludePathEntryArray2 = iIncludePathEntryArray;
        int n = iIncludePathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = iIncludePathEntryArray2[n2];
            if (object.getEntryKind() == 1) {
                if (object.getContentKind() != 2) {
                    arrayList.add(object);
                }
            } else if (object.getEntryKind() == 2) {
                if (object.getResource() != null) {
                    arrayList2.add(object);
                }
            } else if (object.getEntryKind() == 4) {
                arrayList3.add(object);
            }
            ++n2;
        }
        object = new IPath[arrayList.size()];
        n2 = 0;
        while (n2 < arrayList.size()) {
            object[n2] = ((IIncludePathEntry)arrayList.get(n2)).getPath();
            ++n2;
        }
        this.includePathChanged((IPath[])object);
        IResource[] iResourceArray = new IResource[arrayList2.size()];
        n = 0;
        while (n < arrayList2.size()) {
            iResourceArray[n] = ((IIncludePathEntry)arrayList2.get(n)).getResource();
            ++n;
        }
        this.projectListChanged(iResourceArray);
        IPath[] iPathArray = new IPath[arrayList3.size()];
        int n3 = 0;
        while (n3 < arrayList3.size()) {
            iPathArray[n3] = ((IIncludePathEntry)arrayList3.get(n3)).getPath();
            ++n3;
        }
        this.variablesListChanged(iPathArray);
    }

    private void variablesListChanged(IPath[] iPathArray) {
        IPath[] iPathArray2;
        IPath[] iPathArray3 = iPathArray;
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            iPathArray2 = iPathArray3[n2];
            this.addVariable((IPath)iPathArray2);
            ++n2;
        }
        iPathArray2 = new IPath[this.variables.size()];
        this.variables.toArray(iPathArray2);
        IPath[] iPathArray4 = iPathArray2;
        int n3 = iPathArray2.length;
        n = 0;
        while (n < n3) {
            IPath iPath = iPathArray4[n];
            boolean bl = false;
            IPath[] iPathArray5 = iPathArray;
            int n4 = iPathArray.length;
            int n5 = 0;
            while (n5 < n4) {
                IPath iPath2 = iPathArray5[n5];
                if (iPath2.equals((Object)iPath)) {
                    bl = true;
                    break;
                }
                ++n5;
            }
            if (!bl) {
                this.removeVariable(iPath);
            }
            ++n;
        }
        if (this.initialized) {
            ArrayList arrayList = new ArrayList(this.variables);
            arrayList.addAll(this.libraries);
            this.includeCacheManager.includePathChanged(this.project, this.getAsCachedNames(arrayList));
        }
    }

    private List getAsCachedNames(List list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        DefaultCacheManager defaultCacheManager = DefaultCacheManager.instance();
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            if (e instanceof File) {
                arrayList.add(defaultCacheManager.getSharedCacheFile(this.project, ((File)e).getPath()).getName());
            } else if (e instanceof IPath) {
                arrayList.add(defaultCacheManager.getSharedCacheFile(this.project, ((IPath)e).toFile().getPath()).getName());
            }
            ++n;
        }
        return arrayList;
    }

    private void addVariable(IPath iPath) {
        if (this.variables.indexOf(iPath) != -1) {
            return;
        }
        this.variables.add(iPath);
        this.innerAddVariable(iPath);
    }

    private void innerAddVariable(IPath iPath) {
        this.updateExtentionList();
        String string = iPath.toString();
        PHPIncludePathModel pHPIncludePathModel = new PHPIncludePathModel(string, PHPIncludePathModel.IncludePathModelType.VARIABLE);
        PHPLanguageManager pHPLanguageManager = PHPLanguageManagerProvider.instance().getPHPLanguageManager(this.phpVersion);
        ParserClient parserClient = pHPLanguageManager.createParserClient(pHPIncludePathModel, this.project);
        File file = this.getVriableFile(string);
        if (file != null) {
            if (file.isDirectory()) {
                PHPIncludePathModel pHPIncludePathModel2 = new PHPIncludePathModel(string, PHPIncludePathModel.IncludePathModelType.VARIABLE);
                DefaultCacheManager.instance().load(this.project, pHPIncludePathModel2, true);
                this.recursiveParse(file, parserClient, pHPIncludePathModel, pHPIncludePathModel2);
            } else {
                String string2 = file.getName();
                if (this.isPhpFile(string2)) {
                    PHPIncludePathModel pHPIncludePathModel3 = new PHPIncludePathModel(string, PHPIncludePathModel.IncludePathModelType.VARIABLE);
                    DefaultCacheManager.instance().load(this.project, pHPIncludePathModel3, true);
                    PHPFileData pHPFileData = pHPIncludePathModel3.getFileData(string2);
                    if (this.isValid(pHPFileData, file)) {
                        pHPIncludePathModel.insert(pHPFileData);
                        pHPIncludePathModel3.delete(string2);
                    } else {
                        this.modelsToCache.put(pHPIncludePathModel, pHPIncludePathModel);
                        this.parse(file, parserClient);
                    }
                }
            }
        }
        this.compositePhpModel.addModel(pHPIncludePathModel);
        this.fireModelAdded(pHPIncludePathModel);
    }

    private File getVriableFile(String string) {
        IPath iPath;
        int n = string.indexOf(47);
        String string2 = "";
        if (n != -1) {
            if (n + 1 < string.length()) {
                string2 = string.substring(n + 1);
            }
            string = string.substring(0, n);
        }
        if ((iPath = PHPProjectOptions.getIncludePathVariable(string)) == null) {
            return null;
        }
        iPath = iPath.append(string2);
        return iPath.toFile();
    }

    private void removeVariable(IPath iPath) {
        if (this.variables.remove(iPath)) {
            this.innerRemoveVariable(iPath);
        }
    }

    private void innerRemoveVariable(IPath iPath) {
        IPhpModel iPhpModel = this.compositePhpModel.remove(iPath.toString());
        if (iPhpModel != null) {
            this.fireModelRemoved(iPhpModel);
        }
    }

    public Object getExternalResource(PHPFileData pHPFileData) {
        IPhpModel[] iPhpModelArray;
        IPhpModel[] iPhpModelArray2 = iPhpModelArray = this.compositePhpModel.getModels();
        int n = iPhpModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPhpModel iPhpModel = iPhpModelArray2[n2];
            if (this.contains(iPhpModel, pHPFileData)) {
                File file;
                String string = iPhpModel.getID();
                Path path = new Path(string);
                if (this.variables.indexOf(path) != -1) {
                    file = this.getVriableFile(string);
                    if (file == null) {
                        return null;
                    }
                    File file2 = new File(pHPFileData.getName());
                    if (file.isDirectory()) {
                        return file2;
                    }
                }
                if (this.getIndexOf(file = new File(string)) != -1) {
                    return new File(pHPFileData.getName());
                }
                return null;
            }
            ++n2;
        }
        return null;
    }

    private boolean contains(IPhpModel iPhpModel, PHPFileData pHPFileData) {
        return iPhpModel.getFileData(pHPFileData.getName()) != null;
    }

    public static PHPUserModel getUserModelForIncludeEntry(IIncludePathEntry iIncludePathEntry, PHPProjectModel pHPProjectModel) {
        PHPProjectModel pHPProjectModel2;
        PHPUserModel pHPUserModel = null;
        PHPIncludePathModelManager pHPIncludePathModelManager = (PHPIncludePathModelManager)pHPProjectModel.getModel(COMPOSITE_INCLUDE_PATH_MODEL_ID);
        if (pHPIncludePathModelManager == null) {
            return null;
        }
        if (iIncludePathEntry.getEntryKind() == 4) {
            pHPUserModel = (PHPUserModel)pHPIncludePathModelManager.getModel(iIncludePathEntry.getPath().toString());
        } else if (iIncludePathEntry.getEntryKind() == 1) {
            pHPUserModel = (PHPUserModel)pHPIncludePathModelManager.getModel(iIncludePathEntry.getPath().toOSString());
        } else if (iIncludePathEntry.getEntryKind() == 2 && (pHPProjectModel2 = PHPWorkspaceModelManager.getInstance().getModelForProject((IProject)iIncludePathEntry.getResource())) != null) {
            pHPUserModel = pHPProjectModel2.getPHPUserModel();
        }
        return pHPUserModel;
    }

    private class IncludePathListener
    implements IPhpProjectOptionChangeListener {
        private IncludePathListener() {
        }

        public void notifyOptionChanged(Object object, Object object2) {
            IIncludePathEntry[] iIncludePathEntryArray = (IIncludePathEntry[])object2;
            PHPIncludePathModelManager.this.loadChanges(iIncludePathEntryArray);
        }
    }

    private class ModelWrapper
    extends PhpModelProxy {
        String id;
        IWorkspaceModelListener listener;

        ModelWrapper(IPhpModel iPhpModel) {
            this.model = iPhpModel;
        }

        public String getID() {
            return this.id;
        }

        public void initialize(IProject iProject) {
            this.id = iProject.getName();
            this.initListeners(iProject);
        }

        public void dispose() {
            PHPWorkspaceModelManager.getInstance().removeWorkspaceModelListener(this.id, this.listener);
        }

        private void initListeners(IProject iProject) {
            this.listener = new WorkspaceModelListener();
            PHPWorkspaceModelManager.getInstance().addWorkspaceModelListener(iProject.getName(), this.listener);
        }

        private void updateModelWrapper(IPhpModel iPhpModel) {
            this.model = iPhpModel;
        }

        private class WorkspaceModelListener
        implements IWorkspaceModelListener {
            private WorkspaceModelListener() {
            }

            public void projectModelAdded(IProject iProject) {
                this.updateModel(iProject);
            }

            public void projectModelRemoved(IProject iProject) {
                PHPUserModel pHPUserModel = new PHPUserModel();
                ModelWrapper.this.updateModelWrapper(pHPUserModel);
            }

            public void projectModelChanged(IProject iProject) {
            }

            private void updateModel(IProject iProject) {
                PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iProject);
                IPhpModel iPhpModel = pHPProjectModel == null ? new PHPUserModel() : pHPProjectModel.getModel(PHPUserModel.ID);
                ModelWrapper.this.updateModelWrapper(iPhpModel);
            }
        }
    }

    private class PhpVersionListener
    implements IPreferencesPropagatorListener {
        private PhpVersionListener() {
        }

        public void preferencesEventOccured(PreferencesPropagatorEvent preferencesPropagatorEvent) {
            String string = (String)preferencesPropagatorEvent.getNewValue();
            String string2 = (String)preferencesPropagatorEvent.getOldValue();
            if (string2 == null) {
                string2 = PreferencesSupport.getWorkspacePreferencesValue("phpVersion", PHPCorePlugin.getDefault().getPreferenceStore());
            }
            PHPIncludePathModelManager.this.updatePHPVersion(string2, string);
        }

        public IProject getProject() {
            return PHPIncludePathModelManager.this.project;
        }
    }

    private class ProjectResourceChangeListener
    implements IResourceChangeListener {
        private ProjectResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            if (iResourceChangeEvent.getType() == 1 && iResourceChangeEvent.getSource() instanceof IWorkspace) {
                IResourceDelta[] iResourceDeltaArray;
                IResourceDelta[] iResourceDeltaArray2 = iResourceDeltaArray = iResourceChangeEvent.getDelta().getAffectedChildren();
                int n = iResourceDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject iProject;
                    IResourceDelta iResourceDelta = iResourceDeltaArray2[n2];
                    if ((iResourceDelta.getFlags() & 0x2000) != 0) {
                        iProject = (IProject)iResourceDelta.getResource();
                        IProject iProject2 = ResourcesPlugin.getWorkspace().getRoot().getProject(iResourceDelta.getMovedToPath().lastSegment());
                        this.handleProjectRename(iProject, iProject2);
                    } else if (iResourceDelta.getKind() == 2) {
                        iProject = (IProject)iResourceDelta.getResource();
                        this.handleProjectDeletion((IResource)iProject);
                    }
                    ++n2;
                }
            }
        }

        private void handleProjectRename(IProject iProject, IProject iProject2) {
            if (iProject == PHPIncludePathModelManager.this.project) {
                this.handleProjectDeletion((IResource)iProject);
            } else {
                PHPProjectOptions pHPProjectOptions;
                boolean bl = PHPIncludePathModelManager.this.removeProject((IResource)iProject);
                if (bl) {
                    PHPIncludePathModelManager.this.addProject((IResource)iProject2);
                }
                if ((pHPProjectOptions = PHPProjectOptions.forProject(PHPIncludePathModelManager.this.project)) == null) {
                    return;
                }
                pHPProjectOptions.renameResourceAtIncludePath((IResource)iProject, (IResource)iProject2);
            }
        }

        private void handleProjectDeletion(IResource iResource) {
            if (iResource == PHPIncludePathModelManager.this.project) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener(PHPIncludePathModelManager.this.projectResourcesListener);
                PHPIncludePathModelManager.this.projectResourcesListener = null;
                PHPIncludePathModelManager.this.includeCacheManager.projectRemoved((IProject)iResource);
            } else {
                PHPIncludePathModelManager.this.removeProject(iResource);
                PHPProjectOptions pHPProjectOptions = PHPProjectOptions.forProject(PHPIncludePathModelManager.this.project);
                if (pHPProjectOptions == null) {
                    return;
                }
                pHPProjectOptions.removeResourceFromIncludePath(iResource);
            }
        }
    }
}

