/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.project.build;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.project.build.RSEFolderReporter;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.InternalValidatorManager;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ResourceHandler;
import org.eclipse.wst.validation.internal.TimeEntry;
import org.eclipse.wst.validation.internal.operations.EnabledIncrementalValidatorsOperation;
import org.eclipse.wst.validation.internal.operations.EnabledValidatorsOperation;
import org.eclipse.wst.validation.internal.operations.ValidationBuilder;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public class ValidationManagerWrapper
extends ValidationBuilder {
    public IProject[] build(final int n, final Map map, IProgressMonitor iProgressMonitor) {
        if (n == 9) {
            final IResourceDelta iResourceDelta = this.getDelta(this.getProject());
            RSEFolderReporter rSEFolderReporter = new RSEFolderReporter();
            try {
                iResourceDelta.accept((IResourceDeltaVisitor)rSEFolderReporter);
            }
            catch (CoreException coreException) {
                Logger.logException(coreException);
            }
            if (rSEFolderReporter.isNewJobNeeded()) {
                WorkspaceJob workspaceJob = new WorkspaceJob("Validating"){

                    public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) throws CoreException {
                        ValidationManagerWrapper.this.innerBuild(n, map, iProgressMonitor, iResourceDelta);
                        return Status.OK_STATUS;
                    }
                };
                workspaceJob.setPriority(30);
                workspaceJob.setUser(false);
                workspaceJob.schedule();
                return null;
            }
        }
        return super.build(n, map, iProgressMonitor);
    }

    private IProject[] innerBuild(int n, Map map, IProgressMonitor iProgressMonitor, IResourceDelta iResourceDelta) {
        long l = System.currentTimeMillis();
        int n2 = 0;
        org.eclipse.jem.util.logger.proxy.Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
        IProject iProject = this.getProject();
        IProject[] iProjectArray = this.getAllReferencedProjects(iProject, null);
        try {
            boolean bl;
            if (ValidatorManager.getManager().isSuspended(iProject)) {
                n2 |= 1;
                IProject[] iProjectArray2 = iProjectArray;
                return iProjectArray2;
            }
            ProjectConfiguration projectConfiguration = ConfigurationManager.getManager().getProjectConfiguration(iProject);
            boolean bl2 = bl = n == 6;
            if (!bl && iResourceDelta == null) {
                if (this.isReferencedProjectInDelta(iProjectArray)) {
                    this.performFullBuildForReferencedProjectChanged(iProgressMonitor, projectConfiguration);
                } else {
                    String[] stringArray = new String[]{iProject.getName()};
                    iProgressMonitor.subTask(ResourceHandler.getExternalizedMessage((String)"VBF_STATUS_NULL_DELTA", (String[])stringArray));
                    n2 |= 4;
                }
                IProject[] iProjectArray3 = iProjectArray;
                return iProjectArray3;
            }
            if (bl) {
                this.performFullBuild(iProgressMonitor, projectConfiguration);
            } else {
                if (iResourceDelta.getAffectedChildren().length == 0) {
                    if (this.isReferencedProjectInDelta(iProjectArray)) {
                        this.performFullBuildForReferencedProjectChanged(iProgressMonitor, projectConfiguration);
                    } else {
                        n2 |= 0x10;
                    }
                    IProject[] iProjectArray4 = iProjectArray;
                    return iProjectArray4;
                }
                EnabledIncrementalValidatorsOperation enabledIncrementalValidatorsOperation = new EnabledIncrementalValidatorsOperation(iProject, iResourceDelta, true);
                enabledIncrementalValidatorsOperation.run(iProgressMonitor);
            }
            IProject[] iProjectArray5 = iProjectArray;
            return iProjectArray5;
        }
        catch (InvocationTargetException invocationTargetException) {
            this.logInvocationTargetException(logger, invocationTargetException);
            n2 |= 0x20;
            IProject[] iProjectArray6 = iProjectArray;
            return iProjectArray6;
        }
        catch (Exception exception) {
            this.logBuildError(logger, exception);
            n2 |= 0x40;
            IProject[] iProjectArray7 = iProjectArray;
            return iProjectArray7;
        }
        finally {
            this.referencedProjects = null;
            if (logger.isLoggingLevel(Level.FINE)) {
                this.logBuilderTimeEntry(l, n2, logger, iResourceDelta);
            }
        }
    }

    private void logInvocationTargetException(org.eclipse.jem.util.logger.proxy.Logger logger, InvocationTargetException invocationTargetException) {
        if (logger.isLoggingLevel(Level.SEVERE)) {
            LogEntry logEntry = ValidationPlugin.getLogEntry();
            logEntry.setSourceID("ValidationBuilder::build");
            logEntry.setTargetException((Throwable)invocationTargetException);
            logger.write(Level.SEVERE, (Object)logEntry);
            if (invocationTargetException.getTargetException() != null) {
                logEntry.setTargetException((Throwable)invocationTargetException);
                logger.write(Level.SEVERE, (Object)logEntry);
            }
        }
    }

    private void logBuildError(org.eclipse.jem.util.logger.proxy.Logger logger, Throwable throwable) {
        if (logger.isLoggingLevel(Level.SEVERE) && !(throwable instanceof OperationCanceledException)) {
            LogEntry logEntry = ValidationPlugin.getLogEntry();
            logEntry.setSourceID("ValidationBuilder.build(int, Map, IProgressMonitor)");
            logEntry.setTargetException(throwable);
            logger.write(Level.SEVERE, (Object)logEntry);
        }
    }

    private void logBuilderTimeEntry(long l, int n, org.eclipse.jem.util.logger.proxy.Logger logger, IResourceDelta iResourceDelta) {
        TimeEntry timeEntry = ValidationPlugin.getTimeEntry();
        timeEntry.setSourceID("ValidationBuilder.build(int, Map, IProgressMonitor)");
        timeEntry.setProjectName(this.getProject().getName());
        timeEntry.setExecutionMap(n);
        timeEntry.setElapsedTime(System.currentTimeMillis() - l);
        if (iResourceDelta == null) {
            timeEntry.setDetails("delta == null");
        }
        timeEntry.setToolName("ValidationBuilder");
        logger.write(Level.FINE, (Object)timeEntry);
    }

    private IProject[] getAllReferencedProjects(IProject iProject, Set hashSet) {
        if (hashSet == null) {
            hashSet = new HashSet<IProject>();
        } else {
            if (hashSet.contains(iProject)) {
                return this.getReferencedProjects();
            }
            hashSet.add(iProject);
        }
        if (this.referencedProjects == null) {
            this.referencedProjects = new ArrayList();
        }
        try {
            if (iProject.isAccessible()) {
                IProject[] iProjectArray = iProject.getReferencedProjects();
                this.collectReferecedProject(iProjectArray);
                int n = 0;
                while (n < iProjectArray.length) {
                    IProject iProject2 = iProjectArray[n];
                    this.getAllReferencedProjects(iProject2, hashSet);
                    ++n;
                }
            }
            return this.getReferencedProjects();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private void collectReferecedProject(IProject[] iProjectArray) {
        int n = 0;
        while (n < iProjectArray.length) {
            IProject iProject = iProjectArray[n];
            if (!this.referencedProjects.contains(iProject)) {
                this.referencedProjects.add(iProject);
            }
            ++n;
        }
    }

    private IProject[] getReferencedProjects() {
        IProject[] iProjectArray = new IProject[this.referencedProjects.size()];
        int n = 0;
        while (n < this.referencedProjects.size()) {
            iProjectArray[n] = (IProject)this.referencedProjects.get(n);
            ++n;
        }
        return iProjectArray;
    }

    private boolean isReferencedProjectInDelta(IProject[] iProjectArray) {
        IProject iProject = null;
        int n = 0;
        while (n < iProjectArray.length) {
            iProject = iProjectArray[n];
            IResourceDelta iResourceDelta = this.getDelta(iProject);
            if (iResourceDelta != null && iResourceDelta.getAffectedChildren().length > 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void performFullBuildForReferencedProjectChanged(IProgressMonitor iProgressMonitor, ProjectConfiguration projectConfiguration) throws InvocationTargetException {
        this.performFullBuild(iProgressMonitor, projectConfiguration, true);
    }

    private void performFullBuild(IProgressMonitor iProgressMonitor, ProjectConfiguration projectConfiguration) throws InvocationTargetException {
        this.performFullBuild(iProgressMonitor, projectConfiguration, false);
    }

    private void performFullBuild(IProgressMonitor iProgressMonitor, ProjectConfiguration projectConfiguration, boolean bl) throws InvocationTargetException {
        Object[] objectArray = projectConfiguration.getEnabledFullBuildValidators(true, bl);
        if (objectArray != null && objectArray.length > 0) {
            Set set = InternalValidatorManager.wrapInSet((Object[])objectArray);
            EnabledValidatorsOperation enabledValidatorsOperation = new EnabledValidatorsOperation(this.getProject(), set, true){};
            enabledValidatorsOperation.run(iProgressMonitor);
        }
    }
}

