/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPUserModel;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.preferences.PreferencesSupport;
import org.eclipse.php.internal.core.util.ICachable;
import org.eclipse.php.internal.core.util.IncludeCacheManager;
import org.eclipse.php.internal.core.util.SerializationUtil;
import org.eclipse.php.internal.core.util.StreamUtils;

public class DefaultCacheManager {
    private static final String DATA_MODEL_FILE_NAME = ".dataModel";
    private static final String CACHE_DIR_NAME = ".cache";
    public static final int DEFAULT_CACHE_POLICY = 0;
    public static final int VERSION_IDENTIFIER = 181107;
    private HashMap projectToCacheDir;
    private File sharedCacheDir;
    private PreferencesSupport preferencesSupport;
    private IncludeCacheManager includeCacheManager;
    private Object writeLock = new Object();
    public static DefaultCacheManager instance;

    public static DefaultCacheManager instance() {
        if (instance == null) {
            instance = new DefaultCacheManager();
        }
        return instance;
    }

    private DefaultCacheManager() {
        this.projectToCacheDir = new HashMap();
        IPath iPath = PHPCorePlugin.getDefault().getStateLocation();
        this.sharedCacheDir = new File(iPath.toFile(), CACHE_DIR_NAME);
        if (!this.sharedCacheDir.exists()) {
            this.sharedCacheDir.mkdirs();
        }
        this.preferencesSupport = new PreferencesSupport("org.eclipse.php.core", PHPCorePlugin.getDefault().getPreferenceStore());
        this.includeCacheManager = new IncludeCacheManager(this);
    }

    public IncludeCacheManager getIncludeCacheManager() {
        return this.includeCacheManager;
    }

    public void deleteCacheFromDisk(IProject iProject) {
        File file = this.getCacheDir(iProject);
        File file2 = new File(file, DATA_MODEL_FILE_NAME);
        if (file2.exists()) {
            file2.delete();
        }
    }

    protected File getCacheDir(IProject iProject) {
        File file = (File)this.projectToCacheDir.get(iProject);
        if (file == null && iProject != null) {
            IPath iPath = iProject.getLocation();
            if (iPath == null) {
                return null;
            }
            File file2 = iPath.toFile();
            if (file2 != null) {
                file = new File(file2, CACHE_DIR_NAME);
                this.projectToCacheDir.put(iProject, file);
            }
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public long getSharedCacheModificationTime(IProject iProject, IPhpModel iPhpModel) {
        File file = this.getSharedCacheFile(iProject, iPhpModel);
        return file.lastModified();
    }

    public File getSharedCacheDirectory() {
        return this.sharedCacheDir;
    }

    protected File getSharedCacheFile(IProject iProject, IPhpModel iPhpModel) {
        return this.getSharedCacheFile(iProject, iPhpModel.getID());
    }

    public File getSharedCacheFile(IProject iProject, String string) {
        String string2 = this.preferencesSupport.getPreferencesValue("phpVersion", null, iProject);
        return this.getSharedCacheFile(string2, string);
    }

    public File getSharedCacheFile(String string, String string2) {
        String string3 = String.valueOf(string2.hashCode());
        String string4 = String.valueOf(string3) + '_' + (string != null ? string : "");
        return new File(this.sharedCacheDir, string4);
    }

    public boolean load(IProject iProject, IPhpModel iPhpModel, boolean bl) {
        if (iProject == null || !(iPhpModel instanceof PHPUserModel)) {
            return false;
        }
        PHPUserModel pHPUserModel = (PHPUserModel)iPhpModel;
        File file = null;
        file = bl ? this.getSharedCacheFile(iProject, iPhpModel) : new File(this.getCacheDir(iProject), DATA_MODEL_FILE_NAME);
        return this.innerLoadModel(pHPUserModel, file);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private boolean innerLoadModel(PHPUserModel var1_1, File var2_2) {
        block22: {
            block21: {
                block20: {
                    if (!var2_2.exists()) {
                        return false;
                    }
                    var3_3 = false;
                    var4_4 = null;
                    var5_5 = null;
                    var6_6 = null;
                    var4_4 = new FileInputStream(var2_2);
                    var5_5 = new BufferedInputStream(var4_4, 2048);
                    var6_6 = new DataInputStream(var5_5);
                    var7_7 = var6_6.readInt();
                    if (var7_7 != 181107) ** GOTO lbl33
                    var8_9 = SerializationUtil.deserializePHPFileDataArray(var6_6);
                    if (var8_9.length <= 0) break block20;
                    var9_10 /* !! */  = new Path(var8_9[0].getName());
                    var10_11 = var2_2.getParentFile().getParentFile().getName();
                    if (var10_11.equals(var9_10 /* !! */ .segment(0))) break block20;
lbl18:
                    // 2 sources

                    return false;
                }
                try {
                    var12_21 = var8_9;
                    var11_22 = var8_9.length;
                    var10_12 = 0;
                    while (var10_12 < var11_22) {
                        var9_10 /* !! */  = var12_21[var10_12];
                        var1_1.insert((PHPFileData)var9_10 /* !! */ );
                        ++var10_12;
                    }
                    Runtime.getRuntime().gc();
                    break block21;
lbl33:
                    // 1 sources

                    var3_3 = true;
                }
                catch (FileNotFoundException v0) {
                    StreamUtils.closeStream(var6_6);
                    StreamUtils.closeStream(var5_5);
                    StreamUtils.closeStream(var4_4);
                    if (var3_3) {
                        if (var2_2.delete()) {
                            var14_15 = "Invalid cache version. The cache file was deleted.";
                            PHPCorePlugin.log((IStatus)new Status(1, "org.eclipse.php.core", var14_15, null));
                        } else {
                            var14_16 = "Invalid cache version. Could not delete the file: " + var2_2.getPath();
                            PHPCorePlugin.log((IStatus)new Status(1, "org.eclipse.php.core", var14_16, null));
                        }
                    }
                    break block22;
                }
                catch (Exception var7_8) {
                    try {
                        PHPCorePlugin.log(var7_8);
                        ** continue;
                    }
                    catch (Throwable var13_23) {
                        throw var13_23;
                    }
                    finally {
                        StreamUtils.closeStream(var6_6);
                        StreamUtils.closeStream(var5_5);
                        StreamUtils.closeStream(var4_4);
                        if (var3_3) {
                            if (var2_2.delete()) {
                                var14_13 = "Invalid cache version. The cache file was deleted.";
                                PHPCorePlugin.log((IStatus)new Status(1, "org.eclipse.php.core", var14_13, null));
                            } else {
                                var14_14 = "Invalid cache version. Could not delete the file: " + var2_2.getPath();
                                PHPCorePlugin.log((IStatus)new Status(1, "org.eclipse.php.core", var14_14, null));
                            }
                        }
                    }
                }
            }
            StreamUtils.closeStream(var6_6);
            StreamUtils.closeStream(var5_5);
            StreamUtils.closeStream(var4_4);
            if (var3_3) {
                if (var2_2.delete()) {
                    var14_19 = "Invalid cache version. The cache file was deleted.";
                    PHPCorePlugin.log((IStatus)new Status(1, "org.eclipse.php.core", var14_19, null));
                } else {
                    var14_20 = "Invalid cache version. Could not delete the file: " + var2_2.getPath();
                    PHPCorePlugin.log((IStatus)new Status(1, "org.eclipse.php.core", var14_20, null));
                }
            }
        }
        return var3_3 == false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(IProject iProject, IPhpModel iPhpModel, boolean bl) {
        if (!(iPhpModel instanceof PHPUserModel)) {
            return;
        }
        PHPUserModel pHPUserModel = (PHPUserModel)iPhpModel;
        File file = null;
        if (bl) {
            file = this.getSharedCacheFile(iProject, iPhpModel);
            Object object = this.writeLock;
            synchronized (object) {
                if (file.exists()) {
                    if (System.currentTimeMillis() - file.lastModified() > 60000L) {
                        this.innerSaveModel(pHPUserModel, file);
                    }
                } else {
                    this.innerSaveModel(pHPUserModel, file);
                }
            }
        } else {
            file = new File(this.getCacheDir(iProject), DATA_MODEL_FILE_NAME);
            this.innerSaveModel(pHPUserModel, file);
        }
    }

    private void innerSaveModel(PHPUserModel pHPUserModel, File file) {
        block5: {
            FileOutputStream fileOutputStream = null;
            BufferedOutputStream bufferedOutputStream = null;
            DataOutputStream dataOutputStream = null;
            try {
                try {
                    CodeData[] codeDataArray = pHPUserModel.getFileDatas();
                    ICachable[] iCachableArray = Arrays.asList(codeDataArray).toArray(new ICachable[codeDataArray.length]);
                    fileOutputStream = new FileOutputStream(file);
                    bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 2048);
                    dataOutputStream = new DataOutputStream(bufferedOutputStream);
                    dataOutputStream.writeInt(181107);
                    SerializationUtil.serialize(iCachableArray, dataOutputStream);
                    dataOutputStream.flush();
                }
                catch (IOException iOException) {
                    PHPCorePlugin.log(iOException);
                    StreamUtils.closeStream(dataOutputStream);
                    StreamUtils.closeStream(fileOutputStream);
                    StreamUtils.closeStream(bufferedOutputStream);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(dataOutputStream);
                StreamUtils.closeStream(fileOutputStream);
                StreamUtils.closeStream(bufferedOutputStream);
                throw throwable;
            }
            StreamUtils.closeStream(dataOutputStream);
            StreamUtils.closeStream(fileOutputStream);
            StreamUtils.closeStream(bufferedOutputStream);
        }
        Runtime.getRuntime().gc();
    }
}

